GameStates.FinalGame = function(game) {
    winningCondition = 0;
    score = 0;
    canScore = 0;
    scoreCheck = 0;
}


GameStates.FinalGame.prototype = {

    create: function() {

        var boldText = {
            font: "Open Sans",
            fontSize: "32px",
            fontWeight: "bold",
        }

        var normalText = {
            font: "Open Sans",
            fontSize: "27px",

        }

        var normalText2 = {
            font: "Open Sans",
            fontSize: "35px",
            fill: '#ffffff',
            fontWeight: "bold",
        }

        document.getElementById("listOne").style.display = "none";

        document.getElementById("listTwo").style.display = "none";

        document.getElementById("listThree").style.display = "none";
        document.getElementById("listFour").style.display = "none";

        document.getElementById("listFive").style.display = "none";

        document.getElementById("listSix").style.display = "none";


        backgroundGroup = this.game.add.group();

        this.stage.backgroundColor = '#FF7F50';


        theGuides = this.game.add.sprite(0, 220, 'Guides');
        theGuides2 = this.game.add.sprite(1140, 220, 'Guides');


        theTrack = this.game.add.sprite(0, 375, 'Track');



        drain = this.game.add.sprite(0, 720, 'Drain');

        topBench3 = this.game.add.sprite(0, -50, 'Top_Bench');
        topBench = this.game.add.sprite(0, -325, 'Top_Bench');

        fence = this.game.add.sprite(0, 0, 'Fence');
        fence3 = this.game.add.sprite(0, -325, 'Fence');

        grassPatch = this.game.add.sprite(0, 650, 'Grass_Patch');



        bumpOne = this.game.add.sprite(0, 350, 'Bump_1');
        bumpTwo = this.game.add.sprite(0, 700, 'Bump_2');
        bumpThree = this.game.add.sprite(0, 850, 'Bump_3');

        redH = this.game.add.sprite(1471, 370, 'redH');
        blueH = this.game.add.sprite(1213, 370, 'blueH');
        greenH = this.game.add.sprite(955, 370, 'greenH');

        blueH.scale.setTo(1.2, 1);
        greenH.scale.setTo(1.2, 1);
        redH.scale.setTo(1.2, 1);


        backgroundGroup.add(topBench);

        backgroundGroup.add(topBench3);
        backgroundGroup.add(fence3);

        backgroundGroup.add(fence);
        backgroundGroup.add(theGuides);


        backgroundGroup.add(theTrack);
        backgroundGroup.add(greenH);
        backgroundGroup.add(redH);
        backgroundGroup.add(blueH);


        backgroundGroup.add(drain);

        backgroundGroup.add(bumpOne);
        backgroundGroup.add(bumpTwo);
        backgroundGroup.add(bumpThree);


        backgroundGroup.y = 190;
        backgroundGroup.scale.setTo(0.58);
        theTrack.scale.setTo(1, 0.8);



        targetRed = this.game.add.sprite(860, 250, 'targetRed');
        targetBlue = this.game.add.sprite(710, 250, 'targetBlue');

        targetGreen = this.game.add.sprite(555, 250, 'targetGreen');
        targetBlue.visible = false;
        targetRed.visible = false;

        targetGreen.visible = false;


        headerBox = this.game.add.sprite(10, 0, 'textBox2');
        headerBox.scale.setTo(0.7);
        headerText = this.game.add.text(170, 35, "Aim for the target area!\nScore 500 points to Win!", boldText);



        feedbackBoxBorder = this.game.add.sprite(10, 200, 'textBoxBorder');
        feedbackBox = this.game.add.sprite(10, 200, 'textBox');
        feedbackBoxBorder.scale.setTo(0.55, 0.3);
        feedbackBox.scale.setTo(0.55, 0.3);




        feedbackText = this.game.add.text(40, 220, "FEEDBACK", normalText);


        feedbackGroup = this.game.add.group();
        feedbackGroup.add(feedbackBox);
        feedbackGroup.add(feedbackText);
        feedbackGroup.add(feedbackBoxBorder);
        feedbackGroup.visible = false;



        //Parameters for Car 
        car = this.game.add.sprite(300, 470, '2DCar');
        car.anchor.setTo(0.2);
        car.inputEnabled = true;
        this.physics.enable(car, Phaser.Physics.ARCADE);
        car.input.enableDrag(true);

        car.input.allowVerticalDrag = false;

        car.input.enableSnap(60, 470, true, false);

        car.body.collideWorldBounds = true;


        //Event when car hits worldBounds
        // Enable input.
        car.scale.setTo(0.58);

        car.input.start(0, true);
        car.input.useHandCursor = true;
        car.events.onDragStart.add(onDragStart, this);
        car.events.onDragStop.add(onDragStop, this);
        car.events.onDragUpdate.add(onDragUpdate, this);


        scoreTyre = this.game.add.sprite(-10, 660, 'Tyre');
        scoreText = this.game.add.text(650, 690, 'Score:' + (score * 100), normalText2);

        resetButton = this.game.add.sprite(815, 100, 'reset');
        resetButton.anchor.setTo(0.5);
        resetButton.scale.set(0.9);
        resetButton.inputEnabled = true;
        resetButton.input.useHandCursor = true;
        resetButton.events.onInputOver.add(this.resetOver, this);
        resetButton.events.onInputOut.add(this.resetOut, this);
        resetButton.events.onInputDown.add(this.resetClick, this);
        resetButton.visible = false;



        nextButton = this.game.add.sprite(815, 100, 'next');
        nextButton.anchor.setTo(0.5);
        nextButton.scale.set(0.9);
        nextButton.inputEnabled = true;
        nextButton.input.useHandCursor = true;
        nextButton.events.onInputOver.add(this.nextOver, this);
        nextButton.events.onInputOut.add(this.nextOut, this);
        nextButton.events.onInputDown.add(this.nextClick, this);
        nextButton.visible = false;
        nextAnim = nextButton.animations.add('play', [0, 1]);
        nextButton.animations.play('play', 1, true);


        this.choiceRandomizer();




        function onDragStart(car, pointer) {
            car.body.moves = false;
            car.body.velocity.setTo(0, 0);
            car.body.allowGravity = false;
        }


        function checkOverlap(spriteA, spriteB) {

            var boundsA = spriteA.getBounds();
            var boundsB = spriteB.getBounds();

            return Phaser.Rectangle.intersects(boundsA, boundsB);

        }

        function onDragUpdate(car, pointer) {

            if (car.x > 400) {
                console.log("Halt");
                car.x = 300;
                distanceOfDrive = 0;
            }

            if (car.x <= 50) {
                car.x = 60;
            }

            if (car.x >= 220 && car.x <= 285) {
                distanceOfDrive = 0;

            }



            if (car.x >= 285) {
                distanceOfDrive = 0;
                timeToDrive = 0;
                elasticBand.frame = 0;

            }




            if (car.x >= 180 && car.x <= 205) {
                //Distance A
                car.x = 190;
                console.log("Distance A");
                distanceOfDrive = 370;
                timeToDrive = 300;
                elasticBand.frame = 5;
                elasticBandPull = elasticBand.animations.add('pull', [5, 13, 14, 15, 16, 17, 18, 19]);



            } else if (car.x >= 110 && car.x <= 130) {
                //Distance B     
                car.x = 130;
                console.log("Distance B");
                distanceOfDrive = 600;
                timeToDrive = 275;
                elasticBand.frame = 6;
                elasticBandPull = elasticBand.animations.add('pull', [6, 12, 13, 14, 15, 16, 17, 18, 19]);

                if (car.x >= 140) {
                    distanceOfDrive = 560;
                }


            } else if (car.x >= 10 && car.x <= 60) {
                //distance C
                console.log("Distance C");
                distanceOfDrive = 790;
                timeToDrive = 250;
                elasticBand.frame = 7;
                elasticBandPull = elasticBand.animations.add('pull', [10, 11, 12, 13, 14, 15, 16, 17, 18, 19]);

                if (car.x >= 70) {
                    distanceOfDrive = 760;
                }


            }
        }


        function onDragStop() {
            //let go
            car.body.moves = true;
            car.body.moveTo(timeToDrive, distanceOfDrive, Phaser.ANGLE_RIGHT);
            car.input.inputEnabled = false;

            elasticBand.animations.play('pull', 20, false);
            scoreCheck = 1;

        }



    },

    choiceRandomizer: function() {
        console.log("RANDOM");

        targetBlue.visible = false;
        targetRed.visible = false;

        targetGreen.visible = false;


        choiceSelection = (Math.floor(Math.random() * 3) + 1);
        bandSelection = (Math.floor(Math.random() * 2) + 1);


        if (choiceSelection == 1) {
            winningCondition = 1;
            targetGreen.visible = true;
            console.log("Green to win");

        } else if (choiceSelection == 2) {
            winningCondition = 2;
            targetBlue.visible = true;
            console.log("Blue to win");


        } else if (choiceSelection == 3) {
            winningCondition = 3;
            targetRed.visible = true;
            console.log("Red to win");
        }



        if (bandSelection == 1) {
            elasticBand = this.game.add.sprite(10, 405, 'band');

        } else if (bandSelection == 2) {
            elasticBand = this.game.add.sprite(0, 430, 'spring');


        }


    },
    nextOver: function() {
        nextButton.animations.stop(null);

        nextButton.frame = 2;
    },
    nextOut: function() {

        nextButton.frame = 0;
        nextButton.animations.play('play', 2, true);
    },
    nextClick: function() {
        this.state.start("End");

    },

    resetOver: function() {
        resetButton.frame = 2;
    },
    resetOut: function() {
        resetButton.frame = 0;
    },
    resetClick: function() {
        car.x = 300;
        car.inputEnabled = true;
        car.input.useHandCursor = true;
        car.enableDrag = true;
        car.body.enable = true
        car.input.enableDrag(true);
        scoreCheck = 0;

        this.game.time.events.add(100, delay, this);

        function delay() {
            elasticBand.destroy();
            this.choiceRandomizer();


        }
        if (canScore == 1) {

            canScore = 0;
        }

        // if (score == 5) {
        //     this.state.start("End");
        // }

    },

    update: function() {

        if (car.x >= 400) {
            resetButton.visible = true;
            car.inputEnabled = false;
            car.disableDrag = true;
        }

        scoreText.text = 'Score: ' + (score * 100) + ' / 500';

        if (score == 5) {
            feedbackText.text = "You beaten the game! Please proceed to the next screen";
            resetButton.visible = false;
            nextButton.visible = true;
        }

        if (scoreCheck == 1) {
            this.game.time.events.add(300, checkScore, this);
        } else {

            resetButton.visible = false;
            feedbackGroup.visible = false;

        }



        function checkScore() {

            if (winningCondition == 1) {
                if (checkOverlap(car, greenH)) {
                    console.log("green");
                    canScore = 1;
                    winningCondition = 0;
                    feedbackText.text = "Point Scored!"
                    feedbackGroup.visible = true;
                    score++;

                } else {
                    canScore = 0;

                    if (checkOverlap(car, blueH) || checkOverlap(car, redH)) {

                        feedbackGroup.visible = true;

                        feedbackText.text = "How do you make the toy car move a longer distance? When the band\nwas streched more, it had more potential energy.";

                    }

                }
            } else if (winningCondition == 2) {

                if (checkOverlap(car, blueH)) {
                    console.log("bluee");
                    canScore = 1;
                    winningCondition = 0;
                    score++;
                    feedbackText.text = "Point Scored!"
                    feedbackGroup.visible = true;
                } else {
                    canScore = 0;

                    if (checkOverlap(car, greenH)) {
                        feedbackGroup.visible = true;

                        feedbackText.text = "How do you make the toy car move a shorter distance? When the band\nwas stretched less, it had less potential energy.";
                    } else if (checkOverlap(car, redH)) {
                        feedbackGroup.visible = true;

                        feedbackText.text = "How do you make the toy car move a longer distance? When the band\nwas stretched more, it had more potential energy.";
                    }

                }

            } else if (winningCondition == 3) {

                if (checkOverlap(car, redH)) {
                    console.log("red");
                    canScore = 1;
                    winningCondition = 0;
                    score++;
                    feedbackText.text = "Point Scored!"
                    feedbackGroup.visible = true;
                } else {
                    canScore = 0;

                    if (checkOverlap(car, greenH) || checkOverlap(car, blueH)) {
                        feedbackGroup.visible = true;

                        feedbackText.text = "How do you make the toy car move a shorter distance? When the band\nwas stretched less, it had less potential energy.";
                    }
                }
            }
            this.game.time.events.remove(checkScore);

        }


        //add a x range check to prevent this}


        function checkOverlap(spriteA, spriteB) {

            var boundsA = spriteA.getBounds();
            var boundsB = spriteB.getBounds();

            return Phaser.Rectangle.intersects(boundsA, boundsB);

        }


    }



}