/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bson.BSONDecoder;
import org.bson.BSONEncoder;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.Transformer;
import org.bson.util.ClassMap;

public class BSON {
    static final Logger LOGGER = Logger.getLogger("org.bson.BSON");
    private static boolean _encodeHooks = false;
    private static boolean _decodeHooks = false;
    static ClassMap<List<Transformer>> _encodingHooks = new ClassMap();
    static ClassMap<List<Transformer>> _decodingHooks = new ClassMap();
    protected static Charset _utf8 = Charset.forName("UTF-8");
    static ThreadLocal<BSONEncoder> _staticEncoder = new ThreadLocal<BSONEncoder>(){

        @Override
        protected BSONEncoder initialValue() {
            return new BasicBSONEncoder();
        }
    };
    static ThreadLocal<BSONDecoder> _staticDecoder = new ThreadLocal<BSONDecoder>(){

        @Override
        protected BSONDecoder initialValue() {
            return new BasicBSONDecoder();
        }
    };

    public static int regexFlags(String flags) {
        flags = flags.toLowerCase();
        int fint = 0;
        for (int i = 0; i < flags.length(); ++i) {
            RegexFlag flag = RegexFlag.getByCharacter(flags.charAt(i));
            if (flag != null) {
                fint |= flag.javaFlag;
                if (flag.unsupported == null) continue;
                BSON._warnUnsupportedRegex(flag.unsupported);
                continue;
            }
            throw new IllegalArgumentException("unrecognized flag [" + flags.charAt(i) + "] " + flags.charAt(i));
        }
        return fint;
    }

    public static String regexFlags(int flags) {
        StringBuilder buf = new StringBuilder();
        for (RegexFlag flag : RegexFlag.values()) {
            if ((flags & flag.javaFlag) <= 0) continue;
            buf.append(flag.flagChar);
            flags -= flag.javaFlag;
        }
        if (flags > 0) {
            throw new IllegalArgumentException("some flags could not be recognized.");
        }
        return buf.toString();
    }

    private static void _warnUnsupportedRegex(String flag) {
        LOGGER.info("flag " + flag + " not supported by db.");
    }

    public static Object applyEncodingHooks(Object o) {
        if (!BSON._anyHooks()) {
            return o;
        }
        if (_encodingHooks.size() == 0 || o == null) {
            return o;
        }
        List<Transformer> l = _encodingHooks.get(o.getClass());
        if (l != null) {
            for (Transformer t : l) {
                o = t.transform(o);
            }
        }
        return o;
    }

    public static Object applyDecodingHooks(Object o) {
        if (!BSON._anyHooks() || o == null) {
            return o;
        }
        List<Transformer> l = _decodingHooks.get(o.getClass());
        if (l != null) {
            for (Transformer t : l) {
                o = t.transform(o);
            }
        }
        return o;
    }

    private static boolean _anyHooks() {
        return _encodeHooks || _decodeHooks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegexFlag
    extends Enum<RegexFlag> {
        public static final /* enum */ RegexFlag CANON_EQ = new RegexFlag(128, 'c', "Pattern.CANON_EQ");
        public static final /* enum */ RegexFlag UNIX_LINES = new RegexFlag(1, 'd', "Pattern.UNIX_LINES");
        public static final /* enum */ RegexFlag GLOBAL = new RegexFlag(256, 'g', null);
        public static final /* enum */ RegexFlag CASE_INSENSITIVE = new RegexFlag(2, 'i', null);
        public static final /* enum */ RegexFlag MULTILINE = new RegexFlag(8, 'm', null);
        public static final /* enum */ RegexFlag DOTALL = new RegexFlag(32, 's', "Pattern.DOTALL");
        public static final /* enum */ RegexFlag LITERAL = new RegexFlag(16, 't', "Pattern.LITERAL");
        public static final /* enum */ RegexFlag UNICODE_CASE = new RegexFlag(64, 'u', "Pattern.UNICODE_CASE");
        public static final /* enum */ RegexFlag COMMENTS = new RegexFlag(4, 'x', null);
        private static final Map<Character, RegexFlag> byCharacter;
        public final int javaFlag;
        public final char flagChar;
        public final String unsupported;
        private static final /* synthetic */ RegexFlag[] $VALUES;

        public static RegexFlag[] values() {
            return (RegexFlag[])$VALUES.clone();
        }

        public static RegexFlag getByCharacter(char ch) {
            return byCharacter.get(Character.valueOf(ch));
        }

        private RegexFlag(int f, char ch, String u) {
            this.javaFlag = f;
            this.flagChar = ch;
            this.unsupported = u;
        }

        static {
            $VALUES = new RegexFlag[]{CANON_EQ, UNIX_LINES, GLOBAL, CASE_INSENSITIVE, MULTILINE, DOTALL, LITERAL, UNICODE_CASE, COMMENTS};
            byCharacter = new HashMap<Character, RegexFlag>();
            for (RegexFlag flag : RegexFlag.values()) {
                byCharacter.put(Character.valueOf(flag.flagChar), flag);
            }
        }
    }
}

