/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.data.Either;
import fj.data.Option;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validation<E, T>
implements Iterable<T> {
    private final Either<E, T> e;
    public static final F<String, Validation<NumberFormatException, Byte>> parseByte = new F<String, Validation<NumberFormatException, Byte>>(){

        @Override
        public Validation<NumberFormatException, Byte> f(String string) {
            return Validation.parseByte(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Double>> parseDouble = new F<String, Validation<NumberFormatException, Double>>(){

        @Override
        public Validation<NumberFormatException, Double> f(String string) {
            return Validation.parseDouble(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Float>> parseFloat = new F<String, Validation<NumberFormatException, Float>>(){

        @Override
        public Validation<NumberFormatException, Float> f(String string) {
            return Validation.parseFloat(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Integer>> parseInt = new F<String, Validation<NumberFormatException, Integer>>(){

        @Override
        public Validation<NumberFormatException, Integer> f(String string) {
            return Validation.parseInt(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Long>> parseLong = new F<String, Validation<NumberFormatException, Long>>(){

        @Override
        public Validation<NumberFormatException, Long> f(String string) {
            return Validation.parseLong(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Short>> parseShort = new F<String, Validation<NumberFormatException, Short>>(){

        @Override
        public Validation<NumberFormatException, Short> f(String string) {
            return Validation.parseShort(string);
        }
    };

    private Validation(Either<E, T> either) {
        this.e = either;
    }

    public Either<E, T> toEither() {
        return this.e;
    }

    public Option<T> toOption() {
        return this.e.right().toOption();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toEither().right().iterator();
    }

    public static <E, T> Validation<E, T> validation(Either<E, T> either) {
        return new Validation<E, T>(either);
    }

    public static <E, T> Validation<E, T> success(T t) {
        return Validation.validation(Either.right(t));
    }

    public static <E, T> Validation<E, T> fail(E e) {
        return Validation.validation(Either.left(e));
    }

    public static Validation<NumberFormatException, Byte> parseByte(String string) {
        try {
            return Validation.success(Byte.parseByte(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Double> parseDouble(String string) {
        try {
            return Validation.success(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Float> parseFloat(String string) {
        try {
            return Validation.success(Float.valueOf(Float.parseFloat(string)));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Integer> parseInt(String string) {
        try {
            return Validation.success(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Long> parseLong(String string) {
        try {
            return Validation.success(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Short> parseShort(String string) {
        try {
            return Validation.success(Short.parseShort(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }
}

