/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.P;
import fj.P1;
import fj.data.List;
import fj.data.Option;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Either<A, B> {
    private Either() {
    }

    public final RightProjection<A, B> right() {
        return new RightProjection(this);
    }

    public abstract boolean isRight();

    public static <A, B> Either<A, B> left(A a) {
        return new Left(a);
    }

    public static <A, B> Either<A, B> right(B b) {
        return new Right(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Left<A, B>
    extends Either<A, B> {
        private final A a;

        Left(A a) {
            this.a = a;
        }

        @Override
        public boolean isRight() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Right<A, B>
    extends Either<A, B> {
        private final B b;

        Right(B b) {
            this.b = b;
        }

        @Override
        public boolean isRight() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class RightProjection<A, B>
    implements Iterable<B> {
        private final Either<A, B> e;

        private RightProjection(Either<A, B> either2) {
            this.e = either2;
        }

        @Override
        public Iterator<B> iterator() {
            return this.toCollection().iterator();
        }

        public B valueE(P1<String> p1) {
            if (this.e.isRight()) {
                return (B)((Right)this.e).b;
            }
            throw Bottom.error(p1._1());
        }

        public B value() {
            return this.valueE(P.p("right.value on Left"));
        }

        public List<B> toList() {
            return Either.this.isRight() ? List.single(this.value()) : List.nil();
        }

        public Option<B> toOption() {
            return Either.this.isRight() ? Option.some(this.value()) : Option.none();
        }

        public Collection<B> toCollection() {
            return this.toList().toCollection();
        }
    }
}

