/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.data.List;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array<A>
implements Iterable<A> {
    private final Object[] a;

    private Array(Object[] objectArray) {
        this.a = objectArray;
    }

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public A[] array(Class<A[]> clazz) {
        return Array.copyOf(this.a, this.a.length, clazz);
    }

    public List<A> toList() {
        List<Object> list = List.nil();
        for (int i = this.a.length - 1; i >= 0; --i) {
            list = list.cons(this.a[i]);
        }
        return list;
    }

    public static <A> Array<A> array(A ... AArray) {
        return new Array<A>(AArray);
    }

    public Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < Array.this.a.length;
                    }

                    @Override
                    public A next() {
                        if (this.i >= Array.this.a.length) {
                            throw new NoSuchElementException();
                        }
                        Object object = Array.this.a[this.i];
                        ++this.i;
                        return object;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Array.this.a.length;
            }
        };
    }

    public static <T, U> T[] copyOf(U[] UArray, int n, Class<? extends T[]> clazz) {
        Object[] objectArray = clazz == Object[].class ? new Object[n] : (Object[])java.lang.reflect.Array.newInstance(clazz.getComponentType(), n);
        System.arraycopy(UArray, 0, objectArray, 0, Math.min(UArray.length, n));
        return objectArray;
    }
}

