/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Ord;
import fj.Unit;
import fj.data.List;
import fj.data.Natural;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Semigroup<A> {
    private final F<A, F<A, A>> sum;
    public static final Semigroup<Integer> intAdditionSemigroup = Semigroup.semigroup(new F2<Integer, Integer, Integer>(){

        @Override
        public Integer f(Integer n, Integer n2) {
            return n + n2;
        }
    });
    public static final Semigroup<Double> doubleAdditionSemigroup = Semigroup.semigroup(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double d, Double d2) {
            return d + d2;
        }
    });
    public static final Semigroup<Integer> intMultiplicationSemigroup = Semigroup.semigroup(new F2<Integer, Integer, Integer>(){

        @Override
        public Integer f(Integer n, Integer n2) {
            return n * n2;
        }
    });
    public static final Semigroup<Double> doubleMultiplicationSemigroup = Semigroup.semigroup(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double d, Double d2) {
            return d * d2;
        }
    });
    public static final Semigroup<Integer> intMaximumSemigroup = Semigroup.semigroup(Ord.intOrd.max);
    public static final Semigroup<Integer> intMinimumSemigroup = Semigroup.semigroup(Ord.intOrd.min);
    public static final Semigroup<BigInteger> bigintAdditionSemigroup = Semigroup.semigroup(new F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger f(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger.add(bigInteger2);
        }
    });
    public static final Semigroup<BigInteger> bigintMultiplicationSemigroup = Semigroup.semigroup(new F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger f(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger.multiply(bigInteger2);
        }
    });
    public static final Semigroup<BigInteger> bigintMaximumSemigroup = Semigroup.semigroup(Ord.bigintOrd.max);
    public static final Semigroup<BigInteger> bigintMinimumSemigroup = Semigroup.semigroup(Ord.bigintOrd.min);
    public static final Semigroup<BigDecimal> bigdecimalAdditionSemigroup = Semigroup.semigroup(new F2<BigDecimal, BigDecimal, BigDecimal>(){

        @Override
        public BigDecimal f(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return bigDecimal.add(bigDecimal2);
        }
    });
    public static final Semigroup<BigDecimal> bigdecimalMultiplicationSemigroup = Semigroup.semigroup(new F2<BigDecimal, BigDecimal, BigDecimal>(){

        @Override
        public BigDecimal f(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return bigDecimal.multiply(bigDecimal2);
        }
    });
    public static final Semigroup<BigDecimal> bigDecimalMaximumSemigroup = Semigroup.semigroup(Ord.bigdecimalOrd.max);
    public static final Semigroup<BigDecimal> bigDecimalMinimumSemigroup = Semigroup.semigroup(Ord.bigdecimalOrd.min);
    public static final Semigroup<Natural> naturalMultiplicationSemigroup = Semigroup.semigroup(new F2<Natural, Natural, Natural>(){

        @Override
        public Natural f(Natural natural, Natural natural2) {
            return natural.multiply(natural2);
        }
    });
    public static final Semigroup<Natural> naturalAdditionSemigroup = Semigroup.semigroup(new F2<Natural, Natural, Natural>(){

        @Override
        public Natural f(Natural natural, Natural natural2) {
            return natural.add(natural2);
        }
    });
    public static final Semigroup<Natural> naturalMaximumSemigroup = Semigroup.semigroup(Ord.naturalOrd.max);
    public static final Semigroup<Natural> naturalMinimumSemigroup = Semigroup.semigroup(Ord.naturalOrd.min);
    public static final Semigroup<Long> longAdditionSemigroup = Semigroup.semigroup(new F2<Long, Long, Long>(){

        @Override
        public Long f(Long l, Long l2) {
            return l + l2;
        }
    });
    public static final Semigroup<Long> longMultiplicationSemigroup = Semigroup.semigroup(new F2<Long, Long, Long>(){

        @Override
        public Long f(Long l, Long l2) {
            return l * l2;
        }
    });
    public static final Semigroup<Long> longMaximumSemigroup = Semigroup.semigroup(Ord.longOrd.max);
    public static final Semigroup<Long> longMinimumSemigroup = Semigroup.semigroup(Ord.longOrd.min);
    public static final Semigroup<Boolean> disjunctionSemigroup = Semigroup.semigroup(new F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean f(Boolean bl, Boolean bl2) {
            return bl != false || bl2 != false;
        }
    });
    public static final Semigroup<Boolean> exclusiveDisjunctionSemiGroup = Semigroup.semigroup(new F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean f(Boolean bl, Boolean bl2) {
            return bl != false && bl2 == false || bl == false && bl2 != false;
        }
    });
    public static final Semigroup<Boolean> conjunctionSemigroup = Semigroup.semigroup(new F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean f(Boolean bl, Boolean bl2) {
            return bl != false && bl2 != false;
        }
    });
    public static final Semigroup<String> stringSemigroup = Semigroup.semigroup(new F2<String, String, String>(){

        @Override
        public String f(String string, String string2) {
            return string + string2;
        }
    });
    public static final Semigroup<StringBuffer> stringBufferSemigroup = Semigroup.semigroup(new F2<StringBuffer, StringBuffer, StringBuffer>(){

        @Override
        public StringBuffer f(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            return new StringBuffer(stringBuffer).append(stringBuffer2);
        }
    });
    public static final Semigroup<StringBuilder> stringBuilderSemigroup = Semigroup.semigroup(new F2<StringBuilder, StringBuilder, StringBuilder>(){

        @Override
        public StringBuilder f(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            return new StringBuilder(stringBuilder).append((CharSequence)stringBuilder2);
        }
    });
    public static final Semigroup<Unit> unitSemigroup = Semigroup.semigroup(new F2<Unit, Unit, Unit>(){

        @Override
        public Unit f(Unit unit, Unit unit2) {
            return Unit.unit();
        }
    });

    private Semigroup(F<A, F<A, A>> f) {
        this.sum = f;
    }

    public F<A, F<A, A>> sum() {
        return this.sum;
    }

    public static <A> Semigroup<A> semigroup(F<A, F<A, A>> f) {
        return new Semigroup<A>(f);
    }

    public static <A> Semigroup<A> semigroup(F2<A, A, A> f2) {
        return new Semigroup<A>(Function.curry(f2));
    }

    public static <A> Semigroup<List<A>> listSemigroup() {
        return Semigroup.semigroup(new F2<List<A>, List<A>, List<A>>(){

            @Override
            public List<A> f(List<A> list, List<A> list2) {
                return list.append(list2);
            }
        });
    }

    public static <A> Semigroup<Stream<A>> streamSemigroup() {
        return Semigroup.semigroup(new F2<Stream<A>, Stream<A>, Stream<A>>(){

            @Override
            public Stream<A> f(Stream<A> stream, Stream<A> stream2) {
                return stream.append(stream2);
            }
        });
    }
}

