/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Ordering;
import fj.Unit;
import fj.data.Natural;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ord<A> {
    private final F<A, F<A, Ordering>> f;
    public final F<A, F<A, A>> max = Function.curry(new F2<A, A, A>(){

        @Override
        public A f(A a, A a2) {
            return Ord.this.max(a, a2);
        }
    });
    public final F<A, F<A, A>> min = Function.curry(new F2<A, A, A>(){

        @Override
        public A f(A a, A a2) {
            return Ord.this.min(a, a2);
        }
    });
    public static final Ord<Boolean> booleanOrd = new Ord<Boolean>(new F<Boolean, F<Boolean, Ordering>>(){

        @Override
        public F<Boolean, Ordering> f(final Boolean bl) {
            return new F<Boolean, Ordering>(){

                @Override
                public Ordering f(Boolean bl2) {
                    int n = bl.compareTo(bl2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Byte> byteOrd = new Ord<Byte>(new F<Byte, F<Byte, Ordering>>(){

        @Override
        public F<Byte, Ordering> f(final Byte by) {
            return new F<Byte, Ordering>(){

                @Override
                public Ordering f(Byte by2) {
                    int n = by.compareTo(by2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Character> charOrd = new Ord<Character>(new F<Character, F<Character, Ordering>>(){

        @Override
        public F<Character, Ordering> f(final Character c) {
            return new F<Character, Ordering>(){

                @Override
                public Ordering f(Character c2) {
                    int n = c.compareTo(c2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Double> doubleOrd = new Ord<Double>(new F<Double, F<Double, Ordering>>(){

        @Override
        public F<Double, Ordering> f(final Double d) {
            return new F<Double, Ordering>(){

                @Override
                public Ordering f(Double d2) {
                    int n = d.compareTo(d2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Float> floatOrd = new Ord<Float>(new F<Float, F<Float, Ordering>>(){

        @Override
        public F<Float, Ordering> f(final Float f) {
            return new F<Float, Ordering>(){

                @Override
                public Ordering f(Float f2) {
                    int n = f.compareTo(f2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Integer> intOrd = new Ord<Integer>(new F<Integer, F<Integer, Ordering>>(){

        @Override
        public F<Integer, Ordering> f(final Integer n) {
            return new F<Integer, Ordering>(){

                @Override
                public Ordering f(Integer n3) {
                    int n2 = n.compareTo(n3);
                    return n2 < 0 ? Ordering.LT : (n2 == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<BigInteger> bigintOrd = new Ord<BigInteger>(new F<BigInteger, F<BigInteger, Ordering>>(){

        @Override
        public F<BigInteger, Ordering> f(final BigInteger bigInteger) {
            return new F<BigInteger, Ordering>(){

                @Override
                public Ordering f(BigInteger bigInteger2) {
                    int n = bigInteger.compareTo(bigInteger2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<BigDecimal> bigdecimalOrd = new Ord<BigDecimal>(new F<BigDecimal, F<BigDecimal, Ordering>>(){

        @Override
        public F<BigDecimal, Ordering> f(final BigDecimal bigDecimal) {
            return new F<BigDecimal, Ordering>(){

                @Override
                public Ordering f(BigDecimal bigDecimal2) {
                    int n = bigDecimal.compareTo(bigDecimal2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Long> longOrd = new Ord<Long>(new F<Long, F<Long, Ordering>>(){

        @Override
        public F<Long, Ordering> f(final Long l) {
            return new F<Long, Ordering>(){

                @Override
                public Ordering f(Long l2) {
                    int n = l.compareTo(l2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Short> shortOrd = new Ord<Short>(new F<Short, F<Short, Ordering>>(){

        @Override
        public F<Short, Ordering> f(final Short s) {
            return new F<Short, Ordering>(){

                @Override
                public Ordering f(Short s2) {
                    int n = s.compareTo(s2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Ordering> orderingOrd = new Ord<Ordering>(Function.curry(new F2<Ordering, Ordering, Ordering>(){

        @Override
        public Ordering f(Ordering ordering, Ordering ordering2) {
            return ordering == ordering2 ? Ordering.EQ : (ordering == Ordering.LT ? Ordering.LT : (ordering2 == Ordering.LT ? Ordering.GT : (ordering == Ordering.EQ ? Ordering.LT : Ordering.GT)));
        }
    }));
    public static final Ord<String> stringOrd = new Ord<String>(new F<String, F<String, Ordering>>(){

        @Override
        public F<String, Ordering> f(final String string) {
            return new F<String, Ordering>(){

                @Override
                public Ordering f(String string2) {
                    int n = string.compareTo(string2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<StringBuffer> stringBufferOrd = new Ord<StringBuffer>(new F<StringBuffer, F<StringBuffer, Ordering>>(){

        @Override
        public F<StringBuffer, Ordering> f(final StringBuffer stringBuffer) {
            return new F<StringBuffer, Ordering>(){

                @Override
                public Ordering f(StringBuffer stringBuffer2) {
                    return stringOrd.compare(stringBuffer.toString(), stringBuffer2.toString());
                }
            };
        }
    });
    public static final Ord<StringBuilder> stringBuilderOrd = new Ord<StringBuilder>(new F<StringBuilder, F<StringBuilder, Ordering>>(){

        @Override
        public F<StringBuilder, Ordering> f(final StringBuilder stringBuilder) {
            return new F<StringBuilder, Ordering>(){

                @Override
                public Ordering f(StringBuilder stringBuilder2) {
                    return stringOrd.compare(stringBuilder.toString(), stringBuilder2.toString());
                }
            };
        }
    });
    public static final Ord<Unit> unitOrd = Ord.ord(Function.curry(new F2<Unit, Unit, Ordering>(){

        @Override
        public Ordering f(Unit unit, Unit unit2) {
            return Ordering.EQ;
        }
    }));
    public static final Ord<Natural> naturalOrd = bigintOrd.comap(Natural.bigIntegerValue);

    private Ord(F<A, F<A, Ordering>> f) {
        this.f = f;
    }

    public Ordering compare(A a, A a2) {
        return this.f.f(a).f(a2);
    }

    public boolean eq(A a, A a2) {
        return this.compare(a, a2) == Ordering.EQ;
    }

    public <B> Ord<B> comap(F<B, A> f) {
        return Ord.ord(f.andThen().o(this.f).o(f));
    }

    public boolean isLessThan(A a, A a2) {
        return this.compare(a, a2) == Ordering.LT;
    }

    public boolean isGreaterThan(A a, A a2) {
        return this.compare(a, a2) == Ordering.GT;
    }

    public A max(A a, A a2) {
        return this.isGreaterThan(a, a2) ? a : a2;
    }

    public A min(A a, A a2) {
        return this.isLessThan(a, a2) ? a : a2;
    }

    public static <A> Ord<A> ord(F<A, F<A, Ordering>> f) {
        return new Ord<A>(f);
    }
}

