/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F2;
import fj.P1;
import fj.Semigroup;
import fj.data.List;
import fj.data.Natural;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Monoid<A> {
    private final F<A, F<A, A>> sum;
    private final A zero;
    public static final Monoid<Integer> intAdditionMonoid = Monoid.monoid(Semigroup.intAdditionSemigroup, 0);
    public static final Monoid<Integer> intMultiplicationMonoid = Monoid.monoid(Semigroup.intMultiplicationSemigroup, 1);
    public static final Monoid<Double> doubleAdditionMonoid = Monoid.monoid(Semigroup.doubleAdditionSemigroup, 0.0);
    public static final Monoid<Double> doubleMultiplicationMonoid = Monoid.monoid(Semigroup.doubleMultiplicationSemigroup, 1.0);
    public static final Monoid<BigInteger> bigintAdditionMonoid = Monoid.monoid(Semigroup.bigintAdditionSemigroup, BigInteger.ZERO);
    public static final Monoid<BigInteger> bigintMultiplicationMonoid = Monoid.monoid(Semigroup.bigintMultiplicationSemigroup, BigInteger.ONE);
    public static final Monoid<BigDecimal> bigdecimalAdditionMonoid = Monoid.monoid(Semigroup.bigdecimalAdditionSemigroup, BigDecimal.ZERO);
    public static final Monoid<BigDecimal> bigdecimalMultiplicationMonoid = Monoid.monoid(Semigroup.bigdecimalMultiplicationSemigroup, BigDecimal.ONE);
    public static final Monoid<Natural> naturalAdditionMonoid = Monoid.monoid(Semigroup.naturalAdditionSemigroup, Natural.ZERO);
    public static final Monoid<Natural> naturalMultiplicationMonoid = Monoid.monoid(Semigroup.naturalMultiplicationSemigroup, Natural.ONE);
    public static final Monoid<Long> longAdditionMonoid = Monoid.monoid(Semigroup.longAdditionSemigroup, 0L);
    public static final Monoid<Long> longMultiplicationMonoid = Monoid.monoid(Semigroup.longMultiplicationSemigroup, 1L);
    public static final Monoid<Boolean> disjunctionMonoid = Monoid.monoid(Semigroup.disjunctionSemigroup, false);
    public static final Monoid<Boolean> exclusiveDisjunctionMonoid = Monoid.monoid(Semigroup.exclusiveDisjunctionSemiGroup, false);
    public static final Monoid<Boolean> conjunctionMonoid = Monoid.monoid(Semigroup.conjunctionSemigroup, true);
    public static final Monoid<String> stringMonoid = Monoid.monoid(Semigroup.stringSemigroup, "");
    public static final Monoid<StringBuffer> stringBufferMonoid = Monoid.monoid(Semigroup.stringBufferSemigroup, new StringBuffer());
    public static final Monoid<StringBuilder> stringBuilderMonoid = Monoid.monoid(Semigroup.stringBuilderSemigroup, new StringBuilder());

    private Monoid(F<A, F<A, A>> f, A a) {
        this.sum = f;
        this.zero = a;
    }

    public A sum(A a, A a2) {
        return this.sum.f(a).f(a2);
    }

    public A zero() {
        return this.zero;
    }

    public A sumRight(Stream<A> stream) {
        return stream.foldRight(new F2<A, P1<A>, A>(){

            @Override
            public A f(A a, P1<A> p1) {
                return Monoid.this.sum(a, p1._1());
            }
        }, this.zero);
    }

    public static <A> Monoid<A> monoid(Semigroup<A> semigroup, A a) {
        return new Monoid<A>(semigroup.sum(), a);
    }

    public static <A> Monoid<List<A>> listMonoid() {
        return Monoid.monoid(Semigroup.listSemigroup(), List.nil());
    }

    public static <A> Monoid<Stream<A>> streamMonoid() {
        return Monoid.monoid(Semigroup.streamSemigroup(), Stream.nil());
    }
}

