/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.data.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Hash<A> {
    private final F<A, Integer> f;
    public static final Hash<Boolean> booleanHash = Hash.anyHash();
    public static final Hash<Byte> byteHash = Hash.anyHash();
    public static final Hash<Character> charHash = Hash.anyHash();
    public static final Hash<Double> doubleHash = Hash.anyHash();
    public static final Hash<Float> floatHash = Hash.anyHash();
    public static final Hash<Integer> intHash = Hash.anyHash();
    public static final Hash<Long> longHash = Hash.anyHash();
    public static final Hash<Short> shortHash = Hash.anyHash();
    public static final Hash<String> stringHash = Hash.anyHash();
    public static final Hash<StringBuffer> stringBufferHash = new Hash<StringBuffer>(new F<StringBuffer, Integer>(){

        @Override
        public Integer f(StringBuffer stringBuffer) {
            int n = 239;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                n = 419 * n + stringBuffer.charAt(i);
            }
            return n;
        }
    });
    public static final Hash<StringBuilder> stringBuilderHash = new Hash<StringBuilder>(new F<StringBuilder, Integer>(){

        @Override
        public Integer f(StringBuilder stringBuilder) {
            int n = 239;
            for (int i = 0; i < stringBuilder.length(); ++i) {
                n = 419 * n + stringBuilder.charAt(i);
            }
            return n;
        }
    });

    private Hash(F<A, Integer> f) {
        this.f = f;
    }

    public int hash(A a) {
        return this.f.f(a);
    }

    public static <A> Hash<A> anyHash() {
        return new Hash<A>(new F<A, Integer>(){

            @Override
            public Integer f(A a) {
                return a.hashCode();
            }
        });
    }

    public static <A> Hash<List<A>> listHash(final Hash<A> hash) {
        return new Hash<List<A>>(new F<List<A>, Integer>(){

            @Override
            public Integer f(List<A> list) {
                int n = 239;
                List list2 = list;
                while (!list2.isEmpty()) {
                    n = 419 * n + hash.hash(list2.head());
                    list2 = list2.tail();
                }
                return n;
            }
        });
    }
}

