/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view.pieset;

import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.BucketView;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.fractions.common.util.Cache;
import edu.colorado.phet.fractions.common.view.FNode;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Pie;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.PieSetContentNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.ShapeNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.SliceNodeArgs;
import edu.umd.cs.piccolo.PNode;
import fj.F;
import fj.data.List;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieSetNode
extends FNode {
    private final BucketView bucketView;
    public static final F<SliceNodeArgs, PNode> CreateNode = new F<SliceNodeArgs, PNode>(){

        @Override
        public PNode f(SliceNodeArgs sliceNodeArgs) {
            return new ShapeNode(sliceNodeArgs.slice);
        }
    };
    private static final Cache<List<Slice>, Area> getContainerShape = new Cache<List<Slice>, Area>(new F<List<Slice>, Area>(){

        @Override
        public Area f(final List<Slice> list) {
            return new Area(){
                {
                    for (Slice slice : list) {
                        this.add(new Area(slice.getShape()));
                        this.add(new Area(new BasicStroke(2.0f, 1, 1, 0.01f).createStrokedShape(slice.getShape())));
                    }
                }
            };
        }
    });
    public static final F<PieSet, PNode> CreateEmptyCellsNode = new F<PieSet, PNode>(){

        @Override
        public PNode f(final PieSet pieSet) {
            FNode fNode = new FNode();
            for (Slice slice : pieSet.cells) {
                boolean bl = pieSet.pieContainsSliceForCell(slice);
                fNode.addChild(new PhetPPath(slice.getShape(), (Stroke)new BasicStroke(1.0f), (Paint)(bl ? Color.black : Color.lightGray)));
            }
            pieSet.pies.map(new F<Pie, PNode>(){

                @Override
                public PNode f(Pie pie) {
                    boolean bl = pie.cells.exists(new F<Slice, Boolean>(){

                        @Override
                        public Boolean f(Slice slice) {
                            return pieSet.cellFilledNowOrSoon(slice);
                        }
                    });
                    return new PhetPPath((Shape)getContainerShape.f(pie.cells), (Stroke)new BasicStroke(2.0f, 1, 1, 0.01f), (Paint)(bl ? Color.black : Color.lightGray));
                }
            }).foreach(fNode.addChild);
            return fNode;
        }
    };

    public PieSetNode(SettableProperty<PieSet> settableProperty, PNode pNode, boolean bl) {
        this(settableProperty, pNode, CreateNode, CreateEmptyCellsNode, new F<PieSet, PNode>(){

            @Override
            public PNode f(PieSet pieSet) {
                return PieSetNode.createBucketIcon(pieSet, CreateNode);
            }
        }, bl);
    }

    protected PieSetNode(final SettableProperty<PieSet> settableProperty, final PNode pNode, final F<SliceNodeArgs, PNode> f, final F<PieSet, PNode> f2, final F<PieSet, PNode> f3, final boolean bl) {
        this.bucketView = new BucketView(((PieSet)settableProperty.get()).sliceFactory.bucket, ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point(), new Point(), 1.0));
        final SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                PieSetNode.this.removeAllChildren();
                if (PieSetNode.this.getVisible()) {
                    PieSetNode.this.addChild(new PieSetContentNode(PieSetNode.this.bucketView, settableProperty, f, pNode, f2, f3, bl));
                }
            }
        };
        settableProperty.addObserver(simpleObserver);
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                simpleObserver.update();
            }
        });
    }

    protected static PNode createBucketIcon(final PieSet pieSet, final F<SliceNodeArgs, PNode> f) {
        return new PNode(){
            {
                Object object;
                int n = pieSet.denominator;
                for (int i = 0; i < n; ++i) {
                    object = pieSet.sliceFactory.createPieCell(pieSet.pies.length(), 0, i, n);
                    this.addChild(new PhetPPath(((Slice)object).getShape(), Color.white, new BasicStroke(3.0f), Color.black));
                }
                Slice slice = pieSet.sliceFactory.createPieCell(pieSet.pies.length(), 0, 0, n);
                object = (PNode)f.f(new SliceNodeArgs(slice, pieSet.denominator, false));
                ((PNode)object).setPickable(false);
                ((PNode)object).setChildPaintInvalid(false);
                this.addChild((PNode)object);
                this.scale(0.28);
            }
        };
    }
}

