/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view.pieset;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import fj.Equal;
import fj.F;
import fj.data.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovableSliceNode
extends PNode {
    public MovableSliceNode(final PNode pNode, final PNode pNode2, final SettableProperty<PieSet> settableProperty, final Slice slice) {
        this.addChild(pNode);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new SimSharingDragHandler(FractionsIntroSimSharing.Components.sliceComponent, UserComponentTypes.sprite, true){

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                boolean bl = ((PieSet)settableProperty.get()).isInContainer(slice);
                Vector2D vector2D = MovableSliceNode.this.getNewPieceLocation(bl, pNode, slice);
                PieSet pieSet = (PieSet)settableProperty.get();
                if (slice.animationTarget == null) {
                    if (pieSet.isInBucket(slice)) {
                        settableProperty.set(pieSet.withSlices(pieSet.slices.snoc(slice.withDragging(true).withID(Slice.nextID()))));
                    } else {
                        settableProperty.set(pieSet.withSlices(pieSet.slices.delete(slice, Equal.anyEqual()).snoc(slice.withDragging(true).withPosition(vector2D))));
                    }
                }
            }

            protected void drag(PInputEvent pInputEvent) {
                super.drag(pInputEvent);
                PieSet pieSet = (PieSet)settableProperty.get();
                final PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode2);
                PieSet pieSet2 = pieSet.withSlices(pieSet.slices.map(new F<Slice, Slice>(){

                    @Override
                    public Slice f(Slice slice) {
                        return slice.dragging ? slice.translate(pDimension.getWidth(), pDimension.getHeight()) : slice;
                    }
                }));
                settableProperty.set(pieSet2);
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                final PieSet pieSet = (PieSet)settableProperty.get();
                List<Slice> list = pieSet.slices.map(new F<Slice, Slice>(){

                    @Override
                    public Slice f(Slice slice) {
                        Slice slice2 = pieSet.getDropTarget(slice);
                        return slice.dragging && slice2 != null ? slice.moveTo(slice2) : (slice.dragging ? slice.withDragging(false).animationTarget(((PieSet)settableProperty.get()).sliceFactory.createBucketSlice(((PieSet)settableProperty.get()).denominator, System.currentTimeMillis())) : slice);
                    }
                });
                PieSet pieSet2 = pieSet.withSlices(list);
                settableProperty.set(pieSet2);
            }
        });
    }

    private Vector2D getNewPieceLocation(boolean bl, PNode pNode, Slice slice) {
        return bl && pNode.getClass().equals(PhetPPath.class) ? Vector2D.v(slice.position.x - 20.0, 300.0) : slice.position;
    }
}

