/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view.beaker;

import java.awt.Color;
import java.beans.ConstructorProperties;

public class Solute {
    public final double saturatedConcentration;
    public final Color solutionColor;

    @ConstructorProperties(value={"saturatedConcentration", "solutionColor"})
    public Solute(double d, Color color) {
        this.saturatedConcentration = d;
        this.solutionColor = color;
    }

    public double getSaturatedConcentration() {
        return this.saturatedConcentration;
    }

    public Color getSolutionColor() {
        return this.solutionColor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Solute)) {
            return false;
        }
        Solute solute = (Solute)object;
        if (!solute.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getSaturatedConcentration(), solute.getSaturatedConcentration()) != 0) {
            return false;
        }
        return !(this.getSolutionColor() == null ? solute.getSolutionColor() != null : !this.getSolutionColor().equals(solute.getSolutionColor()));
    }

    public boolean canEqual(Object object) {
        return object instanceof Solute;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getSaturatedConcentration());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (this.getSolutionColor() == null ? 0 : this.getSolutionColor().hashCode());
        return n;
    }

    public String toString() {
        return "Solute(saturatedConcentration=" + this.getSaturatedConcentration() + ", solutionColor=" + this.getSolutionColor() + ")";
    }
}

