/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view.beaker;

import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.beaker.BeakerImageNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;

public class BeakerNode
extends PNode {
    private static final Logger LOGGER = LoggingUtils.getLogger(BeakerNode.class.getCanonicalName());
    private static final Color MAJOR_TICK_COLOR = Color.BLACK;
    private static final Color MINOR_TICK_COLOR = Color.DARK_GRAY;
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(3.0f, 0, 2);
    private static final Stroke MINOR_TICK_STROKE = new BasicStroke(3.0f, 0, 2);
    private final BeakerImageNode beakerImageNode;
    private final LabelNode labelNode;

    public BeakerNode(double d, final double d2, final double d3, String string, PDimension pDimension, Font font, double d4, int n, BufferedImage bufferedImage) {
        this.beakerImageNode = new BeakerImageNode(bufferedImage){
            {
                super(bufferedImage);
                this.getTransformReference(true).scale(d2, d3);
            }
        };
        final PDimension pDimension2 = this.beakerImageNode.getCylinderSize();
        Point2D point2D = this.beakerImageNode.getCylinderOffset();
        final double d5 = this.beakerImageNode.getCylinderEndHeight();
        this.beakerImageNode.setOffset(-point2D.getX(), -point2D.getY());
        PPath pPath = new PPath(){
            {
                this.setPathTo(new Arc2D.Double(0.0, pDimension2.getHeight() - d5 / 2.0, pDimension2.getWidth(), d5, 5.0, 170.0, 0));
                this.setStroke(new BasicStroke(2.0f));
                this.setStrokePaint(new Color(150, 150, 150, 100));
            }
        };
        this.addChild(pPath);
        this.addChild(this.beakerImageNode);
        PComposite pComposite = new PComposite();
        this.addChild(pComposite);
        int n2 = (int)Math.round(d / d4);
        double d6 = pDimension2.getHeight();
        double d7 = pDimension2.getHeight() / (double)n2;
        for (int i = 1; i <= n2; ++i) {
            PPath pPath2;
            double d8 = d6 - (double)i * d7 - d5 / 2.0;
            if (i % n == 0) {
                pPath2 = new PPath(new Arc2D.Double(0.0, d8, pDimension2.getWidth(), d5, 195.0, 30.0, 0)){
                    {
                        this.setStroke(MAJOR_TICK_STROKE);
                        this.setStrokePaint(MAJOR_TICK_COLOR);
                    }
                };
                pComposite.addChild(pPath2);
                continue;
            }
            pPath2 = new PPath(new Arc2D.Double(0.0, d8, pDimension2.getWidth(), d5, 195.0, 15.0, 0)){
                {
                    this.setStroke(MINOR_TICK_STROKE);
                    this.setStrokePaint(MINOR_TICK_COLOR);
                }
            };
            pComposite.addChild(pPath2);
        }
        this.labelNode = new LabelNode(string, pDimension, font);
        this.addChild(this.labelNode);
        this.labelNode.setOffset(pDimension2.getWidth() / 2.0, 0.25 * pDimension2.getHeight());
    }

    public PDimension getCylinderSize() {
        return this.beakerImageNode.getCylinderSize();
    }

    public double getCylinderEndHeight() {
        return this.beakerImageNode.getCylinderEndHeight();
    }

    public void setLabelVisible() {
        this.labelNode.setVisible(false);
    }

    private static class LabelNode
    extends PComposite {
        private final HTMLNode htmlNode;
        private final PPath backgroundNode;

        public LabelNode(String string, final PDimension pDimension, final Font font) {
            this.htmlNode = new HTMLNode("?"){
                {
                    super(string);
                    this.setFont(font);
                }
            };
            this.backgroundNode = new PPath(){
                {
                    this.setPaint(ColorUtils.createColor(Color.WHITE, 150));
                    this.setStrokePaint(Color.LIGHT_GRAY);
                    this.setPathTo(new RoundRectangle2D.Double(-pDimension.getWidth() / 2.0, -pDimension.getHeight() / 2.0, pDimension.getWidth(), pDimension.getHeight(), 10.0, 10.0));
                }
            };
            this.addChild(this.backgroundNode);
            this.addChild(this.htmlNode);
            this.setText(string);
        }

        public void setText(String string) {
            this.htmlNode.setHTML(string);
            double d = (this.backgroundNode.getFullBoundsReference().getWidth() - 4.0) / this.htmlNode.getFullBoundsReference().getWidth();
            double d2 = (this.backgroundNode.getFullBoundsReference().getHeight() - 4.0) / this.htmlNode.getFullBoundsReference().getHeight();
            if (d < 1.0 || d2 < 1.0) {
                double d3 = Math.min(d, d2);
                LOGGER.info("text \"" + string + "\" won't fit in beaker label, scaling by " + d3);
                this.htmlNode.setScale(d3);
            }
            this.htmlNode.setOffset(-this.htmlNode.getFullBoundsReference().getWidth() / 2.0, -this.htmlNode.getFullBoundsReference().getHeight() / 2.0);
        }
    }
}

