/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.fractions.common.util.Size2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.SliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.VerticalShape;
import fj.F;
import fj.data.List;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalSliceFactory
extends SliceFactory {
    public final double barWidth;
    public final double barHeight;
    private final boolean fullBars;
    private final double distanceBetweenBars;
    private double x;
    public final boolean isWaterGlasses;

    public VerticalSliceFactory(double d, double d2, double d3, boolean bl, Vector2D vector2D, Size2D size2D, Color color, double d4, boolean bl2) {
        super(15.0, vector2D, size2D, color);
        this.barWidth = d2;
        this.barHeight = d3;
        this.fullBars = bl;
        this.distanceBetweenBars = d4;
        this.x = d;
        this.isWaterGlasses = bl2;
    }

    final F<Slice, Shape> createToShape(double d) {
        return new VerticalShape(d, this.barWidth);
    }

    @Override
    public Slice createBucketSlice(int n, long l) {
        Random random = new Random(l);
        Slice slice = this.createPieCell(6, 0, 0, n, this.fullBars ? this.barHeight : this.barHeight / (double)n);
        Shape shape = slice.getShape();
        double d = this.getBucketCenter().getX() - this.bucket.getHoleShape().getBounds2D().getWidth() / 2.0 + shape.getBounds2D().getWidth() / 2.0 + 20.0;
        double d2 = this.getBucketCenter().getX() + this.bucket.getHoleShape().getBounds2D().getWidth() / 2.0 - shape.getBounds2D().getWidth() / 2.0 - 20.0;
        double d3 = random.nextDouble() * (d2 - d) + d;
        return slice.withPosition(new Vector2D(d3, this.getBucketCenter().getY() + random.nextDouble() * this.yRange));
    }

    @Override
    public Slice createPieCell(int n, int n2, int n3, int n4) {
        return this.createPieCell(n, n2, n3, n4, this.barHeight / (double)n4);
    }

    private Slice createPieCell(int n, int n2, int n3, int n4, double d) {
        double d2 = new Function.LinearFunction(1.0, 6.0, this.barWidth * 3.0 - this.barWidth / 3.0, 0.0).evaluate(n);
        double d3 = this.barWidth + this.distanceBetweenBars;
        double d4 = d3 + (double)n2 * d3;
        Function.LinearFunction linearFunction = new Function.LinearFunction(1.0, 2.0, -this.barHeight, -this.barHeight + d / 2.0);
        return new Slice(new Vector2D(this.x + d4 + d2, 282.0 + d * (double)(n4 - n3) + linearFunction.evaluate(n4)), 0.0, false, null, this.createToShape(d), this.sliceColor, Slice.nextID());
    }

    @Override
    public Slice getDropTarget(PieSet pieSet, Slice slice) {
        return this.isWaterGlasses ? this.getWaterGlassesDropTarget(pieSet, slice) : super.getDropTarget(pieSet, slice);
    }

    private Slice getWaterGlassesDropTarget(PieSet pieSet, Slice slice) {
        if (pieSet.getEmptyCells().length() == 0) {
            return null;
        }
        Slice slice2 = this.getClosestEmptyCell(pieSet, slice.getCenter());
        return slice2 != null && this.waterGlassShapeOverlaps(slice, slice2) ? slice2 : null;
    }

    Slice getClosestEmptyCell(PieSet pieSet, final Vector2D vector2D) {
        List<Slice> list = pieSet.getEmptyCells().sort(FJUtils.ord(new F<Slice, Double>(){

            @Override
            public Double f(Slice slice) {
                return Math.abs(slice.getCenter().x - vector2D.x);
            }
        }));
        if (list.length() == 0) {
            return null;
        }
        final Slice slice = list.head();
        List<Slice> list2 = pieSet.getEmptyCells().filter(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice2) {
                return Math.abs(slice2.position.x - slice.position.x) < 1.0E-4;
            }
        });
        return list2.maximum(FJUtils.ord(new F<Slice, Double>(){

            @Override
            public Double f(Slice slice) {
                return slice.getCenter().y;
            }
        }));
    }

    boolean waterGlassShapeOverlaps(Slice slice, Slice slice2) {
        Rectangle2D rectangle2D = slice2.getShape().getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(slice.getShape().getBounds2D().getX(), rectangle2D.getY(), slice.getShape().getBounds2D().getWidth(), rectangle2D.getHeight());
        boolean bl = double_.intersects(rectangle2D);
        double d = slice.getShape().getBounds2D().getY();
        return bl && d < 365.0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VerticalSliceFactory)) {
            return false;
        }
        VerticalSliceFactory verticalSliceFactory = (VerticalSliceFactory)object;
        if (!verticalSliceFactory.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.barWidth, verticalSliceFactory.barWidth) != 0) {
            return false;
        }
        if (Double.compare(this.barHeight, verticalSliceFactory.barHeight) != 0) {
            return false;
        }
        if (this.fullBars != verticalSliceFactory.fullBars) {
            return false;
        }
        if (Double.compare(this.distanceBetweenBars, verticalSliceFactory.distanceBetweenBars) != 0) {
            return false;
        }
        if (Double.compare(this.x, verticalSliceFactory.x) != 0) {
            return false;
        }
        return this.isWaterGlasses == verticalSliceFactory.isWaterGlasses;
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof VerticalSliceFactory;
    }

    @Override
    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.barWidth);
        long l2 = Double.doubleToLongBits(this.barHeight);
        long l3 = Double.doubleToLongBits(this.distanceBetweenBars);
        long l4 = Double.doubleToLongBits(this.x);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        n = n * 31 + (this.fullBars ? 1231 : 1237);
        n = n * 31 + (int)(l3 >>> 32 ^ l3);
        n = n * 31 + (int)(l4 >>> 32 ^ l4);
        n = n * 31 + (this.isWaterGlasses ? 1231 : 1237);
        return n;
    }
}

