/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.common.util.Size2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Site;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.CircularShapeFunction;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.SliceFactory;
import fj.F;
import java.awt.Color;
import java.awt.Shape;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularSliceFactory
extends SliceFactory {
    public final double diameter;
    private final double x;
    private final double y;
    private final F<Site, Site> siteMap;
    public final double spacing = 10.0;
    private final int piesPerRow;
    private final double radius;

    public CircularSliceFactory(int n, Vector2D vector2D, Size2D size2D, double d, double d2, double d3, F<Site, Site> f, Color color) {
        super(0.0, vector2D, size2D, color);
        this.piesPerRow = n;
        this.diameter = d;
        this.x = d2;
        this.y = d3;
        this.siteMap = f;
        this.radius = d / 2.0;
    }

    final F<Slice, Shape> getShapeFunction(double d) {
        return new CircularShapeFunction(d, this.radius);
    }

    @Override
    public Slice createBucketSlice(int n, long l) {
        Random random = new Random(l);
        double d = Math.PI * 2 / (double)n;
        Vector2D vector2D = new Vector2D(this.getBucketCenter().getX() + (random.nextDouble() * 2.0 - 1.0) * this.radius, this.getBucketCenter().getY() - this.radius / 2.0);
        return new Slice(vector2D, 4.71238898038469 - d / 2.0, false, null, this.getShapeFunction(d), this.sliceColor, Slice.nextID());
    }

    @Override
    public Slice createPieCell(int n, int n2, int n3, int n4) {
        double d = new Function.LinearFunction(1.0, 6.0, this.diameter * 3.0 - this.diameter / 3.0, 0.0).evaluate(n);
        Site site = this.siteMap.f(new Site(n2 / this.piesPerRow, n2 % this.piesPerRow));
        double d2 = 15.0;
        double d3 = Math.PI * 2 / (double)n4;
        Vector2D vector2D = new Vector2D(this.x + this.diameter * (double)(site.column + 1) + 10.0 * (double)(site.column + 1) - 80.0 + d, this.y + this.radius * 2.0 * (double)site.row + d2 * (double)site.row);
        return new Slice(vector2D, d3 * (double)n3, false, null, this.getShapeFunction(d3), this.sliceColor, Slice.nextID());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CircularSliceFactory)) {
            return false;
        }
        CircularSliceFactory circularSliceFactory = (CircularSliceFactory)object;
        if (!circularSliceFactory.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.diameter, circularSliceFactory.diameter) != 0) {
            return false;
        }
        if (Double.compare(this.x, circularSliceFactory.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, circularSliceFactory.y) != 0) {
            return false;
        }
        if (this.siteMap == null ? circularSliceFactory.siteMap != null : !this.siteMap.equals(circularSliceFactory.siteMap)) {
            return false;
        }
        if (Double.compare(this.spacing, circularSliceFactory.spacing) != 0) {
            return false;
        }
        if (this.piesPerRow != circularSliceFactory.piesPerRow) {
            return false;
        }
        return Double.compare(this.radius, circularSliceFactory.radius) == 0;
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof CircularSliceFactory;
    }

    @Override
    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.diameter);
        long l2 = Double.doubleToLongBits(this.x);
        long l3 = Double.doubleToLongBits(this.y);
        long l4 = Double.doubleToLongBits(this.spacing);
        long l5 = Double.doubleToLongBits(this.radius);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        n = n * 31 + (int)(l3 >>> 32 ^ l3);
        n = n * 31 + (this.siteMap == null ? 0 : this.siteMap.hashCode());
        n = n * 31 + (int)(l4 >>> 32 ^ l4);
        n = n * 31 + this.piesPerRow;
        n = n * 31 + (int)(l5 >>> 32 ^ l5);
        return n;
    }
}

