/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import fj.F;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularShapeFunction
extends F<Slice, Shape> {
    public final double extent;
    public final double radius;

    public CircularShapeFunction(double d, double d2) {
        this.extent = d;
        this.radius = d2;
    }

    @Override
    public Shape f(Slice slice) {
        return this.createShape(slice.position, slice.angle);
    }

    public Shape createShape(Vector2D vector2D, double d) {
        double d2 = 1.0E-6;
        return this.extent >= Math.PI * 2 - d2 ? new Ellipse2D.Double(vector2D.getX() - this.radius, vector2D.getY() - this.radius, this.radius * 2.0, this.radius * 2.0) : new Arc2D.Double(vector2D.getX() - this.radius, vector2D.getY() - this.radius, this.radius * 2.0, this.radius * 2.0, d * 180.0 / Math.PI, this.extent * 180.0 / Math.PI, 2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CircularShapeFunction)) {
            return false;
        }
        CircularShapeFunction circularShapeFunction = (CircularShapeFunction)object;
        if (!circularShapeFunction.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.extent, circularShapeFunction.extent) != 0) {
            return false;
        }
        return Double.compare(this.radius, circularShapeFunction.radius) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof CircularShapeFunction;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.extent);
        long l2 = Double.doubleToLongBits(this.radius);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        return n;
    }
}

