/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.AnimationTarget;
import fj.F;
import java.awt.Color;
import java.awt.Shape;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slice {
    public final Vector2D position;
    public final double angle;
    public final boolean dragging;
    public final AnimationTarget animationTarget;
    public final F<Slice, Shape> toShape;
    public final Color color;
    public final transient int id;
    private static int count = 0;

    public Slice withDragging(boolean bl) {
        return new Slice(this.position, this.angle, bl, this.animationTarget, this.toShape, this.color, this.id);
    }

    public Slice withID(int n) {
        return new Slice(this.position, this.angle, this.dragging, this.animationTarget, this.toShape, this.color, n);
    }

    Slice withAngle(double d) {
        return new Slice(this.position, d, this.dragging, this.animationTarget, this.toShape, this.color, this.id);
    }

    public Slice withPosition(Vector2D vector2D) {
        return new Slice(vector2D, this.angle, this.dragging, this.animationTarget, this.toShape, this.color, this.id);
    }

    Slice withAnimationTarget(AnimationTarget animationTarget) {
        return new Slice(this.position, this.angle, this.dragging, animationTarget, this.toShape, this.color, this.id);
    }

    public Slice translate(Vector2D vector2D) {
        return this.translate(vector2D.x, vector2D.y);
    }

    public Slice translate(double d, double d2) {
        return new Slice(this.position.plus(d, d2), this.angle, this.dragging, this.animationTarget, this.toShape, this.color, this.id);
    }

    public Slice animationTarget(Slice slice) {
        return this.withAnimationTarget(AnimationTarget.animateToSlice(slice));
    }

    public Vector2D getCenter() {
        return new Vector2D(this.getShape().getBounds2D().getCenterX(), this.getShape().getBounds2D().getCenterY());
    }

    public Slice stepAnimation() {
        return this.stepTranslation().stepRotation();
    }

    public Shape getShape() {
        return this.toShape.f(this);
    }

    private Slice stepTranslation() {
        return this.animationTarget == null ? this : this.translate(this.getVelocity()).checkFinishAnimation();
    }

    private Slice stepRotation() {
        return this.animationTarget == null ? this : this.rotateTowardTarget(this.animationTarget.angle);
    }

    public Slice rotateTowardTarget(double d) {
        Slice slice = this;
        if (Math.abs(d - slice.angle) > Math.PI) {
            if (d > slice.angle) {
                d -= Math.PI * 2;
            } else if (d < slice.angle) {
                d += Math.PI * 2;
            }
        }
        double d2 = d - slice.angle;
        double d3 = slice.angle + d2 / 4.0;
        return this.withAngle(d3);
    }

    private Vector2D getVelocity() {
        return this.animationTarget.position.minus(this.position).getInstanceOfMagnitude(30.0);
    }

    private Slice checkFinishAnimation() {
        if (this.position.distance(this.animationTarget.position) < this.getVelocity().magnitude()) {
            return this.withPosition(this.animationTarget.position).withAnimationTarget(null).withAngle(this.animationTarget.angle);
        }
        return this;
    }

    public boolean movingToward(Slice slice) {
        return this.animationTarget != null && this.animationTarget.position.equals(slice.position) && this.animationTarget.angle == slice.angle;
    }

    public boolean positionAndAngleEquals(Slice slice) {
        return slice.position.equals(this.position) && slice.angle == this.angle;
    }

    public Slice moveTo(Slice slice) {
        return this.withDragging(false).withAngle(slice.angle).withPosition(slice.position);
    }

    public int cell(int n) {
        double d = Math.PI * 2 / (double)n;
        long l = Math.round(this.canonical(this.angle) / d);
        int n2 = (int)l;
        int n3 = n2 % n;
        if (n == 2) {
            return (n3 + 1) % 2;
        }
        return n3;
    }

    private double canonical(double d) {
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        return d;
    }

    public static int nextID() {
        int n = count++;
        return n;
    }

    @ConstructorProperties(value={"position", "angle", "dragging", "animationTarget", "toShape", "color", "id"})
    public Slice(Vector2D vector2D, double d, boolean bl, AnimationTarget animationTarget, F<Slice, Shape> f, Color color, int n) {
        this.position = vector2D;
        this.angle = d;
        this.dragging = bl;
        this.animationTarget = animationTarget;
        this.toShape = f;
        this.color = color;
        this.id = n;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public AnimationTarget getAnimationTarget() {
        return this.animationTarget;
    }

    public F<Slice, Shape> getToShape() {
        return this.toShape;
    }

    public Color getColor() {
        return this.color;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Slice)) {
            return false;
        }
        Slice slice = (Slice)object;
        if (!slice.canEqual(this)) {
            return false;
        }
        if (this.getPosition() == null ? slice.getPosition() != null : !this.getPosition().equals(slice.getPosition())) {
            return false;
        }
        if (Double.compare(this.getAngle(), slice.getAngle()) != 0) {
            return false;
        }
        if (this.isDragging() != slice.isDragging()) {
            return false;
        }
        if (this.getAnimationTarget() == null ? slice.getAnimationTarget() != null : !this.getAnimationTarget().equals(slice.getAnimationTarget())) {
            return false;
        }
        if (this.getToShape() == null ? slice.getToShape() != null : !this.getToShape().equals(slice.getToShape())) {
            return false;
        }
        return !(this.getColor() == null ? slice.getColor() != null : !this.getColor().equals(slice.getColor()));
    }

    public boolean canEqual(Object object) {
        return object instanceof Slice;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getAngle());
        n = n * 31 + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (this.isDragging() ? 1231 : 1237);
        n = n * 31 + (this.getAnimationTarget() == null ? 0 : this.getAnimationTarget().hashCode());
        n = n * 31 + (this.getToShape() == null ? 0 : this.getToShape().hashCode());
        n = n * 31 + (this.getColor() == null ? 0 : this.getColor().hashCode());
        return n;
    }

    public String toString() {
        return "Slice(position=" + this.getPosition() + ", angle=" + this.getAngle() + ", dragging=" + this.isDragging() + ", animationTarget=" + this.getAnimationTarget() + ", toShape=" + this.getToShape() + ", color=" + this.getColor() + ", id=" + this.getId() + ")";
    }
}

