/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset;

import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.CellPointer;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.Container;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.ContainerSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Pie;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.SliceFactory;
import fj.F;
import fj.F2;
import fj.P2;
import fj.data.List;
import fj.data.Option;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieSet {
    public final int denominator;
    public final List<Pie> pies;
    public final List<Slice> slices;
    public final List<Slice> cells;
    public final SliceFactory sliceFactory;

    public PieSet(int n, SliceFactory sliceFactory, long l) {
        this(1, sliceFactory.createEmptyPies(n, 1), sliceFactory.createSlicesForBucket(1, 6, l), sliceFactory);
    }

    public PieSet(int n, List<Pie> list, List<Slice> list2, SliceFactory sliceFactory) {
        this.denominator = n;
        this.pies = list;
        this.slices = list2;
        this.sliceFactory = sliceFactory;
        this.cells = list.bind(new F<Pie, List<Slice>>(){

            @Override
            public List<Slice> f(Pie pie) {
                return pie.cells;
            }
        });
    }

    public PieSet withSlices(List<Slice> list) {
        return new PieSet(this.denominator, this.pies, list, this.sliceFactory);
    }

    public List<Slice> getEmptyCells() {
        return this.pies.bind(new F<Pie, List<Slice>>(){

            @Override
            public List<Slice> f(Pie pie) {
                return PieSet.this.getEmptyCells(pie);
            }
        });
    }

    private List<Slice> getEmptyCells(Pie pie) {
        return pie.cells.filter(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice) {
                return !PieSet.this.cellFilledNowOrSoon(slice);
            }
        });
    }

    public PieSet stepInTime() {
        List<Slice> list = this.slices.map(new F<Slice, Slice>(){

            @Override
            public Slice f(final Slice slice) {
                if (slice.dragging) {
                    if (PieSet.this.getEmptyCells().length() > 0) {
                        Slice slice2 = PieSet.this.getEmptyCells().minimum(FJUtils.ord(new F<Slice, Double>(){

                            @Override
                            public Double f(Slice slice2) {
                                return slice2.getCenter().distance(slice.getCenter());
                            }
                        }));
                        Slice slice3 = slice.rotateTowardTarget(slice2.angle);
                        return slice3.translate(slice.getCenter().minus(slice3.getCenter()));
                    }
                    return slice;
                }
                return slice.stepAnimation();
            }
        });
        List<P2<Slice, Slice>> list2 = this.slices.zip(list);
        List<Slice> list3 = list2.filter(new F<P2<Slice, Slice>, Boolean>(){

            @Override
            public Boolean f(P2<Slice, Slice> p2) {
                return !PieSet.this.isInBucket(p2._2()) || PieSet.this.isInBucket(p2._1());
            }
        }).map(new F<P2<Slice, Slice>, Slice>(){

            @Override
            public Slice f(P2<Slice, Slice> p2) {
                return p2._2();
            }
        });
        return this.withSlices(list3);
    }

    public boolean cellFilledNowOrSoon(final Slice slice) {
        return this.slices.exists(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice2) {
                return slice2.movingToward(slice) || slice2.positionAndAngleEquals(slice) && !slice2.dragging;
            }
        });
    }

    boolean cellCurrentlyFilled(final Slice slice) {
        return this.slices.exists(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice2) {
                return slice2.positionAndAngleEquals(slice) && !slice2.dragging;
            }
        });
    }

    public Slice getDropTarget(Slice slice) {
        return this.sliceFactory.getDropTarget(this, slice);
    }

    public ContainerSet toContainerSet() {
        return new ContainerSet(this.denominator, this.pies.map(new F<Pie, Container>(){

            @Override
            public Container f(Pie pie) {
                return PieSet.this.pieToContainer(pie);
            }
        }));
    }

    private Container pieToContainer(final Pie pie) {
        return new Container(pie.cells.length(), List.range(0, pie.cells.length()).filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return PieSet.this.cellFilledNowOrSoon(pie.cells.index(n));
            }
        }));
    }

    private Container pieToContainerLazy(final Pie pie) {
        return new Container(pie.cells.length(), List.range(0, pie.cells.length()).filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return PieSet.this.cellCurrentlyFilled(pie.cells.index(n));
            }
        }));
    }

    public ContainerSet toLazyContainerSet() {
        return new ContainerSet(this.denominator, this.pies.map(new F<Pie, Container>(){

            @Override
            public Container f(Pie pie) {
                return PieSet.this.pieToContainerLazy(pie);
            }
        }));
    }

    public PieSet animateBucketSliceToPie(CellPointer cellPointer, long l) {
        List<Slice> list = this.getBucketSlices();
        Slice slice = list.index(new Random(l).nextInt(list.length()));
        Slice slice2 = this.sliceFactory.createPieCell(this.pies.length(), cellPointer.container, cellPointer.cell, this.denominator);
        return this.withSlices(this.slices.snoc(slice.animationTarget(slice2)));
    }

    private List<Slice> getBucketSlices() {
        return this.slices.filter(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice) {
                return PieSet.this.isInBucket(slice);
            }
        });
    }

    public PieSet animateSliceToBucket(CellPointer cellPointer, long l) {
        final Slice slice = this.sliceFactory.createPieCell(this.pies.length(), cellPointer.container, cellPointer.cell, this.denominator);
        Option<Slice> option = this.slices.find(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice2) {
                return slice2.position.equals(slice.position) && slice2.angle == slice.angle || slice2.movingToward(slice);
            }
        });
        Slice slice2 = option.isSome() ? option.some() : this.slices.find(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice2) {
                return slice2.position.getY() == slice.position.getY();
            }
        }).some();
        return this.animateSliceToBucket(slice2, l);
    }

    public PieSet animateSliceToBucket(final Slice slice, final long l) {
        List<Slice> list = this.slices.map(new F<Slice, Slice>(){

            @Override
            public Slice f(Slice slice2) {
                return slice2 == slice ? slice2.animationTarget(PieSet.this.sliceFactory.createBucketSlice(PieSet.this.denominator, l)).stepAnimation() : slice2;
            }
        });
        return this.withSlices(list);
    }

    public boolean pieContainsSliceForCell(Slice slice) {
        return this.getEmptyCells(this.getPie(slice)).length() < this.denominator;
    }

    private Pie getPie(final Slice slice) {
        return this.pies.find(new F<Pie, Boolean>(){

            @Override
            public Boolean f(Pie pie) {
                return pie.cells.find(new F<Slice, Boolean>(){

                    @Override
                    public Boolean f(Slice slice) {
                        return slice == slice;
                    }
                }).isSome();
            }
        }).some();
    }

    public boolean isInBucket(Slice slice) {
        return slice.animationTarget == null && !slice.dragging && slice.position.y >= this.sliceFactory.getBucketCenter().y - 50.0;
    }

    public int countFilledCells(Pie pie) {
        return pie.cells.map(new F<Slice, Integer>(){

            @Override
            public Integer f(Slice slice) {
                return PieSet.this.cellCurrentlyFilled(slice) ? 1 : 0;
            }
        }).foldLeft(new F2<Integer, Integer, Integer>(){

            @Override
            public Integer f(Integer n, Integer n2) {
                return n + n2;
            }
        }, Integer.valueOf(0));
    }

    public boolean isInContainer(Slice slice) {
        return !this.isInBucket(slice) && !slice.dragging && slice.animationTarget == null;
    }

    public PieSet createScaledCopy() {
        return this.withSlices(this.slices.filter(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice) {
                return PieSet.this.sliceSittingInCell(slice);
            }
        }));
    }

    private Boolean sliceSittingInCell(final Slice slice) {
        return this.cells.exists(new F<Slice, Boolean>(){

            @Override
            public Boolean f(Slice slice2) {
                return slice2.positionAndAngleEquals(slice);
            }
        });
    }

    public int getDenominator() {
        return this.denominator;
    }

    public List<Pie> getPies() {
        return this.pies;
    }

    public List<Slice> getSlices() {
        return this.slices;
    }

    public List<Slice> getCells() {
        return this.cells;
    }

    public SliceFactory getSliceFactory() {
        return this.sliceFactory;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieSet)) {
            return false;
        }
        PieSet pieSet = (PieSet)object;
        if (!pieSet.canEqual(this)) {
            return false;
        }
        if (this.getDenominator() != pieSet.getDenominator()) {
            return false;
        }
        if (this.getPies() == null ? pieSet.getPies() != null : !this.getPies().equals(pieSet.getPies())) {
            return false;
        }
        if (this.getSlices() == null ? pieSet.getSlices() != null : !this.getSlices().equals(pieSet.getSlices())) {
            return false;
        }
        if (this.getCells() == null ? pieSet.getCells() != null : !this.getCells().equals(pieSet.getCells())) {
            return false;
        }
        return !(this.getSliceFactory() == null ? pieSet.getSliceFactory() != null : !this.getSliceFactory().equals(pieSet.getSliceFactory()));
    }

    public boolean canEqual(Object object) {
        return object instanceof PieSet;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.getDenominator();
        n = n * 31 + (this.getPies() == null ? 0 : this.getPies().hashCode());
        n = n * 31 + (this.getSlices() == null ? 0 : this.getSlices().hashCode());
        n = n * 31 + (this.getCells() == null ? 0 : this.getCells().hashCode());
        n = n * 31 + (this.getSliceFactory() == null ? 0 : this.getSliceFactory().hashCode());
        return n;
    }

    public String toString() {
        return "PieSet(denominator=" + this.getDenominator() + ", pies=" + this.getPies() + ", slices=" + this.getSlices() + ", cells=" + this.getCells() + ", sliceFactory=" + this.getSliceFactory() + ")";
    }
}

