/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import java.beans.ConstructorProperties;

public class AnimationTarget {
    public final Vector2D position;
    public final double angle;

    public static AnimationTarget animateToSlice(Slice slice) {
        return new AnimationTarget(slice.position, slice.angle);
    }

    @ConstructorProperties(value={"position", "angle"})
    public AnimationTarget(Vector2D vector2D, double d) {
        this.position = vector2D;
        this.angle = d;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AnimationTarget)) {
            return false;
        }
        AnimationTarget animationTarget = (AnimationTarget)object;
        if (!animationTarget.canEqual(this)) {
            return false;
        }
        if (this.getPosition() == null ? animationTarget.getPosition() != null : !this.getPosition().equals(animationTarget.getPosition())) {
            return false;
        }
        return Double.compare(this.getAngle(), animationTarget.getAngle()) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof AnimationTarget;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getAngle());
        n = n * 31 + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        n = n * 31 + (int)(l >>> 32 ^ l);
        return n;
    }

    public String toString() {
        return "AnimationTarget(position=" + this.getPosition() + ", angle=" + this.getAngle() + ")";
    }
}

