/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model;

import edu.colorado.phet.common.phetcommon.util.FileUtils;
import fj.F;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionTestRecorder<A, B>
extends F<A, B> {
    private final F<A, B> function;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private static int count = 0;
    private static final IXStream xstream = new IXStream();

    private RegressionTestRecorder(F<A, B> f) {
        this.function = f;
    }

    public static <X, Y> RegressionTestRecorder record(F<X, Y> f) {
        return new RegressionTestRecorder<X, Y>(f);
    }

    @Override
    public B f(A a) {
        B b = this.function.f(a);
        final Entry<A, B> entry = new Entry<A, B>(a, this.function, b);
        System.out.println("Recorded function application: " + count + ", function = " + this.function);
        executorService.execute(new Runnable(){

            public void run() {
                RegressionTestRecorder.this.writeObject(entry);
            }
        });
        return b;
    }

    void writeObject(Entry entry) {
        this.writeXStream(entry);
        ++count;
    }

    private void writeXStream(Entry entry) {
        File file = new File("C:\\Users\\Sam\\Desktop\\tests\\save_" + count + ".xml");
        String string = xstream.toXML();
        try {
            FileUtils.writeString(file, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<A, B>
    implements Serializable {
        final A input;
        final F<A, B> function;
        final B output;

        @ConstructorProperties(value={"input", "function", "output"})
        public Entry(A a, F<A, B> f, B b) {
            this.input = a;
            this.function = f;
            this.output = b;
        }

        public A getInput() {
            return this.input;
        }

        public F<A, B> getFunction() {
            return this.function;
        }

        public B getOutput() {
            return this.output;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            if (!entry.canEqual(this)) {
                return false;
            }
            if (this.getInput() == null ? entry.getInput() != null : !this.getInput().equals(entry.getInput())) {
                return false;
            }
            if (this.getFunction() == null ? entry.getFunction() != null : !this.getFunction().equals(entry.getFunction())) {
                return false;
            }
            return !(this.getOutput() == null ? entry.getOutput() != null : !this.getOutput().equals(entry.getOutput()));
        }

        public boolean canEqual(Object object) {
            return object instanceof Entry;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + (this.getInput() == null ? 0 : this.getInput().hashCode());
            n = n * 31 + (this.getFunction() == null ? 0 : this.getFunction().hashCode());
            n = n * 31 + (this.getOutput() == null ? 0 : this.getOutput().hashCode());
            return n;
        }

        public String toString() {
            return "RegressionTestRecorder.Entry(input=" + this.getInput() + ", function=" + this.getFunction() + ", output=" + this.getOutput() + ")";
        }
    }

    private static class IXStream {
        private IXStream() {
        }

        public String toXML() {
            return null;
        }
    }
}

