/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.common.util.Size2D;
import edu.colorado.phet.fractions.common.view.Colors;
import edu.colorado.phet.fractions.fractionsintro.intro.model.IdentitySiteMap;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.Container;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.ContainerSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.CakeSliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.CircularSliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.FactorySet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.HorizontalSliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.SliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.VerticalSliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.view.Representation;
import fj.F;
import java.beans.ConstructorProperties;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroState {
    public final ContainerSet containerSet;
    public final boolean showReduced;
    public final boolean showMixed;
    public final PieSet pieSet;
    public final PieSet horizontalBarSet;
    public final PieSet verticalBarSet;
    public final PieSet waterGlassSet;
    public final PieSet cakeSet;
    public final int numerator;
    public final int denominator;
    public final Representation representation;
    public final int maximum;
    public final long randomSeed;
    public final FactorySet factorySet;

    public static IntroState newState(int n, FactorySet factorySet, long l) {
        int n2 = 1;
        return new IntroState(new ContainerSet(n2, new Container[]{new Container(1, new int[0])}).padAndTrim().maximum(n), false, false, new PieSet(n, factorySet.circularSliceFactory, l), new PieSet(n, factorySet.horizontalSliceFactory, l), new PieSet(n, factorySet.verticalSliceFactory, l), new PieSet(n, factorySet.waterGlassSetFactory, l), new PieSet(n, factorySet.cakeSliceFactory, l), 0, 1, Representation.PIE, n, l, factorySet);
    }

    public IntroState pieSet(PieSet pieSet) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, pieSet, this.horizontalBarSet, this.verticalBarSet, this.waterGlassSet, this.cakeSet, this.numerator, this.denominator, this.representation, this.maximum, this.randomSeed, this.factorySet);
    }

    public IntroState representation(Representation representation) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, this.verticalBarSet, this.waterGlassSet, this.cakeSet, this.numerator, this.denominator, representation, this.maximum, this.randomSeed, this.factorySet);
    }

    public IntroState numerator(Integer n) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, this.verticalBarSet, this.waterGlassSet, this.cakeSet, n, this.denominator, this.representation, this.maximum, this.randomSeed, this.factorySet);
    }

    public IntroState denominator(Integer n) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, this.verticalBarSet, this.waterGlassSet, this.cakeSet, this.numerator, n, this.representation, this.maximum, this.randomSeed, this.factorySet);
    }

    public IntroState containerSet(ContainerSet containerSet) {
        return new IntroState(containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, this.verticalBarSet, this.waterGlassSet, this.cakeSet, this.numerator, this.denominator, this.representation, this.maximum, this.randomSeed, this.factorySet);
    }

    public IntroState horizontalBarSet(PieSet pieSet) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, pieSet, this.verticalBarSet, this.waterGlassSet, this.cakeSet, this.numerator, this.denominator, this.representation, this.maximum, this.randomSeed, this.factorySet);
    }

    public IntroState verticalBarSet(PieSet pieSet) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, pieSet, this.waterGlassSet, this.cakeSet, this.numerator, this.denominator, this.representation, this.maximum, this.randomSeed, this.factorySet);
    }

    public IntroState maximum(int n) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, this.verticalBarSet, this.waterGlassSet, this.cakeSet, this.numerator, this.denominator, this.representation, n, this.randomSeed, this.factorySet);
    }

    public IntroState waterGlassSet(PieSet pieSet) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, this.verticalBarSet, pieSet, this.cakeSet, this.numerator, this.denominator, this.representation, this.maximum, this.randomSeed, this.factorySet);
    }

    public IntroState cakeSet(PieSet pieSet) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, this.verticalBarSet, this.waterGlassSet, pieSet, this.numerator, this.denominator, this.representation, this.maximum, this.randomSeed, this.factorySet);
    }

    IntroState randomSeed(long l) {
        return new IntroState(this.containerSet, this.showReduced, this.showMixed, this.pieSet, this.horizontalBarSet, this.verticalBarSet, this.waterGlassSet, this.cakeSet, this.numerator, this.denominator, this.representation, this.maximum, l, this.factorySet);
    }

    public IntroState updatePieSets(F<PieSet, PieSet> f) {
        PieSet pieSet = f.f(this.pieSet);
        IntroState introState = this.pieSet(pieSet).horizontalBarSet(f.f(this.horizontalBarSet)).verticalBarSet(f.f(this.verticalBarSet)).waterGlassSet(f.f(this.waterGlassSet)).cakeSet(f.f(this.cakeSet)).containerSet(pieSet.toContainerSet());
        return introState.cakeSet(CakeSliceFactory.sort(introState.cakeSet));
    }

    public IntroState fromContainerSet(ContainerSet containerSet, FactorySet factorySet) {
        return this.pieSet(factorySet.circularSliceFactory.fromContainerSetState(containerSet)).horizontalBarSet(factorySet.horizontalSliceFactory.fromContainerSetState(containerSet)).verticalBarSet(factorySet.verticalSliceFactory.fromContainerSetState(containerSet)).waterGlassSet(factorySet.waterGlassSetFactory.fromContainerSetState(containerSet)).cakeSet(factorySet.cakeSliceFactory.fromContainerSetState(containerSet));
    }

    public static FactorySet createFactorySet() {
        Vector2D vector2D = new Vector2D(SliceFactory.stageSize.width / 2.0, -SliceFactory.stageSize.height + 200.0 + 20.0);
        int n = 6;
        double d = 155.0;
        double d2 = 0.0;
        double d3 = 270.0;
        IdentitySiteMap identitySiteMap = new IdentitySiteMap();
        Size2D size2D = new Size2D(350.0, 135.0);
        return new FactorySet(new CircularSliceFactory(n, vector2D, size2D, d, d2, d3, identitySiteMap, Colors.CIRCLE_COLOR), new HorizontalSliceFactory(vector2D, size2D, Colors.HORIZONTAL_SLICE_COLOR), new VerticalSliceFactory(-35.5, 125.0, 200.0, false, vector2D, size2D, Colors.VERTICAL_SLICE_COLOR, 26.0, false), new VerticalSliceFactory(60.0, 100.0, 200.0, true, vector2D, size2D, Colors.CUP_COLOR, 26.0, true), new CakeSliceFactory(vector2D, size2D));
    }

    public IntroState nextRandomSeed() {
        return this.randomSeed(new Random(this.randomSeed).nextLong());
    }

    @ConstructorProperties(value={"containerSet", "showReduced", "showMixed", "pieSet", "horizontalBarSet", "verticalBarSet", "waterGlassSet", "cakeSet", "numerator", "denominator", "representation", "maximum", "randomSeed", "factorySet"})
    public IntroState(ContainerSet containerSet, boolean bl, boolean bl2, PieSet pieSet, PieSet pieSet2, PieSet pieSet3, PieSet pieSet4, PieSet pieSet5, int n, int n2, Representation representation, int n3, long l, FactorySet factorySet) {
        this.containerSet = containerSet;
        this.showReduced = bl;
        this.showMixed = bl2;
        this.pieSet = pieSet;
        this.horizontalBarSet = pieSet2;
        this.verticalBarSet = pieSet3;
        this.waterGlassSet = pieSet4;
        this.cakeSet = pieSet5;
        this.numerator = n;
        this.denominator = n2;
        this.representation = representation;
        this.maximum = n3;
        this.randomSeed = l;
        this.factorySet = factorySet;
    }

    public ContainerSet getContainerSet() {
        return this.containerSet;
    }

    public boolean isShowReduced() {
        return this.showReduced;
    }

    public boolean isShowMixed() {
        return this.showMixed;
    }

    public PieSet getPieSet() {
        return this.pieSet;
    }

    public PieSet getHorizontalBarSet() {
        return this.horizontalBarSet;
    }

    public PieSet getVerticalBarSet() {
        return this.verticalBarSet;
    }

    public PieSet getWaterGlassSet() {
        return this.waterGlassSet;
    }

    public PieSet getCakeSet() {
        return this.cakeSet;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public FactorySet getFactorySet() {
        return this.factorySet;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntroState)) {
            return false;
        }
        IntroState introState = (IntroState)object;
        if (!introState.canEqual(this)) {
            return false;
        }
        if (this.getContainerSet() == null ? introState.getContainerSet() != null : !this.getContainerSet().equals(introState.getContainerSet())) {
            return false;
        }
        if (this.isShowReduced() != introState.isShowReduced()) {
            return false;
        }
        if (this.isShowMixed() != introState.isShowMixed()) {
            return false;
        }
        if (this.getPieSet() == null ? introState.getPieSet() != null : !this.getPieSet().equals(introState.getPieSet())) {
            return false;
        }
        if (this.getHorizontalBarSet() == null ? introState.getHorizontalBarSet() != null : !this.getHorizontalBarSet().equals(introState.getHorizontalBarSet())) {
            return false;
        }
        if (this.getVerticalBarSet() == null ? introState.getVerticalBarSet() != null : !this.getVerticalBarSet().equals(introState.getVerticalBarSet())) {
            return false;
        }
        if (this.getWaterGlassSet() == null ? introState.getWaterGlassSet() != null : !this.getWaterGlassSet().equals(introState.getWaterGlassSet())) {
            return false;
        }
        if (this.getCakeSet() == null ? introState.getCakeSet() != null : !this.getCakeSet().equals(introState.getCakeSet())) {
            return false;
        }
        if (this.getNumerator() != introState.getNumerator()) {
            return false;
        }
        if (this.getDenominator() != introState.getDenominator()) {
            return false;
        }
        if (this.getRepresentation() == null ? introState.getRepresentation() != null : !this.getRepresentation().equals((Object)introState.getRepresentation())) {
            return false;
        }
        if (this.getMaximum() != introState.getMaximum()) {
            return false;
        }
        if (this.getRandomSeed() != introState.getRandomSeed()) {
            return false;
        }
        return !(this.getFactorySet() == null ? introState.getFactorySet() != null : !this.getFactorySet().equals(introState.getFactorySet()));
    }

    public boolean canEqual(Object object) {
        return object instanceof IntroState;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + (this.getContainerSet() == null ? 0 : this.getContainerSet().hashCode());
        n = n * 31 + (this.isShowReduced() ? 1231 : 1237);
        n = n * 31 + (this.isShowMixed() ? 1231 : 1237);
        n = n * 31 + (this.getPieSet() == null ? 0 : this.getPieSet().hashCode());
        n = n * 31 + (this.getHorizontalBarSet() == null ? 0 : this.getHorizontalBarSet().hashCode());
        n = n * 31 + (this.getVerticalBarSet() == null ? 0 : this.getVerticalBarSet().hashCode());
        n = n * 31 + (this.getWaterGlassSet() == null ? 0 : this.getWaterGlassSet().hashCode());
        n = n * 31 + (this.getCakeSet() == null ? 0 : this.getCakeSet().hashCode());
        n = n * 31 + this.getNumerator();
        n = n * 31 + this.getDenominator();
        n = n * 31 + (this.getRepresentation() == null ? 0 : this.getRepresentation().hashCode());
        n = n * 31 + this.getMaximum();
        n = n * 31 + (int)(this.getRandomSeed() >>> 32 ^ this.getRandomSeed());
        n = n * 31 + (this.getFactorySet() == null ? 0 : this.getFactorySet().hashCode());
        return n;
    }

    public String toString() {
        return "IntroState(containerSet=" + this.getContainerSet() + ", showReduced=" + this.isShowReduced() + ", showMixed=" + this.isShowMixed() + ", pieSet=" + this.getPieSet() + ", horizontalBarSet=" + this.getHorizontalBarSet() + ", verticalBarSet=" + this.getVerticalBarSet() + ", waterGlassSet=" + this.getWaterGlassSet() + ", cakeSet=" + this.getCakeSet() + ", numerator=" + this.getNumerator() + ", denominator=" + this.getDenominator() + ", representation=" + (Object)((Object)this.getRepresentation()) + ", maximum=" + this.getMaximum() + ", randomSeed=" + this.getRandomSeed() + ", factorySet=" + this.getFactorySet() + ")";
    }
}

