/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model;

import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroApplication;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetCakeSet;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetCircularPieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetDenominator;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetHorizontalBarSet;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetMaximum;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetNumerator;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetRepresentation;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetVerticalBarSet;
import edu.colorado.phet.fractions.fractionsintro.intro.controller.SetWaterGlassSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.ClientProperty;
import edu.colorado.phet.fractions.fractionsintro.intro.model.IntClientProperty;
import edu.colorado.phet.fractions.fractionsintro.intro.model.IntroState;
import edu.colorado.phet.fractions.fractionsintro.intro.model.RegressionTestRecorder;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.ContainerSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.FactorySet;
import edu.colorado.phet.fractions.fractionsintro.intro.view.Representation;
import fj.F;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionsIntroModel
implements Serializable {
    private final Property<IntroState> state;
    public final Clock clock;
    public final SettableProperty<Representation> representation;
    public final IntegerProperty numerator;
    public final IntegerProperty denominator;
    public final SettableProperty<PieSet> pieSet;
    public final SettableProperty<PieSet> horizontalBarSet;
    public final SettableProperty<PieSet> verticalBarSet;
    public final SettableProperty<PieSet> waterGlassSet;
    public final SettableProperty<PieSet> cakeSet;
    public final IntegerProperty maximum;
    private final IntroState initialState;
    public final FactorySet factorySet;

    public FractionsIntroModel(IntroState introState, FactorySet factorySet) {
        this.factorySet = factorySet;
        this.initialState = introState;
        this.state = new Property<IntroState>(introState);
        this.clock = new ConstantDtClock(){
            {
                this.addClockListener(new ClockAdapter(){

                    public void simulationTimeChanged(ClockEvent clockEvent) {
                        FractionsIntroModel.this.state.set(((IntroState)FractionsIntroModel.this.state.get()).updatePieSets(new F<PieSet, PieSet>(){

                            @Override
                            public PieSet f(PieSet pieSet) {
                                return pieSet.stepInTime();
                            }
                        }));
                    }
                });
            }
        };
        this.representation = new ClientProperty<Representation>(this.state, new F<IntroState, Representation>(){

            @Override
            public Representation f(IntroState introState) {
                return introState.representation;
            }
        }, new F<Representation, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(Representation representation) {
                return FractionsIntroModel.this.evaluate(new SetRepresentation(representation));
            }
        });
        this.numerator = new IntClientProperty(this.state, new F<IntroState, Integer>(){

            @Override
            public Integer f(IntroState introState) {
                return introState.numerator;
            }
        }, new F<Integer, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(Integer n) {
                return FractionsIntroModel.this.evaluate(new SetNumerator(n));
            }
        }).toIntegerProperty();
        this.denominator = new IntClientProperty(this.state, new F<IntroState, Integer>(){

            @Override
            public Integer f(IntroState introState) {
                return introState.denominator;
            }
        }, new F<Integer, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(Integer n) {
                return FractionsIntroModel.this.evaluate(new SetDenominator(n));
            }
        }).toIntegerProperty();
        this.pieSet = new ClientProperty<PieSet>(this.state, new F<IntroState, PieSet>(){

            @Override
            public PieSet f(IntroState introState) {
                return introState.pieSet;
            }
        }, new F<PieSet, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(PieSet pieSet) {
                return FractionsIntroModel.this.evaluate(new SetCircularPieSet(pieSet));
            }
        });
        this.horizontalBarSet = new ClientProperty<PieSet>(this.state, new F<IntroState, PieSet>(){

            @Override
            public PieSet f(IntroState introState) {
                return introState.horizontalBarSet;
            }
        }, new F<PieSet, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(PieSet pieSet) {
                return FractionsIntroModel.this.evaluate(new SetHorizontalBarSet(pieSet));
            }
        });
        this.verticalBarSet = new ClientProperty<PieSet>(this.state, new F<IntroState, PieSet>(){

            @Override
            public PieSet f(IntroState introState) {
                return introState.verticalBarSet;
            }
        }, new F<PieSet, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(PieSet pieSet) {
                return FractionsIntroModel.this.evaluate(new SetVerticalBarSet(pieSet));
            }
        });
        this.waterGlassSet = new ClientProperty<PieSet>(this.state, new F<IntroState, PieSet>(){

            @Override
            public PieSet f(IntroState introState) {
                return introState.waterGlassSet;
            }
        }, new F<PieSet, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(PieSet pieSet) {
                return FractionsIntroModel.this.evaluate(new SetWaterGlassSet(pieSet));
            }
        });
        this.cakeSet = new ClientProperty<PieSet>(this.state, new F<IntroState, PieSet>(){

            @Override
            public PieSet f(IntroState introState) {
                return introState.cakeSet;
            }
        }, new F<PieSet, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(PieSet pieSet) {
                return FractionsIntroModel.this.evaluate(new SetCakeSet(pieSet));
            }
        });
        this.maximum = new IntClientProperty(this.state, new F<IntroState, Integer>(){

            @Override
            public Integer f(IntroState introState) {
                return introState.maximum;
            }
        }, new F<Integer, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(Integer n) {
                return FractionsIntroModel.this.evaluate(new SetMaximum(n));
            }
        }).toIntegerProperty();
        ClientProperty<ContainerSet> clientProperty = new ClientProperty<ContainerSet>(this.state, new F<IntroState, ContainerSet>(){

            @Override
            public ContainerSet f(IntroState introState) {
                return introState.containerSet;
            }
        }, new F<ContainerSet, F<IntroState, IntroState>>(){

            @Override
            public F<IntroState, IntroState> f(ContainerSet containerSet) {
                throw new RuntimeException("Shouldn't be called (should be read-only)");
            }
        });
        clientProperty.addObserver(new VoidFunction1<ContainerSet>(){

            @Override
            public void apply(ContainerSet containerSet) {
                SimSharingManager.sendModelMessage(FractionsIntroSimSharing.ModelComponents.containerSetComponent, FractionsIntroSimSharing.ModelComponentTypes.containerSetComponentType, FractionsIntroSimSharing.ModelActions.changed, ParameterSet.parameterSet((IParameterKey)FractionsIntroSimSharing.ParameterKeys.numerator, containerSet.numerator).with((IParameterKey)FractionsIntroSimSharing.ParameterKeys.denominator, containerSet.denominator).with((IParameterKey)FractionsIntroSimSharing.ParameterKeys.containerSetKey, containerSet.toString()));
            }
        });
    }

    private F<IntroState, IntroState> evaluate(F<IntroState, IntroState> regressionTestRecorder) {
        return FractionsIntroApplication.recordRegressionData ? RegressionTestRecorder.record(regressionTestRecorder) : regressionTestRecorder;
    }

    public void resetAll() {
        this.state.set(this.initialState);
    }

    public Clock getClock() {
        return this.clock;
    }

    public long getRandomSeed() {
        return this.state.get().randomSeed;
    }
}

