/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.equalitylab.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.Times;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.fractions.common.util.Size2D;
import edu.colorado.phet.fractions.common.view.Colors;
import edu.colorado.phet.fractions.fractionsintro.equalitylab.model.SiteMap;
import edu.colorado.phet.fractions.fractionsintro.intro.model.FractionsIntroModel;
import edu.colorado.phet.fractions.fractionsintro.intro.model.IntroState;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Site;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.CakeSliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.CircularSliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.FactorySet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.SliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.StackedHorizontalSliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.VerticalSliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.view.Representation;
import fj.F;
import fj.Unit;
import java.awt.geom.Rectangle2D;

public class EqualityLabModel {
    private static final FactorySet primaryFactorySet = new F<Unit, FactorySet>(){

        @Override
        public FactorySet f(Unit unit) {
            Vector2D vector2D = new Vector2D(100.0, -SliceFactory.stageSize.height + 200.0);
            double d = -112.0;
            SiteMap siteMap = new SiteMap();
            Size2D size2D = new Size2D(250.0, 100.0);
            return new FactorySet(new CircularSliceFactory(3, vector2D, size2D, 135.0, d, 212.5, siteMap, Colors.CIRCLE_COLOR), new StackedHorizontalSliceFactory(vector2D, size2D, Colors.HORIZONTAL_SLICE_COLOR, 239.0, -1.5, false), new VerticalSliceFactory(-120.0, 93.75, 168.75, false, vector2D, size2D, Colors.VERTICAL_SLICE_COLOR, 12.0, false), new VerticalSliceFactory(-117.0, 100.0, 200.0, true, vector2D, size2D, Colors.CUP_COLOR, 5.0, true), new CakeSliceFactory(new Vector2D(SliceFactory.stageSize.width / 2.0, -SliceFactory.stageSize.height + 200.0), size2D));
        }
    }.f(Unit.unit());
    public static final FactorySet scaledFactorySet = new F<Unit, FactorySet>(){

        @Override
        public FactorySet f(Unit unit) {
            Vector2D vector2D = new Vector2D(100.0, -SliceFactory.stageSize.height + 200.0);
            F<Site, Site> f = new F<Site, Site>(){

                @Override
                public Site f(Site site) {
                    return site.eq(0, 0) ? new Site(1, 0) : (site.eq(0, 1) ? new Site(0, 0) : (site.eq(0, 2) ? new Site(1, 1) : (site.eq(1, 0) ? new Site(0, 1) : (site.eq(1, 1) ? new Site(1, 2) : (site.eq(1, 2) ? new Site(0, 2) : null)))));
                }
            };
            Size2D size2D = new Size2D(0.0, 0.0);
            return new FactorySet(new CircularSliceFactory(3, vector2D, size2D, 135.0, 414.0, 212.5, f, Colors.LIGHT_PINK), new StackedHorizontalSliceFactory(vector2D.plus(-20.0, 0.0), size2D, Colors.LIGHT_PINK, 570.0, -1.5, true), new VerticalSliceFactory(400.0, 93.75, 168.75, false, vector2D, size2D, Colors.LIGHT_PINK, 12.0, false), new VerticalSliceFactory(373.0, 100.0, 200.0, true, vector2D, size2D, Colors.LIGHT_PINK, 5.0, true), new CakeSliceFactory(new Vector2D(SliceFactory.stageSize.width / 2.0, -SliceFactory.stageSize.height + 200.0), size2D));
        }
    }.f(Unit.unit());
    private final FractionsIntroModel model = new FractionsIntroModel(IntroState.newState(4, primaryFactorySet, System.currentTimeMillis()), primaryFactorySet);
    public final SettableProperty<PieSet> pieSet;
    public final SettableProperty<PieSet> horizontalBarSet;
    public final SettableProperty<PieSet> verticalBarSet;
    public final Clock clock;
    public final IntegerProperty numerator;
    public final IntegerProperty denominator;
    public final IntegerProperty scale;
    public final Times scaledNumerator;
    public final Times scaledDenominator;
    public final IntegerProperty maximum;
    public final SettableProperty<PieSet> waterGlassSet;
    public final SettableProperty<Representation> leftRepresentation;
    public final Property<Boolean> sameAsLeft;
    public final ObservableProperty<Representation> rightRepresentation;
    public final SettableProperty<PieSet> scaledPieSet;
    public final SettableProperty<PieSet> rightHorizontalBars;
    public final SettableProperty<PieSet> rightVerticalBars;
    public final SettableProperty<PieSet> rightWaterGlasses;

    public EqualityLabModel() {
        this.pieSet = this.model.pieSet;
        this.horizontalBarSet = this.model.horizontalBarSet;
        this.verticalBarSet = this.model.verticalBarSet;
        this.clock = this.model.clock;
        this.numerator = this.model.numerator;
        this.denominator = this.model.denominator;
        this.scale = new IntegerProperty(2);
        this.scaledNumerator = this.model.numerator.times(this.scale);
        this.scaledDenominator = this.model.denominator.times(this.scale);
        this.maximum = this.model.maximum;
        this.waterGlassSet = this.model.waterGlassSet;
        this.leftRepresentation = this.model.representation;
        this.sameAsLeft = new Property<Boolean>(true);
        this.rightRepresentation = new Property<Representation>((Representation)((Object)this.leftRepresentation.get())){
            {
                EqualityLabModel.this.leftRepresentation.addObserver(new VoidFunction1<Representation>(){

                    @Override
                    public void apply(Representation representation) {
                        if (EqualityLabModel.this.sameAsLeft.get().booleanValue()) {
                            this.set(representation);
                        }
                    }
                });
                EqualityLabModel.this.sameAsLeft.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        if (bl.booleanValue()) {
                            this.set(EqualityLabModel.this.leftRepresentation.get());
                        } else {
                            this.set(Representation.NUMBER_LINE);
                        }
                    }
                });
            }
        };
        this.scaledPieSet = new Property<PieSet>((PieSet)this.pieSet.get()){
            {
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.set(EqualityLabModel.scaledFactorySet.circularSliceFactory.fromContainerSetState(((PieSet)EqualityLabModel.this.pieSet.get()).toLazyContainerSet().scale((Integer)EqualityLabModel.this.scale.get())).createScaledCopy());
                    }
                };
                EqualityLabModel.this.pieSet.addObserver(simpleObserver);
                EqualityLabModel.this.scale.addObserver(simpleObserver);
            }
        };
        this.rightHorizontalBars = new Property<PieSet>((PieSet)this.horizontalBarSet.get()){
            {
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.set(EqualityLabModel.scaledFactorySet.horizontalSliceFactory.fromContainerSetState(((PieSet)EqualityLabModel.this.horizontalBarSet.get()).toLazyContainerSet().scale((Integer)EqualityLabModel.this.scale.get())).createScaledCopy());
                    }
                };
                EqualityLabModel.this.horizontalBarSet.addObserver(simpleObserver);
                EqualityLabModel.this.scale.addObserver(simpleObserver);
            }
        };
        this.rightVerticalBars = new Property<PieSet>((PieSet)this.verticalBarSet.get()){
            {
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.set(EqualityLabModel.scaledFactorySet.verticalSliceFactory.fromContainerSetState(((PieSet)EqualityLabModel.this.verticalBarSet.get()).toLazyContainerSet().scale((Integer)EqualityLabModel.this.scale.get())).createScaledCopy());
                    }
                };
                EqualityLabModel.this.verticalBarSet.addObserver(simpleObserver);
                EqualityLabModel.this.scale.addObserver(simpleObserver);
            }
        };
        this.rightWaterGlasses = new Property<PieSet>((PieSet)this.waterGlassSet.get()){
            {
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.set(EqualityLabModel.scaledFactorySet.waterGlassSetFactory.fromContainerSetState(((PieSet)EqualityLabModel.this.waterGlassSet.get()).toLazyContainerSet().scale((Integer)EqualityLabModel.this.scale.get())).createScaledCopy());
                    }
                };
                EqualityLabModel.this.waterGlassSet.addObserver(simpleObserver);
                EqualityLabModel.this.scale.addObserver(simpleObserver);
            }
        };
    }

    public long getRandomSeed() {
        return this.model.getRandomSeed();
    }

    public void resetAll() {
        this.model.resetAll();
        this.scale.reset();
        this.sameAsLeft.reset();
    }

    public Rectangle2D getWaterGlassSetNodeBounds() {
        return EqualityLabModel.primaryFactorySet.waterGlassSetFactory.createEmptyPies((int)1, (int)1).head().cells.head().getShape().getBounds2D();
    }
}

