/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.view;

import edu.colorado.phet.common.games.GameConstants;
import edu.colorado.phet.common.games.GameSettings;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.controlpanel.SettingsOnOffPanel;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.fractionmatcher.model.MatchingGameModel;
import edu.colorado.phet.fractions.fractionmatcher.view.LevelSelectionNode;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.nodes.PImage;
import fj.data.List;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StartScreen
extends PNode {
    public StartScreen(final MatchingGameModel matchingGameModel, final String string, List<PNode> list, final BooleanProperty booleanProperty, Resettable resettable) {
        matchingGameModel.choosingSettings.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    StartScreen.this.setVisible(true);
                    StartScreen.this.setOffset(-AbstractFractionsCanvas.STAGE_SIZE.getWidth(), 0.0);
                    StartScreen.this.animateToPositionScaleRotation(0.0, 0.0, 1.0, 0.0, 400L);
                } else {
                    StartScreen.this.animateToPositionScaleRotation(-AbstractFractionsCanvas.STAGE_SIZE.getWidth(), 0.0, 1.0, 0.0, 400L).setDelegate(new PActivityDelegateAdapter(){

                        public void activityFinished(PActivity pActivity) {
                            StartScreen.this.setVisible(false);
                        }
                    });
                }
            }
        });
        this.setOffset(0.0, 0.0);
        final GameSettings gameSettings = new GameSettings(new IntegerRange(1, 8, 1), (Boolean)booleanProperty.get(), false);
        booleanProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                gameSettings.soundEnabled.set(bl);
            }
        });
        gameSettings.soundEnabled.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                booleanProperty.set(bl);
            }
        });
        VoidFunction0 voidFunction0 = new VoidFunction0(){

            public void apply() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        matchingGameModel.resumeOrStartGame((Integer)gameSettings.level.get(), (Boolean)gameSettings.soundEnabled.get(), (Boolean)gameSettings.timerEnabled.get());
                    }
                });
            }
        };
        final ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode((PNode)new LevelSelectionNode(voidFunction0, gameSettings, matchingGameModel.gameResults, list)){
            {
                this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.getWidth() / 2.0 - this.getFullBounds().getWidth() / 2.0, AbstractFractionsCanvas.STAGE_SIZE.getHeight() / 2.0 - this.getFullBounds().getHeight() / 2.0);
            }
        };
        PNode pNode = new PNode(){
            {
                this.addChild(new PhetPText(string, new PhetFont(38, true)));
                this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.getWidth() / 2.0 - this.getFullBounds().getWidth() / 2.0, zeroOffsetNode.getFullBounds().getMinY() / 3.0 - this.getFullBounds().getHeight() / 2.0);
            }
        };
        this.addChild(zeroOffsetNode);
        this.addChild(pNode);
        BufferedImage bufferedImage = BufferedImageUtils.multiScaleToWidth(GameConstants.STOPWATCH_ICON, 30);
        BufferedImage bufferedImage2 = this.redX(BufferedImageUtils.copyImage(bufferedImage));
        BufferedImage bufferedImage3 = BufferedImageUtils.multiScaleToWidth(GameConstants.SOUND_ICON, 30);
        BufferedImage bufferedImage4 = BufferedImageUtils.multiScaleToWidth(GameConstants.SOUND_OFF_ICON, 30);
        this.addChild(new SettingsOnOffPanel(List.list(new SettingsOnOffPanel.Feature(new PImage(bufferedImage2), new PImage(bufferedImage), gameSettings.timerEnabled, FractionsIntroSimSharing.Components.timerRadioButton), new SettingsOnOffPanel.Feature(new PImage(bufferedImage4), new PImage(bufferedImage3), gameSettings.soundEnabled, FractionsIntroSimSharing.Components.soundRadioButton))){
            {
                this.setOffset(10.0, AbstractFractionsCanvas.STAGE_SIZE.height - this.getFullBounds().getHeight() - 10.0);
            }
        });
        this.addChild(new ResetAllButtonNode(resettable, null, AbstractFractionsCanvas.CONTROL_FONT, Color.black, Color.orange){
            {
                this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.width - this.getFullBounds().getWidth() - 10.0, AbstractFractionsCanvas.STAGE_SIZE.height - this.getFullBounds().getHeight() - 10.0);
                this.setConfirmationEnabled(false);
            }
        });
    }

    private BufferedImage redX(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setPaint(PhetColorScheme.RED_COLORBLIND);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawLine(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.drawLine(bufferedImage.getWidth(), 0, 0, bufferedImage.getHeight());
        graphics2D.dispose();
        return bufferedImage;
    }
}

