/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.fractions.fractionmatcher.model.Cell;
import edu.colorado.phet.fractions.fractionmatcher.model.MatchingGameState;
import edu.colorado.phet.fractions.fractionmatcher.model.Mode;
import edu.colorado.phet.fractions.fractionmatcher.model.Motions;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import edu.colorado.phet.fractions.fractionmatcher.model.UpdateArgs;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import fj.Equal;
import fj.F;
import fj.Ord;
import fj.data.List;
import fj.data.TreeMap;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MovableFractionNode
extends PNode {
    public MovableFractionNode(final SettableProperty<MatchingGameState> settableProperty, final MovableFraction movableFraction, PNode pNode, final PNode pNode2, boolean bl) {
        this.addChild(pNode);
        this.setOffset(movableFraction.position.getX(), movableFraction.position.getY());
        this.centerFullBoundsOnPoint(movableFraction.position.getX(), movableFraction.position.getY());
        this.setPickable(bl);
        this.setChildrenPickable(bl);
        if (!movableFraction.scored) {
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new SimSharingDragHandler(movableFraction.userComponent, UserComponentTypes.sprite, true){

                protected void startDrag(PInputEvent pInputEvent) {
                    super.startDrag(pInputEvent);
                    MatchingGameState matchingGameState = (MatchingGameState)settableProperty.get();
                    settableProperty.set(matchingGameState.withFractions(matchingGameState.fractions.delete(movableFraction, Equal.anyEqual()).snoc(movableFraction.withDragging(true))));
                }

                protected void drag(PInputEvent pInputEvent) {
                    super.drag(pInputEvent);
                    MatchingGameState matchingGameState = (MatchingGameState)settableProperty.get();
                    final PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode2);
                    MatchingGameState matchingGameState2 = matchingGameState.withFractions(matchingGameState.fractions.map(new F<MovableFraction, MovableFraction>(){

                        @Override
                        public MovableFraction f(MovableFraction movableFraction) {
                            return movableFraction.dragging ? movableFraction.translate(pDimension.getWidth(), pDimension.getHeight()) : movableFraction;
                        }
                    }));
                    settableProperty.set(matchingGameState2);
                }

                protected void endDrag(PInputEvent pInputEvent) {
                    super.endDrag(pInputEvent);
                    MatchingGameState matchingGameState = (MatchingGameState)settableProperty.get();
                    final MovableFraction movableFraction2 = matchingGameState.fractions.find(new F<MovableFraction, Boolean>(){

                        @Override
                        public Boolean f(MovableFraction movableFraction) {
                            return movableFraction.dragging;
                        }
                    }).some();
                    MatchingGameState matchingGameState2 = matchingGameState;
                    final Vector2D vector2D = matchingGameState2.rightScale.getAttachmentPoint(movableFraction2);
                    final Vector2D vector2D2 = matchingGameState2.leftScale.getAttachmentPoint(movableFraction2);
                    final HashMap<Vector2D, F<UpdateArgs, MovableFraction>> hashMap = new HashMap<Vector2D, F<UpdateArgs, MovableFraction>>(){
                        {
                            this.put(vector2D, Motions.MOVE_TO_RIGHT_SCALE);
                            this.put(vector2D2, Motions.MOVE_TO_LEFT_SCALE);
                            Cell cell = ((MatchingGameState)settableProperty.get()).getClosestFreeStartCell(movableFraction2);
                            this.put(cell.getPosition(), Motions.moveToCell(cell));
                        }
                    };
                    final Ord<Vector2D> ord = FJUtils.ord(new F<Vector2D, Double>(){

                        @Override
                        public Double f(Vector2D vector2D) {
                            return movableFraction2.position.distance(vector2D);
                        }
                    });
                    List<Vector2D> list = TreeMap.fromMutableMap(ord, hashMap).keys().sort(ord);
                    final Vector2D vector2D3 = list.head();
                    if (vector2D3.equals(vector2D)) {
                        matchingGameState = matchingGameState.jettisonFraction(matchingGameState.rightScale).withRightScaleDropTime(System.currentTimeMillis());
                    }
                    if (vector2D3.equals(vector2D2)) {
                        matchingGameState = matchingGameState.jettisonFraction(matchingGameState.leftScale).withLeftScaleDropTime(System.currentTimeMillis());
                    }
                    List<MovableFraction> list2 = matchingGameState.fractions.map(new F<MovableFraction, MovableFraction>(){

                        @Override
                        public MovableFraction f(MovableFraction movableFraction) {
                            F f = (F)TreeMap.fromMutableMap(ord, hashMap).get(vector2D3).some();
                            return movableFraction.dragging ? movableFraction.withDragging(false).withMotion(f) : movableFraction;
                        }
                    });
                    MatchingGameState matchingGameState3 = matchingGameState.withFractions(list2).withMode(Mode.USER_IS_MOVING_OBJECTS_TO_THE_SCALES);
                    settableProperty.set(matchingGameState3);
                }
            });
        }
    }
}

