/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.view;

import edu.colorado.phet.common.games.GameOverNode;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.fractionmatcher.model.MatchingGameModel;
import edu.colorado.phet.fractions.fractionmatcher.model.MatchingGameState;
import edu.colorado.phet.fractions.fractionmatcher.model.Mode;
import edu.colorado.phet.fractions.fractionmatcher.view.UpdateNode;
import edu.umd.cs.piccolo.PNode;
import fj.Effect;
import java.text.DecimalFormat;

class GameOverDialog {
    public static UpdateNode createGameOverDialog(final MatchingGameModel matchingGameModel) {
        return new UpdateNode(new Effect<PNode>(){

            @Override
            public void e(PNode pNode) {
                pNode.removeAllChildren();
                if (matchingGameModel.mode.get() == Mode.SHOWING_GAME_OVER_SCREEN) {
                    MatchingGameState matchingGameState = matchingGameModel.state.get();
                    pNode.addChild(new GameOverNode(matchingGameState.info.level, (double)matchingGameState.info.score, 12.0, new DecimalFormat("0"), matchingGameState.info.time, matchingGameState.info.bestTime, matchingGameState.info.time >= matchingGameState.info.bestTime, matchingGameState.info.timerVisible){
                        {
                            this.scale(1.5);
                            this.centerFullBoundsOnPoint(AbstractFractionsCanvas.STAGE_SIZE.getWidth() / 2.0, AbstractFractionsCanvas.STAGE_SIZE.getHeight() / 2.0);
                            this.addGameOverListener(new GameOverNode.GameOverListener(){

                                public void newGamePressed() {
                                    matchingGameModel.startNewGame();
                                }
                            });
                        }
                    });
                }
            }
        }, matchingGameModel.mode);
    }
}

