/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.CompositeBooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.Min;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.fractions.FractionsResources;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.common.view.FNode;
import edu.colorado.phet.fractions.common.view.LevelSelectionScreenButton;
import edu.colorado.phet.fractions.fractionmatcher.model.Cell;
import edu.colorado.phet.fractions.fractionmatcher.model.MatchingGameModel;
import edu.colorado.phet.fractions.fractionmatcher.model.Mode;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import edu.colorado.phet.fractions.fractionmatcher.view.BarGraphNodeBars;
import edu.colorado.phet.fractions.fractionmatcher.view.Button;
import edu.colorado.phet.fractions.fractionmatcher.view.ButtonArgs;
import edu.colorado.phet.fractions.fractionmatcher.view.Controller;
import edu.colorado.phet.fractions.fractionmatcher.view.GameButtonsNode;
import edu.colorado.phet.fractions.fractionmatcher.view.GameOverDialog;
import edu.colorado.phet.fractions.fractionmatcher.view.MovableFractionNode;
import edu.colorado.phet.fractions.fractionmatcher.view.RewardNode;
import edu.colorado.phet.fractions.fractionmatcher.view.ScoreboardNode;
import edu.colorado.phet.fractions.fractionmatcher.view.SignNode;
import edu.colorado.phet.fractions.fractionmatcher.view.UpdateNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import fj.Effect;
import fj.F;
import fj.data.Option;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;

class GameNode
extends PNode {
    private final int FADE_DURATION = 400;

    public GameNode(boolean bl, final MatchingGameModel matchingGameModel, final PNode pNode, final PNode pNode2) {
        this.addChild(new RewardNode(matchingGameModel));
        matchingGameModel.addRefreshListener(new VoidFunction0(){

            public void apply() {
                GameNode.this.animateToTransparency(0.0f, 400L).setDelegate(new PActivityDelegateAdapter(){

                    public void activityFinished(PActivity pActivity) {
                        matchingGameModel.finishRefresh();
                        GameNode.this.animateToTransparency(1.0f, 400L);
                    }
                });
            }
        });
        CompositeBooleanProperty compositeBooleanProperty = new CompositeBooleanProperty(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return matchingGameModel.state.get().info.mode != Mode.CHOOSING_SETTINGS;
            }
        }, (ObservableProperty<?>[])new ObservableProperty[]{matchingGameModel.state});
        compositeBooleanProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    GameNode.this.setVisible(true);
                    GameNode.this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.getWidth(), 0.0);
                    GameNode.this.animateToPositionScaleRotation(0.0, 0.0, 1.0, 0.0, 400L);
                } else {
                    GameNode.this.animateToPositionScaleRotation(AbstractFractionsCanvas.STAGE_SIZE.getWidth(), 0.0, 1.0, 0.0, 400L).setDelegate(new PActivityDelegateAdapter(){

                        public void activityFinished(PActivity pActivity) {
                            GameNode.this.setVisible(false);
                        }
                    });
                }
            }
        });
        this.setVisible(false);
        final RichPNode richPNode = new RichPNode(matchingGameModel.state.get().leftScale.toNode(), matchingGameModel.state.get().rightScale.toNode());
        this.addChild(richPNode);
        Min min = new Min(matchingGameModel.barGraphAnimationTime, new Property<Double>(0.375));
        this.addChild(new UpdateNode(new Effect<PNode>(){

            @Override
            public void e(PNode pNode2) {
                final double d = Math.min(matchingGameModel.barGraphAnimationTime.get() / 0.375, 1.0);
                final Option<MovableFraction> option = matchingGameModel.state.get().getScaleFraction(matchingGameModel.state.get().leftScale);
                final Option<MovableFraction> option2 = matchingGameModel.state.get().getScaleFraction(matchingGameModel.state.get().rightScale);
                if (option.isSome() && option2.isSome()) {
                    pNode2.addChild(new ZeroOffsetNode(new PNode(){
                        {
                            this.addChild(pNode);
                            if (matchingGameModel.revealClues.get().booleanValue()) {
                                this.addChild(new BarGraphNodeBars(matchingGameModel.leftScaleValue.get() * d, ((MovableFraction)option.some()).color, matchingGameModel.rightScaleValue.get() * d, ((MovableFraction)option2.some()).color));
                            }
                        }
                    }){
                        {
                            this.setOffset(richPNode.getFullBounds().getCenterX() - 100.0, richPNode.getFullBounds().getCenterY() - 15.0 - 400.0);
                            this.setOffset(richPNode.getFullBounds().getCenterX() - this.getFullWidth() / 2.0, richPNode.getFullBounds().getCenterY() - this.getFullHeight() - 15.0);
                        }
                    });
                }
            }
        }, matchingGameModel.leftScaleValue, matchingGameModel.rightScaleValue, matchingGameModel.revealClues, min));
        final FNode fNode = new FNode(matchingGameModel.state.get().scoreCells.map(new F<Cell, PNode>(){

            @Override
            public PNode f(Cell cell) {
                return new PhetPPath(cell.toRoundedRectangle(), Color.lightGray);
            }
        }));
        this.addChild(fNode);
        final PhetPText phetPText = new PhetPText(FractionsResources.Strings.MY_MATCHES, new PhetFont(18, true)){
            {
                super(string, font);
                double d = fNode.getChild(0).getFullBounds().getX();
                this.setOffset(d, fNode.getMaxY());
            }
        };
        this.addChild(phetPText);
        this.addChild(new FNode(matchingGameModel.state.get().startCells.map(new F<Cell, PNode>(){

            @Override
            public PNode f(Cell cell) {
                return new PhetPPath(cell.rectangle.toRectangle2D(), (Stroke)new BasicStroke(1.0f), (Paint)Color.lightGray);
            }
        })));
        this.addChild(new UpdateNode(new Effect<PNode>(){

            @Override
            public void e(PNode pNode) {
                Iterator<Integer> iterator = matchingGameModel.fractionIDs.get().iterator();
                while (iterator.hasNext()) {
                    int n;
                    final int n2 = n = iterator.next().intValue();
                    pNode.addChild(new PNode(){
                        {
                            CompositeProperty<MovableFraction> compositeProperty = new CompositeProperty<MovableFraction>(new Function0<MovableFraction>(){

                                @Override
                                public MovableFraction apply() {
                                    return matchingGameModel.state.get().fractions.find(new F<MovableFraction, Boolean>(){

                                        @Override
                                        public Boolean f(MovableFraction movableFraction) {
                                            return movableFraction.id.value == n2;
                                        }
                                    }).orSome(null);
                                }
                            }, matchingGameModel.state);
                            compositeProperty.addObserver(new VoidFunction1<MovableFraction>(){

                                @Override
                                public void apply(MovableFraction movableFraction) {
                                    this.removeAllChildren();
                                    if (movableFraction != null) {
                                        this.addChild(new MovableFractionNode(matchingGameModel.state, movableFraction, movableFraction.getNodeWithCorrectScale(), pNode2, matchingGameModel.revealClues.get() == false));
                                    }
                                }
                            });
                        }
                    });
                }
            }
        }, matchingGameModel.fractionIDs, matchingGameModel.revealClues));
        final LevelSelectionScreenButton levelSelectionScreenButton = new LevelSelectionScreenButton(new VoidFunction0(){

            public void apply() {
                matchingGameModel.levelSelectionButtonPressed();
            }
        }, FractionsResources.Images.FRACTIONS_BUTTON_MATCHING){
            {
                super(voidFunction0, bufferedImage);
                this.setOffset(10.0, phetPText.getMaxY() + 20.0);
            }
        };
        this.addChild(new UpdateNode(new Effect<PNode>(){

            @Override
            public void e(PNode pNode) {
                pNode.addChild(new ScoreboardNode(matchingGameModel, levelSelectionScreenButton){
                    {
                        this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.width - 20.0, fNode.getMaxY() + 10.0);
                        this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.width - this.getFullBounds().getWidth() - 20.0, fNode.getMaxY() + 10.0);
                    }
                });
            }
        }, matchingGameModel.level, matchingGameModel.score, matchingGameModel.timerVisible, matchingGameModel.timeInSec));
        final F<ButtonArgs, Button> f = new F<ButtonArgs, Button>(){

            @Override
            public Button f(final ButtonArgs buttonArgs) {
                return new Button(buttonArgs.component, buttonArgs.text, buttonArgs.color, buttonArgs.location, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        matchingGameModel.state.set(buttonArgs.listener.f(matchingGameModel.state.get()));
                    }
                });
            }
        };
        final CompositeProperty<Vector2D> compositeProperty = new CompositeProperty<Vector2D>(new Function0<Vector2D>(){

            @Override
            public Vector2D apply() {
                return new Vector2D(richPNode.getFullBounds().getX() - 80.0, richPNode.getFullBounds().getCenterY());
            }
        }, matchingGameModel.leftScaleValue, matchingGameModel.rightScaleValue);
        this.addChild(new UpdateNode(new Effect<PNode>(){

            @Override
            public void e(PNode pNode) {
                pNode.addChild(new GameButtonsNode(matchingGameModel.state.get(), f, (Vector2D)compositeProperty.get()));
            }
        }, matchingGameModel.leftScaleValue, matchingGameModel.rightScaleValue, matchingGameModel.mode, matchingGameModel.checks, compositeProperty));
        this.addChild(new UpdateNode(new Effect<PNode>(){

            @Override
            public void e(PNode pNode) {
                pNode.addChild(matchingGameModel.revealClues.get() != false ? new SignNode(matchingGameModel.state.get(), richPNode) : new PNode());
            }
        }, matchingGameModel.leftScaleValue, matchingGameModel.rightScaleValue, matchingGameModel.mode, matchingGameModel.revealClues));
        this.addChild(new UpdateNode(new Effect<PNode>(){

            @Override
            public void e(PNode pNode) {
                pNode.addChild(new FNode(matchingGameModel.state.get().scoreCells.take(matchingGameModel.state.get().scored).map(new F<Cell, PNode>(){

                    @Override
                    public PNode f(final Cell cell) {
                        return new PhetPText("=", new PhetFont(22)){
                            {
                                super(string, font);
                                this.centerFullBoundsOnPoint(cell.rectangle.getCenter());
                            }
                        };
                    }
                })));
            }
        }, matchingGameModel.scored));
        if (bl) {
            this.addChild(new HBox((PNode)f.f(new ButtonArgs(null, "Resample", Color.red, new Vector2D(100.0, 6.0), new Controller.Resample(matchingGameModel.levelFactory))), (PNode)f.f(new ButtonArgs(null, "Test game over", Color.green, new Vector2D(100.0, 6.0), new Controller.GameOver()))));
        }
        this.addChild(GameOverDialog.createGameOverDialog(matchingGameModel));
    }
}

