/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.fractions.fractionmatcher.view.PatternType;
import fj.F;
import fj.data.List;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pattern {
    public final Shape outline;
    public final List<Shape> shapes;
    public final PatternType type;

    Pattern(final List<Shape> list, PatternType patternType) {
        this(new Area(){
            {
                for (Shape shape : list) {
                    this.add(new Area(shape));
                }
            }
        }, list, patternType);
    }

    private Pattern(Shape shape, List<Shape> list, PatternType patternType) {
        this.outline = shape;
        this.shapes = list;
        this.type = patternType;
    }

    private static Rectangle2D.Double square(double d, double d2, double d3) {
        return new Rectangle2D.Double(d, d2, d3, d3);
    }

    public static Pattern interleavedLShape(final int n, final int n2, final int n3) {
        return new Pattern(List.iterableList(new ArrayList<Shape>(){
            {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        this.add(AffineTransform.getTranslateInstance(n * i, n * j).createTransformedShape(Pattern.interleavedLShapeLeftSide(n)));
                        this.add(AffineTransform.getTranslateInstance(n * i, n * j).createTransformedShape(Pattern.interleavedLShapeRightSide(n)));
                    }
                }
            }
        }), PatternType.interleavedLShape);
    }

    private static Shape interleavedLShapeLeftSide(double d) {
        return Pattern.pointsToShape(d, List.list(Vector2D.v(0.0, 0.0), Vector2D.v(0.3333333333333333, 0.0), Vector2D.v(0.3333333333333333, 0.5), Vector2D.v(0.6666666666666666, 0.5), Vector2D.v(0.6666666666666666, 1.0), Vector2D.v(0.0, 1.0)));
    }

    private static Shape interleavedLShapeRightSide(double d) {
        return Pattern.pointsToShape(d, List.list(Vector2D.v(1.0, 0.0), Vector2D.v(1.0, 1.0), Vector2D.v(0.6666666666666666, 1.0), Vector2D.v(0.6666666666666666, 0.5), Vector2D.v(0.3333333333333333, 0.5), Vector2D.v(0.3333333333333333, 0.0)));
    }

    public static Pattern letterLShapedDiagonal(final int n, final int n2) {
        return new Pattern(List.iterableList(new ArrayList<Shape>(){
            {
                for (int i = 0; i < n2; ++i) {
                    this.add(Pattern.letterLShapedDiagonalTopL(n, i * 2, i));
                    this.add(Pattern.letterLShapedDiagonalBottomL(n, i * 2, i));
                }
            }
        }), PatternType.letterLShapedDiagonal);
    }

    private static Shape letterLShapedDiagonalTopL(int n, int n2, int n3) {
        return AffineTransform.getTranslateInstance(n2 * n, n3 * n).createTransformedShape(Pattern.pointsToShape(n, List.list(Vector2D.v(0.0, 0.0), Vector2D.v(2.0, 0.0), Vector2D.v(2.0, 3.0), Vector2D.v(1.0, 3.0), Vector2D.v(1.0, 1.0), Vector2D.v(0.0, 1.0))));
    }

    private static Shape letterLShapedDiagonalBottomL(int n, int n2, int n3) {
        return AffineTransform.getTranslateInstance(n2 * n, n3 * n).createTransformedShape(Pattern.pointsToShape(n, List.list(Vector2D.v(0.0, 1.0), Vector2D.v(1.0, 1.0), Vector2D.v(1.0, 3.0), Vector2D.v(2.0, 3.0), Vector2D.v(2.0, 4.0), Vector2D.v(0.0, 4.0))));
    }

    public static Pattern tetrisPiece(int n) {
        return new Pattern(List.list(Pattern.pointsToShape((double)n / 3.0, List.list(Vector2D.v(0.0, 0.0), Vector2D.v(3.0, 0.0), Vector2D.v(3.0, 1.0), Vector2D.v(2.0, 1.0), Vector2D.v(2.0, 2.0), Vector2D.v(1.0, 2.0), Vector2D.v(1.0, 1.0), Vector2D.v(0.0, 1.0))), Pattern.pointsToShape((double)n / 3.0, List.list(Vector2D.v(3.0, 0.0), Vector2D.v(4.0, 0.0), Vector2D.v(4.0, 3.0), Vector2D.v(3.0, 3.0), Vector2D.v(3.0, 2.0), Vector2D.v(2.0, 2.0), Vector2D.v(2.0, 1.0), Vector2D.v(3.0, 1.0))), Pattern.pointsToShape((double)n / 3.0, List.list(Vector2D.v(4.0, 3.0), Vector2D.v(4.0, 4.0), Vector2D.v(1.0, 4.0), Vector2D.v(1.0, 3.0), Vector2D.v(2.0, 3.0), Vector2D.v(2.0, 2.0), Vector2D.v(3.0, 2.0), Vector2D.v(3.0, 3.0))), Pattern.pointsToShape((double)n / 3.0, List.list(Vector2D.v(0.0, 4.0), Vector2D.v(0.0, 1.0), Vector2D.v(1.0, 1.0), Vector2D.v(1.0, 2.0), Vector2D.v(2.0, 2.0), Vector2D.v(2.0, 3.0), Vector2D.v(1.0, 3.0), Vector2D.v(1.0, 4.0)))), PatternType.tetrisPiece);
    }

    private static Shape pointsToShape(final double d, final List<Vector2D> list) {
        return new DoubleGeneralPath(list.head().times(d)){
            {
                super(vector2D);
                for (Vector2D vector2D2 : list.tail()) {
                    this.lineTo(vector2D2.times(d));
                }
                this.lineTo(((Vector2D)list.head()).times(d));
            }
        }.getGeneralPath();
    }

    public static Pattern sixFlower() {
        return Pattern.sixFlower(18);
    }

    private static Pattern sixFlower(final Integer n) {
        return new Pattern(List.range(0, 6).map(new F<Integer, Shape>(){

            @Override
            public Shape f(Integer n2) {
                double d = Math.sin(0.5235987755982988);
                double d2 = Math.cos(0.5235987755982988);
                return AffineTransform.getRotateInstance(1.0471975511965976 * (double)n2.intValue(), 0.0, 0.0).createTransformedShape(Pattern.pointsToShape(n.intValue(), List.list(Vector2D.v(0.0, 0.0), Vector2D.v(d, d2), Vector2D.v(0.0, d2 * 2.0), Vector2D.v(-d, d2))));
            }
        }), PatternType.sixFlower);
    }

    public static Pattern horizontalBars(int n) {
        final double d = 70.0 / (double)n;
        return new Pattern(List.range(0, n).map(new F<Integer, Shape>(){

            @Override
            public Shape f(Integer n) {
                return new Rectangle2D.Double(0.0, (double)n.intValue() * d, 70.0, d);
            }
        }).reverse(), PatternType.horizontalBars);
    }

    public static Pattern tallHorizontalBars(int n) {
        final double d = 70.0 / (double)n * 1.25;
        return new Pattern(List.range(0, n).map(new F<Integer, Shape>(){

            @Override
            public Shape f(Integer n) {
                return new Rectangle2D.Double(0.0, (double)n.intValue() * d, 70.0, d);
            }
        }).reverse(), PatternType.horizontalBars);
    }

    public static Pattern verticalBars(int n) {
        final double d = 70.0 / (double)n;
        return new Pattern(List.range(0, n).map(new F<Integer, Shape>(){

            @Override
            public Shape f(Integer n) {
                return new Rectangle2D.Double((double)n.intValue() * d, 0.0, d, 70.0);
            }
        }), PatternType.verticalBars);
    }

    public static Pattern pie(int n) {
        double d = 360.0 / (double)n;
        Rectangle rectangle = new Rectangle(0, 0, 70, 70);
        ArrayList<Ellipse2D.Double> arrayList = new ArrayList<Ellipse2D.Double>();
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * d;
            Arc2D.Double double_ = new Arc2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), d2, d, 2);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            RectangularShape rectangularShape = n <= 1 ? double_2 : double_;
            arrayList.add((Ellipse2D.Double)rectangularShape);
        }
        return new Pattern(new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height), List.iterableList(arrayList), PatternType.pie);
    }

    public static Pattern polygon(double d, int n) {
        final double d2 = Math.PI * 2 / (double)n;
        final double d3 = d / 2.0;
        List<Shape> list = List.range(0, n).map(new F<Integer, Shape>(){

            @Override
            public Shape f(Integer n) {
                final double d = 1.5707963267948966 - d2 / 2.0 + (double)n.intValue() * d2;
                final double d22 = 1.5707963267948966 + d2 / 2.0 + (double)n.intValue() * d2;
                return new DoubleGeneralPath(Vector2D.ZERO){
                    {
                        super(vector2D);
                        this.lineTo(Vector2D.createPolar(d3, d));
                        this.lineTo(Vector2D.createPolar(d3, d22));
                        this.lineTo(Vector2D.ZERO);
                    }
                }.getGeneralPath();
            }
        });
        Vector2D vector2D = Vector2D.createPolar(d3, 1.5707963267948966 - d2 / 2.0);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(vector2D);
        for (int i = 0; i < n; ++i) {
            doubleGeneralPath.lineTo(Vector2D.createPolar(d3, 1.5707963267948966 - d2 / 2.0 + (double)i * d2));
        }
        doubleGeneralPath.lineTo(vector2D);
        return new Pattern(doubleGeneralPath.getGeneralPath(), list, PatternType.polygon);
    }

    public static Pattern gridBig() {
        return new Pattern(List.list(new Rectangle2D.Double(0.0, 0.0, 60.0, 60.0)), PatternType.grid);
    }

    private static Shape plusSign(double d, double d2, final double d3) {
        return new DoubleGeneralPath(d * d3 + d3, d2 * d3){
            {
                super(d, d2);
                this.move(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.UP, Direction.LEFT, Direction.UP, Direction.RIGHT, Direction.UP);
            }

            private void move(Direction ... directionArray) {
                for (Direction direction : directionArray) {
                    this.lineToRelative(direction.vector.times(d3));
                }
            }
        }.getGeneralPath();
    }

    public static Grid grid(int n) {
        return new Grid(n);
    }

    public static Pattern horizontallySlicedCube3() {
        Pattern pattern = new Pattern(List.list(new Rectangle2D.Double(0.0, 0.0, 60.0, 20.0), new Rectangle2D.Double(0.0, 20.0, 60.0, 20.0), new Rectangle2D.Double(0.0, 40.0, 60.0, 20.0)), PatternType.horizontallySlicedCube);
        return pattern;
    }

    public static Pattern verticallySlicedCube3() {
        Pattern pattern = new Pattern(List.list(new Rectangle2D.Double(0.0, 0.0, 20.0, 60.0), new Rectangle2D.Double(20.0, 0.0, 20.0, 60.0), new Rectangle2D.Double(40.0, 0.0, 20.0, 60.0)), PatternType.verticallySlicedCube);
        return pattern;
    }

    public static PlusSigns plusSigns(int n) {
        return new PlusSigns(n);
    }

    private static Shape triangle(final double d, final Vector2D vector2D, final Vector2D vector2D2) {
        return new DoubleGeneralPath(){
            {
                this.moveTo(vector2D.toPoint2D());
                this.lineTo(vector2D.plus(vector2D2.getRotatedInstance(Math.toRadians(150.0)).times(d)).toPoint2D());
                this.lineTo(vector2D.plus(vector2D2.getRotatedInstance(Math.toRadians(-150.0)).times(d)).toPoint2D());
                this.lineTo(vector2D.toPoint2D());
            }
        }.getGeneralPath();
    }

    public static Pattern pyramidSingle() {
        return Pyramid.single();
    }

    public static Pattern pyramidFour() {
        return Pyramid.four();
    }

    public static Pattern pyramidNine() {
        return Pyramid.nine();
    }

    public static Pattern ringOfHexagons() {
        double d = 8.0;
        double d2 = (50.0 - d) * 0.5;
        return new Pattern(List.list(Pattern.translate(0.0, -d2, Pattern.hex()), Pattern.translate(0.0, 0.0, Pattern.hex()), Pattern.translate(0.0, d2, Pattern.hex()), Pattern.translate(d2 * Math.cos(Math.toRadians(30.0)), d2 * Math.sin(Math.toRadians(30.0)), Pattern.hex()), Pattern.translate(d2 * Math.cos(Math.toRadians(30.0)), -d2 * Math.sin(Math.toRadians(30.0)), Pattern.hex()), Pattern.translate(-d2 * Math.cos(Math.toRadians(30.0)), d2 * Math.sin(Math.toRadians(30.0)), Pattern.hex()), Pattern.translate(-d2 * Math.cos(Math.toRadians(30.0)), -d2 * Math.sin(Math.toRadians(30.0)), Pattern.hex())), PatternType.ringOfHexagons);
    }

    private static Shape hex() {
        return Pattern.polygon((double)25.0, (int)6).outline;
    }

    public static Pattern ninjaStar() {
        double d = 0.3333333333333333;
        double d2 = 100.0 * d;
        double d3 = 65.0 * d;
        double d4 = Math.abs(Math.cos(Math.toDegrees(45.0)));
        final List<Vector2D> list = List.list(Vector2D.v(0.0, -d2), Vector2D.v(d3 * d4, -d3 * d4), Vector2D.v(d2, 0.0), Vector2D.v(d3 * d4, d3 * d4), Vector2D.v(0.0, d2), Vector2D.v(-d3 * d4, d3 * d4), Vector2D.v(-d2, 0.0), Vector2D.v(-d3 * d4, -d3 * d4));
        final F<Integer, Shape> f = new F<Integer, Shape>(){

            @Override
            public Shape f(final Integer n) {
                return new DoubleGeneralPath(0.0, 0.0){
                    {
                        super(d, d2);
                        this.lineTo(((Vector2D)list.index(n % list.length())).toPoint2D());
                        this.lineTo(((Vector2D)list.index((n + 1) % list.length())).toPoint2D());
                        this.lineTo(0.0, 0.0);
                    }
                }.getGeneralPath();
            }
        };
        return new Pattern(List.range(0, 8).map(new F<Integer, Shape>(){

            @Override
            public Shape f(Integer n) {
                return (Shape)f.f(n);
            }
        }), PatternType.ninjaStar);
    }

    public static Pattern fivePointStarWithLeaves() {
        return new Pattern(List.range(0, 5).bind(new F<Integer, List<Shape>>(){

            @Override
            public List<Shape> f(Integer n) {
                double d = Math.sin(0.6283185307179586);
                double d2 = Math.cos(0.6283185307179586);
                Shape shape = AffineTransform.getRotateInstance(1.2566370614359172 * (double)n.intValue() + Math.PI, 0.0, 0.0).createTransformedShape(Pattern.pointsToShape(24.0, List.list(Vector2D.v(0.0, 0.0), Vector2D.v(d, d2), Vector2D.v(0.0, d2 * 2.0))));
                Shape shape2 = AffineTransform.getRotateInstance(1.2566370614359172 * (double)n.intValue() + Math.PI, 0.0, 0.0).createTransformedShape(Pattern.pointsToShape(24.0, List.list(Vector2D.v(0.0, 0.0), Vector2D.v(-d, d2), Vector2D.v(0.0, d2 * 2.0))));
                return List.list(shape, shape2);
            }
        }), PatternType.fivePointStarWithLeaves);
    }

    private static Shape translate(double d, double d2, Shape shape) {
        return AffineTransform.getTranslateInstance(d, d2).createTransformedShape(shape);
    }

    public static class Direction {
        public static final Direction RIGHT = new Direction(1.0, 0.0);
        public static final Direction LEFT = new Direction(-1.0, 0.0);
        public static final Direction DOWN = new Direction(0.0, 1.0);
        public static final Direction UP = new Direction(0.0, -1.0);
        public final Vector2D vector;

        public Direction(double d, double d2) {
            this.vector = new Vector2D(d, d2);
        }
    }

    private static class Grid
    extends Pattern {
        public Grid(final int n) {
            super(List.iterableList(new ArrayList<Shape>(){
                {
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n; ++j) {
                            this.add(Pattern.square((double)i * 20.0, (double)j * 20.0, 20.0));
                        }
                    }
                }
            }), PatternType.grid);
        }
    }

    private static class PlusSigns
    extends Pattern {
        public static final Function.LinearFunction fun = new Function.LinearFunction(1.0, 6.0, 20.0, 10.0);

        public PlusSigns(int n) {
            super(List.list(Pattern.plusSign(1.0, 0.0, PlusSigns.fun.evaluate(n)), Pattern.plusSign(0.0, 2.0, PlusSigns.fun.evaluate(n)), Pattern.plusSign(3.0, 1.0, PlusSigns.fun.evaluate(n)), Pattern.plusSign(2.0, 3.0, PlusSigns.fun.evaluate(n)), Pattern.plusSign(5.0, 2.0, PlusSigns.fun.evaluate(n)), Pattern.plusSign(4.0, 4.0, PlusSigns.fun.evaluate(n))).take(n), PatternType.plusSigns);
        }
    }

    private static class Pyramid {
        public static final Vector2D UP = new Vector2D(0.0, -1.0);
        public static final Vector2D DOWN = new Vector2D(0.0, 1.0);

        private static double getHeight(double d) {
            return Math.sqrt(3.0) / 2.0 * d;
        }

        public static Pattern single() {
            return Pyramid.single(80.0);
        }

        public static Pattern four() {
            return Pyramid.four(40.0);
        }

        public static Pattern nine() {
            return Pyramid.nine(26.666666666666668);
        }

        public static Pattern single(double d) {
            return new Pattern(List.single(Pattern.triangle(d, new Vector2D(0.0, 0.0), Pyramid.UP)), PatternType.singlePyramid);
        }

        public static Pattern four(double d) {
            double d2 = Pyramid.getHeight(d);
            return new Pattern(Pyramid.single((double)(d * 2.0)).outline, Pyramid.single((double)d).shapes.append(List.list(Pattern.triangle(d, new Vector2D(-d / 2.0, d2), Pyramid.UP), Pattern.triangle(d, new Vector2D(0.0, d2 * 2.0), Pyramid.DOWN), Pattern.triangle(d, new Vector2D(d / 2.0, d2), Pyramid.UP))), PatternType.fourPyramid);
        }

        public static Pattern nine(double d) {
            double d2 = Pyramid.getHeight(d);
            return new Pattern(Pyramid.single((double)(d * 3.0)).outline, Pyramid.four((double)d).shapes.append(List.list(Pattern.triangle(d, new Vector2D(-d, d2 * 2.0), Pyramid.UP), Pattern.triangle(d, new Vector2D(-d / 2.0, d2 * 3.0), Pyramid.DOWN), Pattern.triangle(d, new Vector2D(0.0, d2 * 2.0), Pyramid.UP), Pattern.triangle(d, new Vector2D(d / 2.0, d2 * 3.0), Pyramid.DOWN), Pattern.triangle(d, new Vector2D(d, d2 * 2.0), Pyramid.UP))), PatternType.ninePyramid);
        }
    }
}

