/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.fractions.fractionmatcher.model.Cell;
import edu.colorado.phet.fractions.fractionmatcher.model.Motions;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFractionID;
import edu.colorado.phet.fractions.fractionmatcher.model.UpdateArgs;
import edu.umd.cs.piccolo.PNode;
import fj.F;
import java.awt.Color;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovableFraction {
    public final MovableFractionID id;
    public final Vector2D position;
    public final int numerator;
    public final int denominator;
    public final boolean dragging;
    public final Cell home;
    public final double scale;
    public final PNode node;
    public final F<UpdateArgs, MovableFraction> motion;
    public final boolean scored;
    public final IUserComponent userComponent;
    public final Color color;
    public final String representationName;

    public MovableFraction translate(double d, double d2) {
        return this.withPosition(this.position.plus(d, d2));
    }

    MovableFraction translate(Vector2D vector2D) {
        return this.translate(vector2D.getX(), vector2D.getY());
    }

    public MovableFraction withDragging(boolean bl) {
        return new MovableFraction(this.id, this.position, this.numerator, this.denominator, bl, this.home, this.scale, this.node, this.motion, this.scored, this.userComponent, this.color, this.representationName);
    }

    MovableFraction withPosition(Vector2D vector2D) {
        return new MovableFraction(this.id, vector2D, this.numerator, this.denominator, this.dragging, this.home, this.scale, this.node, this.motion, this.scored, this.userComponent, this.color, this.representationName);
    }

    public MovableFraction withScale(double d) {
        return new MovableFraction(this.id, this.position, this.numerator, this.denominator, this.dragging, this.home, d, this.node, this.motion, this.scored, this.userComponent, this.color, this.representationName);
    }

    public MovableFraction withMotion(F<UpdateArgs, MovableFraction> f) {
        return new MovableFraction(this.id, this.position, this.numerator, this.denominator, this.dragging, this.home, this.scale, this.node, f, this.scored, this.userComponent, this.color, this.representationName);
    }

    public MovableFraction withScored(boolean bl) {
        return new MovableFraction(this.id, this.position, this.numerator, this.denominator, this.dragging, this.home, this.scale, this.node, this.motion, bl, this.userComponent, this.color, this.representationName);
    }

    public MovableFraction stepInTime(UpdateArgs updateArgs) {
        return this.motion.f(updateArgs);
    }

    public MovableFraction stepTowards(Vector2D vector2D, double d) {
        double d2 = 600.0;
        double d3 = d2 * d;
        if (this.position.distance(vector2D) < d3) {
            return this.withPosition(vector2D).withMotion(Motions.WAIT);
        }
        MovableFraction movableFraction = this.translate(vector2D.minus(this.position).getInstanceOfMagnitude(d3));
        return movableFraction.position.distance(vector2D) <= d3 ? movableFraction.withMotion(new F<UpdateArgs, MovableFraction>(){

            @Override
            public MovableFraction f(UpdateArgs updateArgs) {
                return updateArgs.fraction;
            }
        }).withPosition(vector2D) : movableFraction;
    }

    public double getFractionValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public MovableFraction scaleTowards(double d) {
        if (d == this.scale) {
            return this;
        }
        double d2 = (d - this.scale) / Math.abs(d - this.scale) * 0.02;
        return this.withScale(this.scale + d2);
    }

    public PNode getNodeWithCorrectScale() {
        this.node.setScale(this.scale);
        this.node.setParent(null);
        return this.node;
    }

    @ConstructorProperties(value={"id", "position", "numerator", "denominator", "dragging", "home", "scale", "node", "motion", "scored", "userComponent", "color", "representationName"})
    public MovableFraction(MovableFractionID movableFractionID, Vector2D vector2D, int n, int n2, boolean bl, Cell cell, double d, PNode pNode, F<UpdateArgs, MovableFraction> f, boolean bl2, IUserComponent iUserComponent, Color color, String string) {
        this.id = movableFractionID;
        this.position = vector2D;
        this.numerator = n;
        this.denominator = n2;
        this.dragging = bl;
        this.home = cell;
        this.scale = d;
        this.node = pNode;
        this.motion = f;
        this.scored = bl2;
        this.userComponent = iUserComponent;
        this.color = color;
        this.representationName = string;
    }

    public MovableFractionID getId() {
        return this.id;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public Cell getHome() {
        return this.home;
    }

    public double getScale() {
        return this.scale;
    }

    public PNode getNode() {
        return this.node;
    }

    public F<UpdateArgs, MovableFraction> getMotion() {
        return this.motion;
    }

    public boolean isScored() {
        return this.scored;
    }

    public IUserComponent getUserComponent() {
        return this.userComponent;
    }

    public Color getColor() {
        return this.color;
    }

    public String getRepresentationName() {
        return this.representationName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MovableFraction)) {
            return false;
        }
        MovableFraction movableFraction = (MovableFraction)object;
        if (!movableFraction.canEqual(this)) {
            return false;
        }
        if (this.getId() == null ? movableFraction.getId() != null : !this.getId().equals(movableFraction.getId())) {
            return false;
        }
        if (this.getPosition() == null ? movableFraction.getPosition() != null : !this.getPosition().equals(movableFraction.getPosition())) {
            return false;
        }
        if (this.getNumerator() != movableFraction.getNumerator()) {
            return false;
        }
        if (this.getDenominator() != movableFraction.getDenominator()) {
            return false;
        }
        if (this.isDragging() != movableFraction.isDragging()) {
            return false;
        }
        if (this.getHome() == null ? movableFraction.getHome() != null : !this.getHome().equals(movableFraction.getHome())) {
            return false;
        }
        if (Double.compare(this.getScale(), movableFraction.getScale()) != 0) {
            return false;
        }
        if (this.getNode() == null ? movableFraction.getNode() != null : !this.getNode().equals(movableFraction.getNode())) {
            return false;
        }
        if (this.getMotion() == null ? movableFraction.getMotion() != null : !this.getMotion().equals(movableFraction.getMotion())) {
            return false;
        }
        if (this.isScored() != movableFraction.isScored()) {
            return false;
        }
        if (this.getUserComponent() == null ? movableFraction.getUserComponent() != null : !this.getUserComponent().equals(movableFraction.getUserComponent())) {
            return false;
        }
        if (this.getColor() == null ? movableFraction.getColor() != null : !this.getColor().equals(movableFraction.getColor())) {
            return false;
        }
        return !(this.getRepresentationName() == null ? movableFraction.getRepresentationName() != null : !this.getRepresentationName().equals(movableFraction.getRepresentationName()));
    }

    public boolean canEqual(Object object) {
        return object instanceof MovableFraction;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getScale());
        n = n * 31 + (this.getId() == null ? 0 : this.getId().hashCode());
        n = n * 31 + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        n = n * 31 + this.getNumerator();
        n = n * 31 + this.getDenominator();
        n = n * 31 + (this.isDragging() ? 1231 : 1237);
        n = n * 31 + (this.getHome() == null ? 0 : this.getHome().hashCode());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (this.getNode() == null ? 0 : this.getNode().hashCode());
        n = n * 31 + (this.getMotion() == null ? 0 : this.getMotion().hashCode());
        n = n * 31 + (this.isScored() ? 1231 : 1237);
        n = n * 31 + (this.getUserComponent() == null ? 0 : this.getUserComponent().hashCode());
        n = n * 31 + (this.getColor() == null ? 0 : this.getColor().hashCode());
        n = n * 31 + (this.getRepresentationName() == null ? 0 : this.getRepresentationName().hashCode());
        return n;
    }

    public String toString() {
        return "MovableFraction(id=" + this.getId() + ", position=" + this.getPosition() + ", numerator=" + this.getNumerator() + ", denominator=" + this.getDenominator() + ", dragging=" + this.isDragging() + ", home=" + this.getHome() + ", scale=" + this.getScale() + ", node=" + this.getNode() + ", motion=" + this.getMotion() + ", scored=" + this.isScored() + ", userComponent=" + this.getUserComponent() + ", color=" + this.getColor() + ", representationName=" + this.getRepresentationName() + ")";
    }
}

