/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.fractions.fractionmatcher.model.Mode;
import java.beans.ConstructorProperties;

public class GameInfo {
    public final int level;
    public final boolean audio;
    public final int checks;
    public final Mode mode;
    public final int score;
    public final long time;
    public final long bestTime;
    public final boolean timerVisible;

    public GameInfo withAudio(boolean bl) {
        return new GameInfo(this.level, bl, this.checks, this.mode, this.score, this.time, this.bestTime, this.timerVisible);
    }

    public GameInfo withChecks(int n) {
        return new GameInfo(this.level, this.audio, n, this.mode, this.score, this.time, this.bestTime, this.timerVisible);
    }

    public GameInfo withMode(Mode mode) {
        return new GameInfo(this.level, this.audio, this.checks, mode, this.score, this.time, this.bestTime, this.timerVisible);
    }

    public GameInfo withScore(int n) {
        return new GameInfo(this.level, this.audio, this.checks, this.mode, n, this.time, this.bestTime, this.timerVisible);
    }

    public GameInfo withTime(long l) {
        return new GameInfo(this.level, this.audio, this.checks, this.mode, this.score, l, this.bestTime, this.timerVisible);
    }

    public GameInfo withBestTime(long l) {
        return new GameInfo(this.level, this.audio, this.checks, this.mode, this.score, this.time, l, this.timerVisible);
    }

    public GameInfo withTimerVisible(boolean bl) {
        return new GameInfo(this.level, this.audio, this.checks, this.mode, this.score, this.time, this.bestTime, bl);
    }

    @ConstructorProperties(value={"level", "audio", "checks", "mode", "score", "time", "bestTime", "timerVisible"})
    public GameInfo(int n, boolean bl, int n2, Mode mode, int n3, long l, long l2, boolean bl2) {
        this.level = n;
        this.audio = bl;
        this.checks = n2;
        this.mode = mode;
        this.score = n3;
        this.time = l;
        this.bestTime = l2;
        this.timerVisible = bl2;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isAudio() {
        return this.audio;
    }

    public int getChecks() {
        return this.checks;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getScore() {
        return this.score;
    }

    public long getTime() {
        return this.time;
    }

    public long getBestTime() {
        return this.bestTime;
    }

    public boolean isTimerVisible() {
        return this.timerVisible;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GameInfo)) {
            return false;
        }
        GameInfo gameInfo = (GameInfo)object;
        if (!gameInfo.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != gameInfo.getLevel()) {
            return false;
        }
        if (this.isAudio() != gameInfo.isAudio()) {
            return false;
        }
        if (this.getChecks() != gameInfo.getChecks()) {
            return false;
        }
        if (this.getMode() == null ? gameInfo.getMode() != null : !this.getMode().equals((Object)gameInfo.getMode())) {
            return false;
        }
        if (this.getScore() != gameInfo.getScore()) {
            return false;
        }
        if (this.getTime() != gameInfo.getTime()) {
            return false;
        }
        if (this.getBestTime() != gameInfo.getBestTime()) {
            return false;
        }
        return this.isTimerVisible() == gameInfo.isTimerVisible();
    }

    public boolean canEqual(Object object) {
        return object instanceof GameInfo;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.getLevel();
        n = n * 31 + (this.isAudio() ? 1231 : 1237);
        n = n * 31 + this.getChecks();
        n = n * 31 + (this.getMode() == null ? 0 : this.getMode().hashCode());
        n = n * 31 + this.getScore();
        n = n * 31 + (int)(this.getTime() >>> 32 ^ this.getTime());
        n = n * 31 + (int)(this.getBestTime() >>> 32 ^ this.getBestTime());
        n = n * 31 + (this.isTimerVisible() ? 1231 : 1237);
        return n;
    }

    public String toString() {
        return "GameInfo(level=" + this.getLevel() + ", audio=" + this.isAudio() + ", checks=" + this.getChecks() + ", mode=" + (Object)((Object)this.getMode()) + ", score=" + this.getScore() + ", time=" + this.getTime() + ", bestTime=" + this.getBestTime() + ", timerVisible=" + this.isTimerVisible() + ")";
    }
}

