/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.common.util;

import fj.data.List;
import java.util.HashMap;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Distribution<T> {
    private final HashMap<T, Double> map = new HashMap();
    private static final Random random = new Random();

    public Distribution() {
    }

    public Distribution(List<T> list) {
        for (T t : list) {
            this.map.put(t, 1.0);
        }
    }

    public void put(T t, double d) {
        this.map.put(t, d);
    }

    public T draw() {
        Distribution<T> distribution = this.normalize();
        double d = random.nextDouble();
        double d2 = 0.0;
        for (T t : distribution.map.keySet()) {
            if (!(d <= (d2 += distribution.map.get(t).doubleValue()))) continue;
            return t;
        }
        throw new RuntimeException("No element found, r = " + d);
    }

    public T drawAndRemove() {
        T t = this.draw();
        this.map.remove(t);
        return t;
    }

    Distribution<T> normalize() {
        double d = this.getSum();
        Distribution<T> distribution = new Distribution<T>();
        for (T t : this.map.keySet()) {
            distribution.put(t, this.map.get(t) / d);
        }
        return distribution;
    }

    private double getSum() {
        double d = 0.0;
        for (Double d2 : this.map.values()) {
            d += d2.doubleValue();
        }
        return d;
    }
}

