/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.common.util;

import fj.F;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<T, U>
extends F<T, U> {
    private final F<T, U> f;
    private final boolean debug;
    private final HashMap<T, U> map = new HashMap();
    private final int cacheSize;

    public Cache(F<T, U> f) {
        this(-1, f, false);
    }

    public Cache(int n, F<T, U> f) {
        this(n, f, false);
    }

    private Cache(int n, F<T, U> f, boolean bl) {
        this.cacheSize = n;
        this.f = f;
        this.debug = bl;
    }

    @Override
    public U f(T t) {
        if (this.cacheSize > 0 && this.map.size() > this.cacheSize) {
            this.map.clear();
        }
        if (!this.map.containsKey(t)) {
            if (this.debug) {
                System.out.println("cache miss for key = " + t);
            }
            U u = this.f.f(t);
            this.map.put(t, u);
            return u;
        }
        if (this.debug) {
            System.out.println("cache hit for key = " + t);
        }
        return this.map.get(t);
    }
}

