/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.shapes;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.piccolophet.activities.AnimateToScale;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.SimSharingCanvasBoundedDragHandler;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeType;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerShapeNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PieceNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ShapeSceneNode;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.view.FNode;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PInputEvent;
import fj.Effect;
import fj.F;
import fj.data.List;
import fj.function.Doubles;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SingleContainerNode
extends PNode {
    public final ContainerNode parent;
    private final PNode dottedLineLayer;
    private final ContainerShapeNode shapeLayer;
    public static final F<SingleContainerNode, Fraction> _getFractionValue = new F<SingleContainerNode, Fraction>(){

        @Override
        public Fraction f(SingleContainerNode singleContainerNode) {
            return singleContainerNode.getFractionValue();
        }
    };
    public static final F<SingleContainerNode, Integer> _getNumberPieces = new F<SingleContainerNode, Integer>(){

        @Override
        public Integer f(SingleContainerNode singleContainerNode) {
            return singleContainerNode.getPieces().length();
        }
    };
    public static final Effect<SingleContainerNode> _undoAll = new Effect<SingleContainerNode>(){

        @Override
        public void e(SingleContainerNode singleContainerNode) {
            singleContainerNode.undoAll();
        }
    };

    public SingleContainerNode(final ShapeType shapeType, final ContainerNode containerNode, final ObservableProperty<Integer> observableProperty) {
        this.parent = containerNode;
        this.dottedLineLayer = new PNode(){
            {
                this.setPickable(false);
                this.setChildrenPickable(false);
                observableProperty.addObserver(new VoidFunction1<Integer>(){

                    @Override
                    public void apply(Integer n) {
                        this.removeAllChildren();
                        if (SingleContainerNode.this.dottedLineLayer != null) {
                            SingleContainerNode.this.dottedLineLayer.moveToFront();
                        }
                        BasicStroke basicStroke = new BasicStroke(3.0f, 0, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
                        if (shapeType == ShapeType.BAR) {
                            double d;
                            double d2 = d = 179.01000000000002 / (double)n.intValue();
                            for (int i = 0; i < n - 1; ++i) {
                                this.addChild(new PhetPPath(new Line2D.Double(d2, 0.0, d2, 113.13500000000002), (Stroke)basicStroke, (Paint)Color.lightGray));
                                d2 += d;
                            }
                        } else {
                            double d = Math.PI * 2 / (double)n.intValue();
                            double d3 = 0.0;
                            for (int i = 0; i < n && n >= 2; ++i) {
                                Vector2D vector2D = Vector2D.createPolar(85.0, d3);
                                Vector2D vector2D2 = new Vector2D(85.0, 85.0);
                                this.addChild(new PhetPPath(vector2D2.lineTo(vector2D2.plus(vector2D)), (Stroke)basicStroke, (Paint)Color.lightGray));
                                d3 += d;
                            }
                        }
                    }
                });
            }
        };
        this.shapeLayer = new ContainerShapeNode(observableProperty.get(), shapeType){
            {
                super(n, shapeType3);
                this.addChild(new PhetPPath(shapeType == ShapeType.BAR ? new Rectangle2D.Double(0.0, 0.0, 179.01000000000002, 113.13500000000002) : new Ellipse2D.Double(0.0, 0.0, 170.0, 170.0), Color.white, new BasicStroke(2.0f), Color.black));
                this.addInputEventListener(new SimSharingCanvasBoundedDragHandler(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.container, containerNode.hashCode()), SingleContainerNode.this){

                    protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                        return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)FractionsIntroSimSharing.ParameterKeys.shapeType, shapeType.name()).with((IParameterKey)ParameterKeys.value, SingleContainerNode.this.getFractionValue().toDouble());
                    }

                    public void mousePressed(PInputEvent pInputEvent) {
                        super.mousePressed(pInputEvent);
                        containerNode.moveToFront();
                        AnimateToScale animateToScale = new AnimateToScale(containerNode.parent.getContainerScale(), containerNode, 200L);
                        animateToScale.setDelegate(new PActivityDelegateAdapter(){

                            public void activityFinished(PActivity pActivity) {
                                containerNode.updateExpansionButtonsEnabled();
                            }
                        });
                        this.addActivity(animateToScale);
                        containerNode.context.startDrag(containerNode);
                    }

                    protected void dragNode(DragEvent dragEvent) {
                        containerNode.translate(dragEvent.delta.width, dragEvent.delta.height);
                    }

                    public void mouseReleased(PInputEvent pInputEvent) {
                        super.mouseReleased(pInputEvent);
                        containerNode.context.endDrag(containerNode);
                    }
                });
                this.addInputEventListener(new CursorHandler());
            }
        };
        this.addChild(this.shapeLayer);
        this.addChild(this.dottedLineLayer);
    }

    public boolean isInToolbox() {
        return this.parent.isInToolbox();
    }

    public boolean willOverflow(PieceNode pieceNode) {
        Fraction fraction = this.getFractionValue().plus(pieceNode.toFraction());
        return fraction.numerator > fraction.denominator;
    }

    Fraction getFractionValue() {
        return Fraction.sum(this.getPieces().map(PieceNode._toFraction));
    }

    private List<PieceNode> getPieces() {
        return FNode.getChildren(this, PieceNode.class);
    }

    double getPiecesWidthUnscaled() {
        List<PieceNode> list = this.getPieces();
        return list.length() == 0 ? 0.0 : List.iterableList(list).maximum(FJUtils.ord(new F<PieceNode, Double>(){

            @Override
            public Double f(PieceNode pieceNode) {
                return pieceNode.getFullBounds().getMaxX();
            }
        })).getFullBounds().getMaxX();
    }

    public void addPiece(PieceNode pieceNode) {
        Point2D point2D = pieceNode.getGlobalTranslation();
        this.addChild(pieceNode);
        pieceNode.setGlobalTranslation(point2D);
        this.parent.pieceAdded();
        this.dottedLineLayer.moveToFront();
        pieceNode.setAllPickable(false);
        pieceNode.setInContainer(this);
    }

    void undoAll() {
        for (PieceNode pieceNode : this.getPieces()) {
            this.parent.parent.undoPieceFromContainer(pieceNode);
        }
    }

    public ShapeSceneNode.DropLocation getDropLocation(PieceNode pieceNode, ShapeType shapeType) {
        if (shapeType == ShapeType.BAR) {
            Vector2D vector2D = Vector2D.v(1.0, 1.0);
            return new ShapeSceneNode.DropLocation(Vector2D.v(this.getPiecesWidthUnscaled() * this.parent.parent.getContainerScale(), 0.0).minus(vector2D), 0.0);
        }
        Rectangle2D rectangle2D = this.shapeLayer.getGlobalFullBounds();
        rectangle2D = pieceNode.globalToLocal(rectangle2D);
        rectangle2D = pieceNode.localToParent(rectangle2D);
        List<Double> list = this.getPieces().map(new F<PieceNode, Double>(){

            @Override
            public Double f(PieceNode pieceNode) {
                return Math.PI * 2 / (double)pieceNode.pieceSize.intValue();
            }
        });
        double d = list.foldLeft(Doubles.add, Double.valueOf(0.0));
        return new ShapeSceneNode.DropLocation(new Vector2D(rectangle2D.getX() + 1.0, rectangle2D.getY()), d);
    }

    public void setInCollectionBox() {
        this.dottedLineLayer.setVisible(true);
        this.dottedLineLayer.moveToFront();
    }

    public boolean containsPiece() {
        return this.getFractionValue().numerator > 0;
    }

    public void undoLast() {
        this.parent.parent.undoPieceFromContainer(this.getPieces().sort(FJUtils.ord(new F<PieceNode, Double>(){

            @Override
            public Double f(PieceNode pieceNode) {
                return (double)pieceNode.attachmentTime + 0.0;
            }
        })).last());
    }

    public void addDropLocationToUndoList() {
        this.parent.addDropLocation(this);
    }

    public void moveDottedLineToFront() {
        this.dottedLineLayer.moveToFront();
    }
}

