/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.shapes;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.view.BuildAFractionCanvas;
import edu.colorado.phet.fractions.buildafraction.view.CollectionBoxNode;
import edu.colorado.phet.fractions.buildafraction.view.UndoButton;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ShapeSceneNode;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeCollectionBoxNode
extends CollectionBoxNode {
    private final PhetPPath path;
    private boolean completed;
    private final UndoButton undoButton;
    private ContainerNode containerNode;
    private final ShapeSceneNode sceneNode;
    public final double scaleFactor;

    public ShapeCollectionBoxNode(ShapeSceneNode shapeSceneNode, MixedFraction mixedFraction, final ObservableProperty<Boolean> observableProperty) {
        this.sceneNode = shapeSceneNode;
        if (shapeSceneNode == null) {
            throw new RuntimeException("Null scene");
        }
        double d = Math.ceil(mixedFraction.toDouble());
        this.scaleFactor = shapeSceneNode.isMixedNumbers() ? 0.6 : 1.0;
        double d2 = shapeSceneNode.isMixedNumbers() ? 24.0 : 0.0;
        this.path = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, 120.0 * d * this.scaleFactor + 5.0 * (d - 1.0) / 2.0 * this.scaleFactor - d2, 114.0, 30.0, 30.0), BACKGROUND, STROKE, DISABLED_STROKE_PAINT){
            {
                super(shape, paint, stroke, paint2);
                if (!((Boolean)observableProperty.get()).booleanValue()) {
                    this.setTransparency(0.2f);
                }
                observableProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        if (bl.booleanValue()) {
                            this.setStrokePaint(ENABLED_STROKE_PAINT);
                            if (this.getRoot() == null) {
                                this.setTransparency(1.0f);
                            } else {
                                this.animateToTransparency(1.0f, 500L);
                            }
                        } else {
                            this.setStrokePaint(DISABLED_STROKE_PAINT);
                            if (this.getRoot() == null) {
                                this.setTransparency(0.2f);
                            } else {
                                this.animateToTransparency(0.2f, 500L);
                            }
                        }
                    }
                });
            }
        };
        this.addChild(this.path);
        this.undoButton = new UndoButton(FractionsIntroSimSharing.Components.collectionBoxUndoButton){
            {
                this.scale(0.8);
                this.setOffset(-1.0, -1.0);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ShapeCollectionBoxNode.this.undo();
                    }
                });
            }
        };
        this.undoButton.addInputEventListener(new CursorHandler());
        this.undoButton.setVisible(false);
        this.addChild(this.undoButton);
    }

    public void undo() {
        if (this.completed) {
            this.completed = false;
            this.path.setStroke(BuildAFractionCanvas.CONTROL_PANEL_STROKE);
            this.undoButton.setVisible(false);
            this.undoButton.setPickable(false);
            this.undoButton.setChildrenPickable(false);
            this.sceneNode.addChild(this.containerNode);
            this.containerNode.setScale(1.0);
            this.containerNode.addBackUndoButton();
            this.containerNode.setAllPickable(true);
            this.sceneNode.animateContainerNodeToAppropriateLocation(this.containerNode);
            this.containerNode.setInCollectionBox(false, 0);
            this.containerNode.undoAll();
            this.containerNode.selectedPieceSize.set(0);
            this.containerNode.resetNumberOfContainers();
            this.containerNode = null;
            this.sceneNode.collectionBoxUndone();
            this.sceneNode.syncModelFractions();
        }
    }

    public void setCompletedFraction(ContainerNode containerNode) {
        this.containerNode = containerNode;
        this.completed = true;
        this.undoButton.setVisible(true);
        this.undoButton.setPickable(true);
        this.undoButton.setChildrenPickable(true);
    }

    public boolean isCompleted() {
        return this.completed;
    }
}

