/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.shapes;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.fractions.buildafraction.view.BuildAFractionCanvas;
import edu.colorado.phet.fractions.buildafraction.view.shapes.AnimateToAngle;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerShapeNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PieceNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ShapeSceneNode;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.CircularShapeFunction;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.ShapeNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PInputEvent;
import fj.data.Option;
import java.awt.Shape;

public class PiePieceNode
extends PieceNode {
    private final PhetPPath pieShadow;
    private final PNode pieBackground;
    private final int pieceDenominator;
    private final ShapeSceneNode shapeSceneNode;
    private final PhetPPath shape;

    public PiePieceNode(int n, ShapeSceneNode shapeSceneNode, PhetPPath phetPPath) {
        super(n, shapeSceneNode, phetPPath);
        this.pieceDenominator = n;
        this.shapeSceneNode = shapeSceneNode;
        this.shape = phetPPath;
        this.pieBackground = new PNode(){
            {
                this.addChild(new PhetPPath(ContainerShapeNode.createPieSlice(1), BuildAFractionCanvas.TRANSPARENT));
            }
        };
        this.addChild(new ZeroOffsetNode(this.pieBackground));
        this.pieShadow = new PhetPPath(this.getShadowOffset().createTransformedShape(this.pathNode.getPathReference()), ShapeNode.SHADOW_PAINT);
        this.pieBackground.addChild(this.pathNode);
        this.installInputListeners();
    }

    protected void dragStarted() {
        this.showShadow();
        Option<Double> option = this.context.getNextAngle(this);
        if (option.isSome()) {
            this.animateToAngle(option.some());
        }
    }

    protected void showShadow() {
        this.hideShadow();
        this.pieBackground.addChild(0, this.pieShadow);
    }

    public PieceNode copy() {
        PiePieceNode piePieceNode = new PiePieceNode(this.pieceDenominator, this.shapeSceneNode, PiePieceNode.copy(this.shape));
        piePieceNode.setInitialScale(this.initialScale);
        piePieceNode.setStack(this.stack);
        piePieceNode.setPositionInStack(this.getPositionInStack());
        this.stack.cards = this.stack.cards.snoc(piePieceNode);
        return piePieceNode;
    }

    public static PhetPPath copy(PhetPPath phetPPath) {
        return new PhetPPath(phetPPath.getPathReference(), phetPPath.getPaint(), phetPPath.getStroke(), phetPPath.getStrokePaint());
    }

    protected void rotateTo(double d, final PInputEvent pInputEvent) {
        AnimateToAngle animateToAngle = this.animateToAngle(d);
        animateToAngle.setDelegate(new PActivityDelegateAdapter(){

            public void activityStepped(PActivity pActivity) {
                PiePieceNode.this.stepTowardMouse(pInputEvent);
            }
        });
    }

    protected void dragEnded() {
        this.hideShadow();
    }

    protected void hideShadow() {
        while (this.pieBackground.getChildrenReference().contains(this.pieShadow)) {
            this.pieBackground.removeChild(this.pieShadow);
        }
    }

    AnimateToAngle animateToAngle(double d) {
        AnimateToAngle animateToAngle = new AnimateToAngle(this, 200L, this.reduceWindingNumber(d));
        this.addActivity(animateToAngle);
        return animateToAngle;
    }

    private double reduceWindingNumber(double d) {
        double d2;
        double d3 = this.pieceRotation;
        for (d2 = d - d3; d2 > Math.PI; d2 -= Math.PI * 2) {
        }
        while (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        return d3 + d2;
    }

    public void setPieceRotation(double d) {
        double d2 = Math.PI * 2 / (double)this.pieceSize.intValue();
        Shape shape = new CircularShapeFunction(d2, 85.0).createShape(Vector2D.ZERO, d);
        this.pathNode.setPathTo(shape);
        this.pieShadow.setPathTo(this.getShadowOffset().createTransformedShape(shape));
        this.pieceRotation = d;
    }

    public void animateToTopOfStack() {
        this.animateToAngle(0.0);
        super.animateToTopOfStack();
    }
}

