/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.shapes;

import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Not;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.event.DynamicCursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.fractions.FractionsResources;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeType;
import edu.colorado.phet.fractions.buildafraction.view.DisablePickingWhileAnimating;
import edu.colorado.phet.fractions.buildafraction.view.UndoButton;
import edu.colorado.phet.fractions.buildafraction.view.shapes.CompositeDelegate;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerContext;
import edu.colorado.phet.fractions.buildafraction.view.shapes.IncreaseDecreaseButton;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PieceIconNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ShapeSceneNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.SingleContainerNode;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.view.FNode;
import edu.colorado.phet.fractions.common.view.SpinnerButtonNode;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import fj.Equal;
import fj.F;
import fj.data.List;
import fj.data.Option;
import fj.function.Integers;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerNode
extends PNode {
    private final UndoButton undoButton;
    final IntegerProperty selectedPieceSize = new IntegerProperty(1);
    private final DynamicCursorHandler dynamicCursorHandler;
    public final ShapeSceneNode parent;
    public final ContainerContext context;
    private final ShapeType shapeType;
    private final int maxNumberOfSingleContainers;
    private static final PBounds TEMP_REPAINT_BOUNDS = new PBounds();
    private boolean inTargetCollectionBox = false;
    private final PNode containerLayer;
    public double initialX;
    public double initialY;
    public double initialScale = 1.0;
    private final SpinnerButtonNode leftSpinner;
    private final SpinnerButtonNode rightSpinner;
    private final IncreaseDecreaseButton increaseDecreaseButton;
    private final boolean showIncreaseButton;
    private List<Integer> dropLocationList = List.nil();
    public static final F<ContainerNode, List<SingleContainerNode>> _getSingleContainerNodes = new F<ContainerNode, List<SingleContainerNode>>(){

        @Override
        public List<SingleContainerNode> f(ContainerNode containerNode) {
            return containerNode.getSingleContainerNodes();
        }
    };
    public static final F<ContainerNode, Boolean> _isInTargetCell = new F<ContainerNode, Boolean>(){

        @Override
        public Boolean f(ContainerNode containerNode) {
            return containerNode.isInCollectionBox();
        }
    };
    public static final F<ContainerNode, Fraction> _getFractionValue = new F<ContainerNode, Fraction>(){

        @Override
        public Fraction f(ContainerNode containerNode) {
            return containerNode.getFractionValue();
        }
    };

    public ContainerNode(ShapeSceneNode shapeSceneNode, ContainerContext containerContext, boolean bl, final ShapeType shapeType, int n) {
        this.parent = shapeSceneNode;
        this.context = containerContext;
        this.shapeType = shapeType;
        this.maxNumberOfSingleContainers = n;
        this.undoButton = new UndoButton(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.playAreaUndoButton, this.hashCode()));
        this.addChild(this.undoButton);
        this.undoButton.setVisible(false);
        this.undoButton.setPickable(false);
        this.increaseDecreaseButton = new IncreaseDecreaseButton(new VoidFunction0(){

            public void apply() {
                SimSharingManager.sendButtonPressed(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.increaseContainersButton, ContainerNode.this.hashCode() + ""));
                ContainerNode.this.addContainer();
            }
        }, new VoidFunction0(){

            public void apply() {
                SimSharingManager.sendButtonPressed(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.decreaseContainersButton, ContainerNode.this.hashCode() + ""));
                ContainerNode.this.removeContainer();
            }
        });
        if (shapeType == ShapeType.BAR) {
            this.undoButton.translate(-this.undoButton.getFullBounds().getWidth(), -this.undoButton.getFullBounds().getHeight());
        } else {
            this.undoButton.translate(-this.undoButton.getFullBounds().getWidth() / 2.0, -this.undoButton.getFullBounds().getHeight() / 2.0);
        }
        this.dynamicCursorHandler = new DynamicCursorHandler(12);
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContainerNode.this.undoLast();
            }
        });
        this.undoButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                SimSharingManager.sendButtonPressed(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.playAreaUndoButton, ContainerNode.this.hashCode()));
                ContainerNode.this.dynamicCursorHandler.setCursor(0);
            }
        });
        VoidFunction1<Boolean> voidFunction1 = new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                SimSharingManager.sendButtonPressed(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.incrementDivisionsButton, ContainerNode.this.hashCode() + ""));
                ContainerNode.this.selectedPieceSize.increment();
            }
        };
        VoidFunction1<Boolean> voidFunction12 = new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                SimSharingManager.sendButtonPressed(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.decrementDivisionsButton, ContainerNode.this.hashCode() + ""));
                ContainerNode.this.selectedPieceSize.decrement();
            }
        };
        this.containerLayer = new PNode(){
            {
                this.addChild(new SingleContainerNode(shapeType, ContainerNode.this, ContainerNode.this.selectedPieceSize));
            }
        };
        BooleanProperty booleanProperty = new BooleanProperty(true){
            {
                ContainerNode.this.addPropertyChangeListener("transform", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.set(ContainerNode.this.isInToolbox());
                    }
                });
            }
        };
        this.leftSpinner = new SpinnerButtonNode(ContainerNode.withSpinnerButtonScale(FractionsResources.Images.LEFT_BUTTON_UP_GREEN), ContainerNode.withSpinnerButtonScale(FractionsResources.Images.LEFT_BUTTON_PRESSED_GREEN), ContainerNode.withSpinnerButtonScale(FractionsResources.Images.LEFT_BUTTON_GRAY), voidFunction12, this.selectedPieceSize.greaterThan(1).and(Not.not(booleanProperty)));
        this.rightSpinner = new SpinnerButtonNode(ContainerNode.withSpinnerButtonScale(FractionsResources.Images.RIGHT_BUTTON_UP_GREEN), ContainerNode.withSpinnerButtonScale(FractionsResources.Images.RIGHT_BUTTON_PRESSED_GREEN), ContainerNode.withSpinnerButtonScale(FractionsResources.Images.RIGHT_BUTTON_GRAY), voidFunction1, this.selectedPieceSize.lessThan(8).and(Not.not(booleanProperty)));
        this.addChild(new VBox(this.containerLayer, new HBox(this.leftSpinner, this.rightSpinner)));
        this.showIncreaseButton = bl;
        if (this.showIncreaseButton) {
            this.addChild(this.increaseDecreaseButton);
            this.increaseDecreaseButton.setOffset(this.containerLayer.getFullBounds().getMaxX() + 10.0, this.containerLayer.getFullBounds().getCenterY() - this.increaseDecreaseButton.getFullBounds().getHeight() / 2.0);
        }
    }

    private void undoLast() {
        if (this.getSingleContainerNodes().map(SingleContainerNode._getNumberPieces).foldLeft(Integers.add, Integer.valueOf(0)) == 1) {
            this.undoAll();
            this.dropLocationList = List.nil();
        } else {
            this.dropLocationList = this.dropLocationList.filter(new F<Integer, Boolean>(){

                @Override
                public Boolean f(Integer n) {
                    return ContainerNode.this.containsSite(n);
                }
            });
            if (this.dropLocationList.length() == 0) {
                return;
            }
            Integer n = this.dropLocationList.last();
            this.getSingleContainerNode(n).some().undoLast();
            this.dropLocationList = this.dropLocationList.reverse().tail().reverse();
            this.context.syncModelFractions();
        }
    }

    private boolean containsSite(int n) {
        Option<SingleContainerNode> option = this.getSingleContainerNode(n);
        return option.isSome() && option.some().containsPiece();
    }

    private Option<SingleContainerNode> getSingleContainerNode(int n) {
        return this.getSingleContainerNodes().length() <= n ? Option.none() : Option.some(this.getSingleContainerNodes().index(n));
    }

    List<SingleContainerNode> getSingleContainerNodes() {
        return this.getSingleContainers();
    }

    private void addContainer() {
        final SingleContainerNode singleContainerNode = new SingleContainerNode(this.shapeType, this, this.selectedPieceSize);
        singleContainerNode.setOffset(this.containerLayer.getFullBounds().getMaxX() + 10.0, this.containerLayer.getFullBounds().getY());
        singleContainerNode.setTransparency(0.0f);
        this.containerLayer.addChild(singleContainerNode);
        this.increaseDecreaseButton.animateToPositionScaleRotation(singleContainerNode.getFullBounds().getMaxX() + 10.0, singleContainerNode.getFullBounds().getCenterY() - this.increaseDecreaseButton.getFullBounds().getHeight() / 2.0, 1.0, 0.0, 200L).setDelegate(new DisablePickingWhileAnimating(this.increaseDecreaseButton, true));
        if (this.getSingleContainerNodes().length() >= this.maxNumberOfSingleContainers) {
            this.increaseDecreaseButton.hideIncreaseButton();
        }
        PInterpolatingActivity pInterpolatingActivity = this.increaseDecreaseButton.showDecreaseButton();
        pInterpolatingActivity.setDelegate(new CompositeDelegate(new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                singleContainerNode.animateToTransparency(1.0f, 200L);
                ContainerNode.this.context.containerAdded(ContainerNode.this);
            }
        }, new DisablePickingWhileAnimating(singleContainerNode, true)));
    }

    private void removeContainer() {
        final SingleContainerNode singleContainerNode = this.getSingleContainerNodes().last();
        singleContainerNode.undoAll();
        PInterpolatingActivity pInterpolatingActivity = singleContainerNode.animateToTransparency(0.0f, 200L);
        pInterpolatingActivity.setDelegate(new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                ContainerNode.this.containerLayer.removeChild(singleContainerNode);
                SingleContainerNode singleContainerNode2 = ContainerNode.this.getSingleContainerNodes().last();
                ContainerNode.this.increaseDecreaseButton.animateToPositionScaleRotation(singleContainerNode2.getFullBounds().getMaxX() + 10.0, singleContainerNode2.getFullBounds().getCenterY() - ContainerNode.this.increaseDecreaseButton.getFullBounds().getHeight() / 2.0, 1.0, 0.0, 200L).setDelegate(new CompositeDelegate(new DisablePickingWhileAnimating(ContainerNode.this.increaseDecreaseButton, true), new PActivityDelegateAdapter(){

                    public void activityFinished(PActivity pActivity) {
                        ContainerNode.this.updateExpansionButtonsEnabled();
                    }
                }));
                if (ContainerNode.this.getSingleContainerNodes().length() <= 1) {
                    ContainerNode.this.increaseDecreaseButton.hideDecreaseButton();
                }
            }
        });
        this.increaseDecreaseButton.showIncreaseButton();
    }

    private static BufferedImage withSpinnerButtonScale(BufferedImage bufferedImage) {
        return BufferedImageUtils.multiScaleToWidth(bufferedImage, 50);
    }

    public void undoAll() {
        this.getSingleContainers().foreach(SingleContainerNode._undoAll);
        PInterpolatingActivity pInterpolatingActivity = this.undoButton.animateToTransparency(0.0f, 200L);
        pInterpolatingActivity.setDelegate(new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                ContainerNode.this.undoButton.setVisible(false);
                ContainerNode.this.undoButton.setPickable(false);
                ContainerNode.this.dynamicCursorHandler.setCursor(0);
            }
        });
        this.context.syncModelFractions();
    }

    public void setAllPickable(boolean bl) {
        this.setPickable(bl);
        this.setChildrenPickable(bl);
    }

    public void animateToToolboxStack(Point2D point2D, double d) {
        this.animateToPositionScaleRotation(point2D.getX(), point2D.getY(), d, 0.0, 200L).setDelegate(new CompositeDelegate(new DisablePickingWhileAnimating(this, true), new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                super.activityFinished(pActivity);
                ContainerNode.this.updateExpansionButtonsEnabled();
                ContainerNode.this.context.containerNodeAnimationToToolboxFinished(ContainerNode.this);
            }
        }));
        this.animateToShowSpinners();
    }

    public void animateHome() {
        this.animateToToolboxStack(new Point2D.Double(this.initialX, this.initialY), this.initialScale);
    }

    public void animateToShowSpinners() {
        this.leftSpinner.animateToTransparency(1.0f, 200L);
        this.rightSpinner.animateToTransparency(1.0f, 200L);
    }

    public Fraction getFractionValue() {
        return Fraction.sum(this.getSingleContainers().map(SingleContainerNode._getFractionValue));
    }

    private List<SingleContainerNode> getSingleContainers() {
        return FNode.getChildren(this.containerLayer, SingleContainerNode.class);
    }

    public void removeUndoButton() {
        this.removeChild(this.undoButton);
    }

    public void addBackUndoButton() {
        this.addChild(this.undoButton);
    }

    public Boolean isInCollectionBox() {
        return this.inTargetCollectionBox;
    }

    public void setInCollectionBox(boolean bl, int n) {
        this.inTargetCollectionBox = bl;
        this.leftSpinner.animateToTransparency(bl ? 0.0f : 1.0f, 200L);
        this.rightSpinner.animateToTransparency(bl ? 0.0f : 1.0f, 200L);
        while (this.getChildrenReference().contains(this.increaseDecreaseButton)) {
            this.removeChild(this.increaseDecreaseButton);
        }
        if (!bl && this.showIncreaseButton) {
            this.addChild(this.increaseDecreaseButton);
        }
        for (SingleContainerNode singleContainerNode : this.getSingleContainerNodes()) {
            singleContainerNode.setInCollectionBox();
        }
        if (bl && n > 0) {
            this.selectedPieceSize.set(n);
        }
    }

    public void setInitialState(double d, double d2, double d3) {
        this.initialX = d;
        this.initialY = d2;
        this.initialScale = d3;
        this.setOffset(d, d2);
        this.setScale(d3);
        this.updateExpansionButtonsEnabled();
    }

    public void updateExpansionButtonsEnabled() {
        this.increaseDecreaseButton.setEnabled(!this.isInToolbox());
    }

    public boolean isInToolbox() {
        return Math.abs(this.getScale() - PieceIconNode.toolboxScale(this.parent.fractionLab)) < 1.0E-6;
    }

    public boolean startedInToolbox() {
        return this.context.isFractionLab() ? this.initialY < 600.0 : this.initialY > 500.0;
    }

    public void pieceAdded() {
        if (!this.undoButton.getVisible()) {
            this.undoButton.setVisible(true);
            this.undoButton.setPickable(true);
            this.undoButton.setTransparency(0.0f);
            this.undoButton.animateToTransparency(1.0f, 200L);
            this.dynamicCursorHandler.setCursor(12);
        }
    }

    public void resetNumberOfContainers() {
        if (this.getSingleContainerNodes().length() != 1) {
            if (this.getSingleContainerNodes().length() == 2) {
                this.removeContainer();
            } else {
                while (this.getSingleContainerNodes().length() > 2) {
                    SingleContainerNode singleContainerNode = this.getSingleContainerNodes().last();
                    singleContainerNode.undoAll();
                    singleContainerNode.setTransparency(0.0f);
                    this.containerLayer.removeChild(singleContainerNode);
                    SingleContainerNode singleContainerNode2 = this.getSingleContainerNodes().last();
                    this.increaseDecreaseButton.setOffset(singleContainerNode2.getFullBounds().getMaxX() + 10.0, singleContainerNode2.getFullBounds().getCenterY() - this.increaseDecreaseButton.getFullBounds().getHeight() / 2.0);
                    this.increaseDecreaseButton.setScale(1.0);
                }
                this.removeContainer();
            }
        }
    }

    public Boolean isInPlayArea() {
        return this.isInCollectionBox() == false && !this.isInToolbox();
    }

    public void addDropLocation(SingleContainerNode singleContainerNode) {
        int n = this.getSingleContainerNodes().elementIndex(Equal.anyEqual(), singleContainerNode).some();
        this.dropLocationList = this.dropLocationList.snoc(n);
    }

    public ContainerNode copy() {
        return new ContainerNode(this.parent, this.context, this.showIncreaseButton, this.shapeType, this.maxNumberOfSingleContainers);
    }

    public void moveDottedLinesToFront() {
        for (SingleContainerNode singleContainerNode : this.getSingleContainerNodes()) {
            singleContainerNode.moveDottedLineToFront();
        }
    }

    @Override
    public void repaint() {
        TEMP_REPAINT_BOUNDS.setRect(RectangleUtils.expand(this.getFullBoundsReference(), 2.0, 2.0));
        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
    }
}

