/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.numbers;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.SimSharingCanvasBoundedDragHandler;
import edu.colorado.phet.fractions.buildafraction.view.DisablePickingWhileAnimating;
import edu.colorado.phet.fractions.buildafraction.view.Stackable;
import edu.colorado.phet.fractions.buildafraction.view.UpdateAnimatingFlag;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberDragContext;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.CompositeDelegate;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PInputEvent;
import fj.data.Option;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class NumberCardNode
extends Stackable {
    public final int number;
    private final PhetPPath cardShape;
    public final NumberNode numberNode;
    private final Dimension2DDouble size;
    private final NumberDragContext context;

    public NumberCardNode(final Dimension2DDouble dimension2DDouble, final Integer n, final NumberDragContext numberDragContext) {
        this.number = n;
        this.size = dimension2DDouble;
        this.context = numberDragContext;
        this.cardShape = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, dimension2DDouble.width, dimension2DDouble.height, 10.0, 10.0), Color.white, new BasicStroke(1.0f), Color.black){

            public Rectangle2D getPathBoundsWithStroke() {
                return RectangleUtils.expand(super.getPathBoundsWithStroke(), 1.0, 1.0);
            }
        };
        this.addChild(this.cardShape);
        this.numberNode = new NumberNode(n){
            {
                super(n);
                this.centerFullBoundsOnPoint(dimension2DDouble.width / 2.0, dimension2DDouble.height / 2.0);
            }
        };
        this.addChild(this.numberNode);
        this.addInputEventListener(new SimSharingCanvasBoundedDragHandler(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.numberCard, this.hashCode()), this){

            protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)ParameterKeys.value, n);
            }

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                numberDragContext.startDrag(NumberCardNode.this);
            }

            protected void dragNode(DragEvent dragEvent) {
                NumberCardNode.this.moveToFront();
                NumberCardNode.this.setPositionInStack(Option.<Integer>none());
                NumberCardNode.this.translate(dragEvent.delta.width, dragEvent.delta.height);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                super.mouseReleased(pInputEvent);
                numberDragContext.endDrag(NumberCardNode.this);
            }
        });
        this.addInputEventListener(new CursorHandler());
    }

    public void animateToStackLocation(Vector2D vector2D, final boolean bl) {
        this.animateToPositionScaleRotation(vector2D.x, vector2D.y, 1.0, 0.0, 200L).setDelegate(new CompositeDelegate(new DisablePickingWhileAnimating(this, true), new UpdateAnimatingFlag(this.animating), new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                if (bl) {
                    NumberCardNode.this.delete();
                }
            }
        }));
    }

    protected void delete() {
        super.delete();
        this.removeFromParent();
    }

    public void setCardShapeVisible() {
        this.cardShape.setVisible(true);
    }

    public void addNumberNodeBackIn(NumberNode numberNode) {
        this.addChild(numberNode);
        numberNode.setOffset(this.cardShape.getCenterX() - numberNode.getFullWidth() / 2.0, this.cardShape.getCenterY() - numberNode.getFullHeight() / 2.0);
    }

    public void animateToTopOfStack(boolean bl) {
        this.stack.animateToTopOfStack(this, bl);
    }

    public NumberCardNode copy() {
        NumberCardNode numberCardNode = new NumberCardNode(this.size, this.number, this.context);
        numberCardNode.setStack(this.stack);
        numberCardNode.setPositionInStack(this.getPositionInStack());
        this.stack.cards = this.stack.cards.snoc(numberCardNode);
        return numberCardNode;
    }
}

