/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.numbers;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.common.piccolophet.activities.AnimateToScale;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.SimSharingCanvasBoundedDragHandler;
import edu.colorado.phet.fractions.buildafraction.view.DisablePickingWhileAnimating;
import edu.colorado.phet.fractions.buildafraction.view.UndoButton;
import edu.colorado.phet.fractions.buildafraction.view.numbers.Box;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionCardNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionDraggingContext;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionNodePosition;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberCardNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.CompositeDelegate;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PInputEvent;
import fj.data.List;
import fj.data.Option;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionNode
extends RichPNode {
    public final Box whole = new Box();
    public final Box numerator = new Box();
    public final PhetPPath divisorLine;
    public final Box denominator = new Box();
    public final UndoButton undoButton;
    private final ArrayList<VoidFunction1<Option<Fraction>>> undoListeners = new ArrayList();
    private double toolboxPositionX;
    private double toolboxPositionY;
    private FractionCardNode cardNode;
    private final FractionDraggingContext context;
    public final boolean mixedNumber;
    private final double SCALE_IN_TOOLBOX = 0.7;
    private List<FractionNodePosition> dropListHistory = List.nil();

    public FractionNode(final FractionDraggingContext fractionDraggingContext, boolean bl) {
        super(new PNode[0]);
        this.context = fractionDraggingContext;
        this.mixedNumber = bl;
        this.numerator.box = new Box.ShapeContainer(FractionNode.box());
        this.denominator.box = new Box.ShapeContainer(FractionNode.box());
        this.whole.box = new Box.ShapeContainer(FractionNode.box(2.4));
        this.setScale(0.7);
        this.divisorLine = new PhetPPath(new Line2D.Double(0.0, 0.0, 50.0, 0.0), (Stroke)new BasicStroke(4.0f, 1, 0), (Paint)Color.black);
        this.undoButton = new UndoButton(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.playAreaUndoButton, this.hashCode()));
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FractionNode.this.undo();
            }
        });
        VBox vBox = new VBox(this.numerator.box, this.divisorLine, this.denominator.box);
        edu.colorado.phet.common.piccolophet.nodes.layout.Box box = bl ? new HBox(this.whole.box, vBox) : vBox;
        Color color = new Color(0, 0, 0, 0);
        RichPNode richPNode = new RichPNode(new PhetPPath((Shape)RectangleUtils.expand(box.getFullBounds(), 5.0, 5.0), color), box);
        this.addChild(richPNode);
        Rectangle2D rectangle2D = this.divisorLine.getFullBounds();
        rectangle2D = box.localToParent(rectangle2D);
        this.undoButton.setOffset(rectangle2D.getMinX() - 2.0 - this.undoButton.getFullBounds().getWidth(), rectangle2D.getCenterY() - this.undoButton.getFullBounds().getHeight() / 2.0);
        this.undoButton.addInputEventListener(new CursorHandler());
        this.undoButton.setVisible(false);
        this.addChild(this.undoButton);
        richPNode.addInputEventListener(new CursorHandler());
        richPNode.addInputEventListener(new SimSharingCanvasBoundedDragHandler(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.fraction, this.hashCode()), this){

            protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                String string = FractionNode.this.numerator.numberNode != null ? FractionNode.this.numerator.numberNode.number + "" : "empty";
                String string2 = FractionNode.this.denominator.numberNode != null ? FractionNode.this.denominator.numberNode.number + "" : "empty";
                return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)FractionsIntroSimSharing.ParameterKeys.numerator, string).with((IParameterKey)FractionsIntroSimSharing.ParameterKeys.denominator, string2);
            }

            public void mousePressed(PInputEvent pInputEvent) {
                super.mousePressed(pInputEvent);
                FractionNode.this.addActivity(new AnimateToScale(1.0, FractionNode.this, 200L));
                fractionDraggingContext.startDrag(FractionNode.this);
            }

            protected void dragNode(DragEvent dragEvent) {
                FractionNode.this.moveToFront();
                FractionNode.this.translate(dragEvent.delta.width, dragEvent.delta.height);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                super.mouseReleased(pInputEvent);
                fractionDraggingContext.endDrag(FractionNode.this);
            }
        });
        if (bl) {
            ObservableProperty<Option<Integer>> observableProperty = fractionDraggingContext.getDraggedCardProperty();
            observableProperty.addObserver(new VoidFunction1<Option<Integer>>(){

                @Override
                public void apply(Option<Integer> option) {
                    FractionNode.this.numerator.setEnabled(true);
                    FractionNode.this.denominator.setEnabled(true);
                    boolean bl = fractionDraggingContext.isInCollectionBox(FractionNode.this);
                    if (option.isSome() && !bl && !FractionNode.this.isComplete()) {
                        Integer n = option.some();
                        if (FractionNode.this.numerator.numberNode != null && n <= FractionNode.this.numerator.numberNode.number) {
                            FractionNode.this.denominator.setEnabled(false);
                        }
                        if (FractionNode.this.denominator.numberNode != null && n >= FractionNode.this.denominator.numberNode.number) {
                            FractionNode.this.numerator.setEnabled(false);
                        }
                    }
                }
            });
        }
    }

    void undo() {
        Point2D point2D;
        this.setDragRegionPickable(true);
        Option option = this.isComplete() ? Option.some(this.getValue()) : Option.none();
        Point2D point2D2 = this.numerator.cardNode != null ? this.numerator.cardNode.getGlobalTranslation() : null;
        Point2D point2D3 = this.denominator.cardNode != null ? this.denominator.cardNode.getGlobalTranslation() : null;
        Point2D point2D4 = point2D = this.whole.cardNode != null ? this.whole.cardNode.getGlobalTranslation() : null;
        if (this.cardNode != null) {
            this.cardNode.undo();
            this.cardNode = null;
        }
        if (this.dropListHistory.length() > 0) {
            Object object = this.dropListHistory.last();
            if (object == FractionNodePosition.WHOLE) {
                this.undo(this.whole, point2D);
            } else if (object == FractionNodePosition.NUMERATOR) {
                this.undo(this.numerator, point2D2);
            } else if (object == FractionNodePosition.DENOMINATOR) {
                this.undo(this.denominator, point2D3);
            }
            this.dropListHistory = this.dropListHistory.reverse().drop(1).reverse();
        }
        this.undoButton.setVisible(this.numerator.cardNode != null || this.denominator.cardNode != null || this.whole.cardNode != null);
        for (VoidFunction1 voidFunction1 : this.undoListeners) {
            voidFunction1.apply(option);
        }
        this.context.updateStacks();
    }

    public void undoAll() {
        while (this.undoButton.getVisible()) {
            this.undo();
        }
    }

    private void undo(Box box, Point2D point2D) {
        if (box.cardNode != null) {
            box.cardNode.numberNode.setScale(1.0);
            box.cardNode.numberNode.setBoldFont(true);
            box.cardNode.setCardShapeVisible();
            box.cardNode.setAllPickable(true);
            box.box.shape.setVisible(true);
            box.parent.addChild(box.cardNode);
            box.cardNode.addNumberNodeBackIn(box.numberNode);
            box.cardNode.setGlobalTranslation(point2D);
            box.cardNode.setVisible(true);
            box.cardNode.setPickable(true);
            box.cardNode.setChildrenPickable(true);
            box.cardNode.animateToTopOfStack(this.context.isFractionLab());
            box.cardNode = null;
            box.numberNode = null;
            box.setEnabled(true);
        }
    }

    private static PhetPPath box() {
        return FractionNode.box(1.0);
    }

    private static PhetPPath box(double d) {
        return new PhetPPath(new Rectangle2D.Double(0.0, 0.0, 40.0 * d, 50.0 * d), (Stroke)new BasicStroke(2.0f, 2, 0, 1.0f, new float[]{10.0f, 6.0f}, 0.0f), (Paint)Color.red);
    }

    public void attachNumber(PhetPPath phetPPath, NumberCardNode numberCardNode) {
        if (phetPPath == this.numerator.box.shape) {
            this.attachToBox(numberCardNode, this.numerator, FractionNodePosition.NUMERATOR);
        } else if (phetPPath == this.denominator.box.shape) {
            this.attachToBox(numberCardNode, this.denominator, FractionNodePosition.DENOMINATOR);
        } else if (phetPPath == this.whole.box.shape) {
            this.attachToBox(numberCardNode, this.whole, FractionNodePosition.WHOLE);
        } else {
            throw new RuntimeException("No such box!");
        }
        NumberNode numberNode = numberCardNode.numberNode;
        Point2D point2D = numberNode.getGlobalTranslation();
        this.addChild(numberNode);
        Point2D point2D2 = numberCardNode.getGlobalTranslation();
        this.addChild(numberCardNode);
        numberCardNode.setGlobalTranslation(point2D2);
        numberCardNode.setVisible(false);
        numberCardNode.setPickable(false);
        numberCardNode.setChildrenPickable(false);
        numberNode.setGlobalTranslation(point2D);
        numberNode.setPickable(false);
        numberNode.setChildrenPickable(false);
        if (phetPPath == this.whole.box.shape) {
            numberNode.setScale(2.4);
            numberNode.translate(-3.0, -numberNode.getFullHeight() / 8.0);
            numberNode.setBoldFont(false);
        }
    }

    private void attachToBox(NumberCardNode numberCardNode, Box box, FractionNodePosition fractionNodePosition) {
        box.cardNode = numberCardNode;
        box.numberNode = numberCardNode.numberNode;
        box.parent = numberCardNode.getParent();
        this.dropListHistory = this.dropListHistory.snoc(fractionNodePosition);
    }

    public boolean isComplete() {
        return this.mixedNumber ? this.numerator.cardNode != null && this.denominator.cardNode != null && this.whole.cardNode != null : this.numerator.cardNode != null && this.denominator.cardNode != null;
    }

    public Fraction getValue() {
        return this.mixedNumber ? this.getFractionPart().plus(Fraction.fraction(this.whole.cardNode.number, 1)) : this.getFractionPart();
    }

    private Fraction getFractionPart() {
        return new Fraction(this.numerator.cardNode.number, this.denominator.cardNode.number);
    }

    public NumberNode getTopNumberNode() {
        return this.numerator.numberNode;
    }

    public NumberNode getBottomNumberNode() {
        return this.denominator.numberNode;
    }

    public NumberNode getWholeNumberNode() {
        return this.whole.numberNode;
    }

    public void setDragRegionPickable(boolean bl) {
        for (Object e : this.getChildrenReference()) {
            PNode pNode = (PNode)e;
            if (pNode == this.undoButton) continue;
            pNode.setPickable(bl);
            pNode.setChildrenPickable(bl);
        }
        this.setChildrenPickable(true);
        this.setPickable(true);
    }

    public void addUndoListener(VoidFunction1<Option<Fraction>> voidFunction1) {
        this.undoListeners.add(voidFunction1);
    }

    public boolean isInToolboxPosition() {
        return this.getXOffset() == this.toolboxPositionX && this.getYOffset() == this.toolboxPositionY;
    }

    public void setToolboxPosition(double d, double d2) {
        this.toolboxPositionX = d;
        this.toolboxPositionY = d2;
    }

    public void setCardNode(FractionCardNode fractionCardNode) {
        this.cardNode = fractionCardNode;
    }

    public void animateToToolbox() {
        this.animateToPositionScaleRotation(this.toolboxPositionX, this.toolboxPositionY, 0.7, 0.0, 1000L).setDelegate(new DisablePickingWhileAnimating(this, true));
    }

    public void animateToCenterOfScreen() {
        double d = this.context.getCenterOfScreen().x;
        double d2 = this.context.getCenterOfScreen().y;
        this.animateToPositionScaleRotation(d, d2, 1.0, 0.0, 200L).setDelegate(new CompositeDelegate(new DisablePickingWhileAnimating(this, true), new PActivityDelegateAdapter(){

            public void activityStarted(PActivity pActivity) {
            }

            public void activityFinished(PActivity pActivity) {
            }
        }));
    }

    public void animateNearCenterOfScreen() {
        double d = this.context.getCenterOfScreen().x + (Math.random() * 2.0 - 1.0) * 75.0;
        double d2 = this.context.getCenterOfScreen().y + (Math.random() * 2.0 - 1.0) * 75.0;
        this.animateToPositionScaleRotation(d, d2, 1.0, 0.0, 200L).setDelegate(new DisablePickingWhileAnimating(this, true));
    }

    public boolean isEmpty() {
        return this.mixedNumber ? this.numerator.cardNode == null && this.denominator.cardNode == null && this.whole.cardNode == null : this.numerator.cardNode == null && this.denominator.cardNode == null;
    }

    public void reset() {
        this.undoAll();
    }
}

