/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.numbers;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.SimSharingCanvasBoundedDragHandler;
import edu.colorado.phet.fractions.buildafraction.view.DisablePickingWhileAnimating;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberCollectionBoxNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberSceneCollectionBoxPair;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberSceneNode;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import fj.Equal;
import fj.F;
import fj.data.List;
import fj.data.Option;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FractionCardNode
extends RichPNode {
    public final FractionNode fractionNode;
    private final PNode fractionNodeParent;

    public FractionCardNode(final FractionNode fractionNode, final List<NumberSceneCollectionBoxPair> list, final NumberSceneNode numberSceneNode) {
        super(new PNode[0]);
        this.fractionNode = fractionNode;
        this.fractionNode.setCardNode(this);
        this.fractionNodeParent = fractionNode.getParent();
        this.addChild(fractionNode);
        PBounds pBounds = fractionNode.getTopNumberNode().getGlobalFullBounds();
        PBounds pBounds2 = fractionNode.getBottomNumberNode().getGlobalFullBounds();
        PBounds pBounds3 = fractionNode.divisorLine.getGlobalFullBounds();
        Rectangle2D rectangle2D = pBounds.createUnion(pBounds2).createUnion(pBounds3);
        Rectangle2D rectangle2D2 = fractionNode.mixedNumber ? this.createMixedNumberBorderShape(fractionNode, rectangle2D) : rectangle2D;
        rectangle2D2 = this.globalToLocal(rectangle2D2);
        rectangle2D2 = RectangleUtils.expand(rectangle2D2, 10.0, 2.0);
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight(), 10.0, 10.0);
        final PhetPPath phetPPath = new PhetPPath(double_, Color.white, new BasicStroke(1.0f), Color.black){

            public Rectangle2D getPathBoundsWithStroke() {
                return RectangleUtils.expand(super.getPathBoundsWithStroke(), 1.0, 1.0);
            }
        };
        phetPPath.addInputEventListener(new CursorHandler());
        phetPPath.addInputEventListener(new SimSharingCanvasBoundedDragHandler(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.fractionCard, this.hashCode()), this){

            protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)FractionsIntroSimSharing.ParameterKeys.numerator, fractionNode.getTopNumberNode().number).with((IParameterKey)FractionsIntroSimSharing.ParameterKeys.denominator, fractionNode.getBottomNumberNode().number);
            }

            protected void dragNode(DragEvent dragEvent) {
                FractionCardNode.this.moveToFront();
                FractionCardNode.this.translate(dragEvent.delta.width, dragEvent.delta.height);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                super.mouseReleased(pInputEvent);
                List<NumberCollectionBoxNode> list3 = list.map(new F<NumberSceneCollectionBoxPair, NumberCollectionBoxNode>(){

                    @Override
                    public NumberCollectionBoxNode f(NumberSceneCollectionBoxPair numberSceneCollectionBoxPair) {
                        return numberSceneCollectionBoxPair.collectionBoxNode;
                    }
                });
                boolean bl = false;
                List<NumberCollectionBoxNode> list2 = list3.sort(FJUtils.ord(new F<NumberCollectionBoxNode, Double>(){

                    @Override
                    public Double f(NumberCollectionBoxNode numberCollectionBoxNode) {
                        return numberCollectionBoxNode.getGlobalFullBounds().getCenter2D().distance(FractionCardNode.this.getGlobalFullBounds().getCenter2D());
                    }
                }));
                for (NumberCollectionBoxNode object : list2.take(1)) {
                    if (!phetPPath.getGlobalFullBounds().intersects(object.getGlobalFullBounds()) || !object.mixedFraction.approxEquals(fractionNode.getValue()) || object.isCompleted()) continue;
                    Point2D point2D = object.getFullBounds().getCenter2D();
                    double d = fractionNode.mixedNumber ? 0.65 : 0.75;
                    Point2D point2D2 = fractionNode.getGlobalTranslation();
                    numberSceneNode.addChild(fractionNode);
                    fractionNode.setGlobalTranslation(point2D2);
                    Vector2D vector2D = fractionNode.mixedNumber ? Vector2D.v(7.0, 30.0) : Vector2D.v(25.0, 10.0);
                    fractionNode.animateToPositionScaleRotation(point2D.getX() - fractionNode.getFullBounds().getWidth() / 2.0 * d + vector2D.x, point2D.getY() - fractionNode.getFullBounds().getHeight() / 2.0 * d + vector2D.y, d, 0.0, 200L).setDelegate(new DisablePickingWhileAnimating(fractionNode, false));
                    fractionNode.undoButton.setVisible(false);
                    fractionNode.setDragRegionPickable(false);
                    FractionCardNode.this.removeFromParent();
                    object.setCompletedFraction(fractionNode);
                    bl = true;
                    numberSceneNode.fractionCardNodeDroppedInCollectionBox();
                    break;
                }
                if (!bl) {
                    boolean bl2 = false;
                    for (NumberCollectionBoxNode numberCollectionBoxNode : list3) {
                        if (!phetPPath.getGlobalFullBounds().intersects(numberCollectionBoxNode.getGlobalFullBounds()) && !(phetPPath.getGlobalBounds().getMaxX() > numberSceneNode.minimumCollectionBoxX())) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        FractionCardNode.this.animateToPositionScaleRotation(0.0, 0.0, 1.0, 0.0, 200L).setDelegate(new DisablePickingWhileAnimating(FractionCardNode.this, true));
                    }
                }
            }
        });
        fractionNode.setDragRegionPickable(false);
        fractionNode.addUndoListener(new VoidFunction1<Option<Fraction>>(){

            @Override
            public void apply(Option<Fraction> option) {
                FractionCardNode.this.removeChild(phetPPath);
                if (option.isSome()) {
                    numberSceneNode.level.createdFractions.set(((List)numberSceneNode.level.createdFractions.get()).delete(option.some(), Equal.anyEqual()));
                }
            }
        });
        this.addChild(phetPPath);
        fractionNode.moveToFront();
    }

    private Rectangle2D createMixedNumberBorderShape(FractionNode fractionNode, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = rectangle2D.createUnion(fractionNode.getWholeNumberNode().getGlobalFullBounds());
        double d = 0.1;
        double d2 = d * rectangle2D2.getHeight();
        return new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY() + d2, rectangle2D2.getWidth(), rectangle2D2.getHeight() - d2 * 2.0);
    }

    public void undo() {
        Point2D point2D = this.fractionNode.getGlobalTranslation();
        point2D = this.fractionNodeParent.globalToLocal(point2D);
        this.fractionNode.removeFromParent();
        this.fractionNodeParent.addChild(this.fractionNode);
        this.fractionNode.setOffset(point2D);
    }

    public boolean isMixedNumber() {
        return this.fractionNode.mixedNumber;
    }
}

