/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.fractions.buildafraction.view.Stack;
import edu.umd.cs.piccolo.PNode;
import fj.F;
import fj.data.Option;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stackable<T extends Stackable>
extends PNode {
    private Option<Integer> positionInStack = Option.none();
    protected Stack<T> stack;
    public final BooleanProperty animating = new BooleanProperty(false);

    public void setAllPickable(boolean bl) {
        if (!bl || !((Boolean)this.animating.get()).booleanValue()) {
            this.setPickable(bl);
            this.setChildrenPickable(bl);
        }
    }

    public Option<Integer> getPositionInStack() {
        return this.positionInStack;
    }

    public void setPositionInStack(Option<Integer> option) {
        this.positionInStack = option;
    }

    public abstract void animateToStackLocation(Vector2D var1, boolean var2);

    public boolean isInStack() {
        return this.positionInStack.isSome();
    }

    public boolean isAtStackIndex(Integer n) {
        return this.positionInStack.isSome() && this.positionInStack.some().equals(n);
    }

    public void setStack(final Stack<T> stack) {
        assert (this.stack == null);
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                stack.cardMoved();
            }
        });
        this.stack = stack;
    }

    protected void delete() {
        this.stack.cards = this.stack.cards.filter(new F<T, Boolean>(){

            @Override
            public Boolean f(T t) {
                return t != Stackable.this;
            }
        });
        this.stack.update();
    }
}

