/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.fractions.buildafraction.view.StackContext;
import edu.colorado.phet.fractions.buildafraction.view.Stackable;
import edu.umd.cs.piccolo.PNode;
import fj.F;
import fj.data.List;
import fj.data.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack<T extends Stackable> {
    public List<T> cards;
    private final Integer stackIndex;
    private final StackContext<T> context;
    private final List<T> originalCards;
    private final F<Option<Integer>, List<Integer>> optionToList = FJUtils.optionToList();

    public Stack(List<T> list, Integer n, StackContext<T> stackContext) {
        this.cards = list;
        this.originalCards = list;
        this.stackIndex = n;
        this.context = stackContext;
        this.updatePickable();
    }

    private void updatePickable() {
        for (Stackable stackable : this.cards) {
            stackable.setAllPickable(false);
        }
        Option<T> option = this.getFrontCardInStack();
        if (option.isSome()) {
            ((Stackable)option.some()).setAllPickable(true);
            ((Stackable)option.some()).moveToFront();
        }
        this.moveNonStackCardsToFront();
    }

    private void moveNonStackCardsToFront() {
        for (Stackable stackable : this.cards) {
            if (!stackable.getPositionInStack().isNone()) continue;
            stackable.moveToFront();
        }
        this.context.movedNonStackCardsToFront();
    }

    private Option<T> getFrontCardInStack() {
        List<T> list = this.cards.sort(FJUtils.ord(new F<T, Double>(){

            @Override
            public Double f(T t) {
                Option<Integer> option = ((Stackable)t).getPositionInStack();
                return option.orSome(-1).doubleValue();
            }
        }));
        return list.isEmpty() ? Option.none() : Option.some(list.last());
    }

    public void update() {
        for (Stackable stackable : this.cards) {
            stackable.moveToFront();
        }
        this.moveNonStackCardsToFront();
        this.updatePickable();
    }

    public Vector2D getLocation(int n, T t) {
        return this.context.getLocation(this.stackIndex, n, t);
    }

    public void animateToTopOfStack(T t, boolean bl) {
        List<Integer> list = List.range(0, this.cards.length());
        for (Integer n : list) {
            if (this.hasCardAtSite(n)) continue;
            ((Stackable)t).setPositionInStack(Option.some(n));
            ((Stackable)t).animateToStackLocation(this.getLocation(n, t), bl);
            ((PNode)t).moveToFront();
            break;
        }
        this.moveNonStackCardsToFront();
    }

    private boolean hasCardAtSite(Integer n) {
        for (Stackable stackable : this.cards) {
            if (!stackable.isAtStackIndex(n)) continue;
            return true;
        }
        return false;
    }

    public void cardMoved() {
        this.updatePickable();
    }

    public List<T> getCards() {
        return this.cards;
    }

    public Integer getStackIndex() {
        return this.stackIndex;
    }

    public StackContext<T> getContext() {
        return this.context;
    }

    public List<T> getOriginalCards() {
        return this.originalCards;
    }

    public F<Option<Integer>, List<Integer>> getOptionToList() {
        return this.optionToList;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Stack)) {
            return false;
        }
        Stack stack = (Stack)object;
        if (!stack.canEqual(this)) {
            return false;
        }
        if (this.getCards() == null ? stack.getCards() != null : !this.getCards().equals(stack.getCards())) {
            return false;
        }
        if (this.getStackIndex() == null ? stack.getStackIndex() != null : !this.getStackIndex().equals(stack.getStackIndex())) {
            return false;
        }
        if (this.getContext() == null ? stack.getContext() != null : !this.getContext().equals(stack.getContext())) {
            return false;
        }
        if (this.getOriginalCards() == null ? stack.getOriginalCards() != null : !this.getOriginalCards().equals(stack.getOriginalCards())) {
            return false;
        }
        return !(this.getOptionToList() == null ? stack.getOptionToList() != null : !this.getOptionToList().equals(stack.getOptionToList()));
    }

    public boolean canEqual(Object object) {
        return object instanceof Stack;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + (this.getCards() == null ? 0 : this.getCards().hashCode());
        n = n * 31 + (this.getStackIndex() == null ? 0 : this.getStackIndex().hashCode());
        n = n * 31 + (this.getContext() == null ? 0 : this.getContext().hashCode());
        n = n * 31 + (this.getOriginalCards() == null ? 0 : this.getOriginalCards().hashCode());
        n = n * 31 + (this.getOptionToList() == null ? 0 : this.getOptionToList().hashCode());
        return n;
    }

    public String toString() {
        return "Stack(cards=" + this.getCards() + ", stackIndex=" + this.getStackIndex() + ", context=" + this.getContext() + ", originalCards=" + this.getOriginalCards() + ", optionToList=" + this.getOptionToList() + ")";
    }
}

