/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view;

import edu.colorado.phet.common.games.GameConstants;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import edu.colorado.phet.common.piccolophet.nodes.controlpanel.SettingsOnOffPanel;
import edu.colorado.phet.fractions.FractionsResources;
import edu.colorado.phet.fractions.buildafraction.view.AbstractLevelSelectionNode;
import edu.colorado.phet.fractions.buildafraction.view.BuildAFractionCanvas;
import edu.colorado.phet.fractions.buildafraction.view.LevelIdentifier;
import edu.colorado.phet.fractions.buildafraction.view.LevelInfo;
import edu.colorado.phet.fractions.buildafraction.view.LevelProgress;
import edu.colorado.phet.fractions.buildafraction.view.LevelType;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberCardNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberDragContext;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.common.view.Colors;
import edu.colorado.phet.fractions.fractionmatcher.model.Pattern;
import edu.colorado.phet.fractions.fractionmatcher.view.FilledPattern;
import edu.colorado.phet.fractions.fractionmatcher.view.PatternNode;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import fj.F;
import fj.data.List;
import java.awt.Color;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelSelectionNode
extends AbstractLevelSelectionNode {
    public static final Color[] colors = new Color[]{Colors.LIGHT_RED, Colors.LIGHT_BLUE, Colors.LIGHT_GREEN, Colors.LIGHT_ORANGE, Color.magenta, Color.yellow, Color.CYAN, new Color(146, 54, 173), new Color(255, 112, 213), new Color(45, 165, 59)};

    public LevelSelectionNode(String string, BuildAFractionCanvas buildAFractionCanvas, BooleanProperty booleanProperty, IntegerProperty integerProperty, F<LevelIdentifier, LevelProgress> f) {
        super(string, List.list(new AbstractLevelSelectionNode.Page(LevelSelectionNode.page1(f)), new AbstractLevelSelectionNode.Page(LevelSelectionNode.page2(f))), buildAFractionCanvas, integerProperty);
        this.addChild(new SettingsOnOffPanel(List.list(new SettingsOnOffPanel.Feature(new PImage(GameConstants.SOUND_OFF_ICON), new PImage(GameConstants.SOUND_ICON), booleanProperty, FractionsIntroSimSharing.Components.soundRadioButton))){
            {
                this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.width - this.getFullBounds().getWidth() - 10.0, LevelSelectionNode.this.resetAllButton.getFullBounds().getMinY() - this.getFullBounds().getHeight() - 10.0);
            }
        });
    }

    private static List<List<LevelInfo>> page1(F<LevelIdentifier, LevelProgress> f) {
        return List.list(List.list(LevelSelectionNode.shapeLevel(1, Pattern.pie(1), f), LevelSelectionNode.shapeLevel(2, Pattern.verticalBars(2), f), LevelSelectionNode.shapeLevel(3, f), LevelSelectionNode.shapeLevel(4, f), LevelSelectionNode.shapeLevel(5, f)), List.list(LevelSelectionNode.numberLevel(1, f), LevelSelectionNode.numberLevel(2, f), LevelSelectionNode.numberLevel(3, f), LevelSelectionNode.numberLevel(4, f), LevelSelectionNode.numberLevel(5, f)));
    }

    private static List<List<LevelInfo>> page2(F<LevelIdentifier, LevelProgress> f) {
        return List.list(List.list(LevelSelectionNode.shapeLevel(6, f), LevelSelectionNode.shapeLevel(7, f), LevelSelectionNode.shapeLevel(8, f), LevelSelectionNode.shapeLevel(9, f), LevelSelectionNode.shapeLevel(10, f)), List.list(LevelSelectionNode.numberLevel(6, f), LevelSelectionNode.numberLevel(7, f), LevelSelectionNode.numberLevel(8, f), LevelSelectionNode.numberLevel(9, f), LevelSelectionNode.numberLevel(10, f)));
    }

    private static Pattern getIconPattern(int n) {
        return n <= 5 ? Pattern.polygon(80.0, n) : (n == 6 ? Pattern.sixFlower() : (n == 7 ? Pattern.ringOfHexagons() : (n == 8 ? Pattern.ninjaStar() : (n == 9 ? Pattern.grid(3) : (n == 10 ? Pattern.letterLShapedDiagonal(10, 5) : null)))));
    }

    private static LevelInfo shapeLevel(int n, F<LevelIdentifier, LevelProgress> f) {
        return LevelSelectionNode.shapeLevel(n, LevelSelectionNode.getIconPattern(n), f);
    }

    private static LevelInfo shapeLevel(int n, Pattern pattern, F<LevelIdentifier, LevelProgress> f) {
        return new LevelInfo(new LevelIdentifier(n - 1, LevelType.SHAPES), MessageFormat.format(FractionsResources.Strings.LEVEL__PATTERN, n), new PatternNode(FilledPattern.sequentialFill(pattern, n), colors[(n - 1) % colors.length]), f.f(new LevelIdentifier(n - 1, LevelType.SHAPES)));
    }

    private static LevelInfo numberLevel(int n, F<LevelIdentifier, LevelProgress> f) {
        return new LevelInfo(new LevelIdentifier(n - 1, LevelType.NUMBERS), MessageFormat.format(FractionsResources.Strings.LEVEL__PATTERN, n), LevelSelectionNode.createNumberLevelIcon(n), f.f(new LevelIdentifier(n - 1, LevelType.NUMBERS)));
    }

    private static PNode createNumberLevelIcon(final int n) {
        return new PNode(){
            {
                for (int i = 0; i < n; ++i) {
                    NumberCardNode numberCardNode = new NumberCardNode(new Dimension2DDouble(n < 10 ? 60.0 : 80.0, 75.0), n, new NumberDragContext(){

                        public void endDrag(NumberCardNode numberCardNode) {
                        }

                        public void startDrag(NumberCardNode numberCardNode) {
                        }
                    });
                    this.addChild(numberCardNode);
                    numberCardNode.setOffset(i * 4, i * 4);
                }
            }
        };
    }
}

