/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model.numbers;

import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevelList;
import edu.colorado.phet.fractions.common.math.Fraction;
import fj.data.List;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepresentationType {
    public final List<Integer> denominators;
    private static final RepresentationType pies = new RepresentationType((List)NumberLevelList.rangeInclusive(1, 9)){

        public NumberLevelList.PatternMaker toPattern(Fraction fraction) {
            return NumberLevelList.pie;
        }
    };
    private static final RepresentationType horizontalBars = new RepresentationType((List)NumberLevelList.rangeInclusive(1, 9)){

        public NumberLevelList.PatternMaker toPattern(Fraction fraction) {
            return NumberLevelList.horizontalBar;
        }
    };
    private static final RepresentationType verticalBars = new RepresentationType((List)NumberLevelList.rangeInclusive(1, 9)){

        public NumberLevelList.PatternMaker toPattern(Fraction fraction) {
            return NumberLevelList.verticalBar;
        }
    };
    private static final RepresentationType grid = new RepresentationType((List)List.list(1, 4, 9)){

        public NumberLevelList.PatternMaker toPattern(Fraction fraction) {
            return fraction.denominator == 1 ? NumberLevelList.grid1 : (fraction.denominator == 4 ? NumberLevelList.grid4 : NumberLevelList.grid9);
        }
    };
    private static final RepresentationType pyramid = new RepresentationType((List)List.list(1, 4, 9)){

        public NumberLevelList.PatternMaker toPattern(Fraction fraction) {
            return fraction.denominator == 1 ? NumberLevelList.pyramid1 : (fraction.denominator == 4 ? NumberLevelList.pyramid4 : NumberLevelList.pyramid9);
        }
    };
    private static final RepresentationType flower = new RepresentationType((List)List.list(6)){

        public NumberLevelList.PatternMaker toPattern(Fraction fraction) {
            return NumberLevelList.flower;
        }
    };
    private static final RepresentationType polygon = new RepresentationType((List)NumberLevelList.rangeInclusive(3, 9)){

        public NumberLevelList.PatternMaker toPattern(Fraction fraction) {
            return NumberLevelList.polygon;
        }
    };
    public static final List<RepresentationType> all = List.list(pies, horizontalBars, verticalBars, grid, pyramid, flower, polygon);

    public abstract NumberLevelList.PatternMaker toPattern(Fraction var1);

    @ConstructorProperties(value={"denominators"})
    public RepresentationType(List<Integer> list) {
        this.denominators = list;
    }

    public List<Integer> getDenominators() {
        return this.denominators;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RepresentationType)) {
            return false;
        }
        RepresentationType representationType = (RepresentationType)object;
        if (!representationType.canEqual(this)) {
            return false;
        }
        return !(this.getDenominators() == null ? representationType.getDenominators() != null : !this.getDenominators().equals(representationType.getDenominators()));
    }

    public boolean canEqual(Object object) {
        return object instanceof RepresentationType;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + (this.getDenominators() == null ? 0 : this.getDenominators().hashCode());
        return n;
    }

    public String toString() {
        return "RepresentationType(denominators=" + this.getDenominators() + ")";
    }
}

