/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model.numbers;

import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.model.NumberLevelFactory;
import edu.colorado.phet.fractions.buildafraction.model.numbers.IRandomColors;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevel;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberTarget;
import edu.colorado.phet.fractions.buildafraction.model.numbers.RandomColors3;
import edu.colorado.phet.fractions.buildafraction.model.numbers.RandomColors4;
import edu.colorado.phet.fractions.buildafraction.model.numbers.RepresentationType;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.util.Distribution;
import edu.colorado.phet.fractions.common.util.Sampling;
import edu.colorado.phet.fractions.common.view.Colors;
import edu.colorado.phet.fractions.fractionmatcher.model.Pattern;
import edu.colorado.phet.fractions.fractionmatcher.view.FilledPattern;
import fj.Equal;
import fj.F;
import fj.P2;
import fj.data.List;
import java.awt.Color;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberLevelList
implements NumberLevelFactory {
    private static final Random random = new Random();
    private final ArrayList<Function0<NumberLevel>> levels = new ArrayList();
    public static final PatternMaker pie = new PatternMaker("pie", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.pie(mixedFraction.denominator);
        }
    };
    public static final PatternMaker horizontalBar = new PatternMaker("bar", new int[]{1, 2, 3, 4, 5, 6, 7, 8}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.tallHorizontalBars(mixedFraction.denominator);
        }
    };
    public static final PatternMaker verticalBar = new PatternMaker("bar", new int[]{1, 2, 3, 4, 5, 6, 7, 8}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.verticalBars(mixedFraction.denominator);
        }
    };
    public static final PatternMaker pyramid1 = new PatternMaker("pyramid", new int[]{1}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.pyramidSingle();
        }
    };
    public static final PatternMaker pyramid4 = new PatternMaker("pyramid", new int[]{4}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.pyramidFour();
        }
    };
    public static final PatternMaker pyramid9 = new PatternMaker("pyramid", new int[]{9}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.pyramidNine();
        }
    };
    public static final PatternMaker grid1 = new PatternMaker("grid", new int[]{1}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.grid(1);
        }
    };
    public static final PatternMaker grid1Big = new PatternMaker("grid", new int[]{1}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.gridBig();
        }
    };
    public static final PatternMaker horizontallySlicedCube = new PatternMaker("grid", new int[]{3}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.horizontallySlicedCube3();
        }
    };
    public static final PatternMaker verticallySlicedCube = new PatternMaker("grid", new int[]{3}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.verticallySlicedCube3();
        }
    };
    public static final PatternMaker grid4 = new PatternMaker("grid", new int[]{4}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.grid(2);
        }
    };
    public static final PatternMaker grid9 = new PatternMaker("grid", new int[]{9}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.grid(3);
        }
    };
    public static final PatternMaker flower = new PatternMaker("flower", new int[]{6}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.sixFlower();
        }
    };
    public static final PatternMaker polygon = new PatternMaker("polygon", new int[]{3, 4, 5, 6, 7, 8, 9}){

        public Pattern f(MixedFraction mixedFraction) {
            return Pattern.polygon(60.0, mixedFraction.denominator);
        }
    };
    private static final List<PatternMaker> universalTypes = List.list(pie, horizontalBar, verticalBar);
    public static final List<PatternMaker> allTypes = List.list(pie, horizontalBar, verticalBar, pyramid1, pyramid4, pyramid9, grid1, grid4, grid9, flower, polygon);

    @Override
    public NumberLevel createLevel(int n) {
        return this.levels.get(n).apply();
    }

    public NumberLevelList() {
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level1();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level2();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level3();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level4();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level5();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level6();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level7();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level8();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.this.level9();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return NumberLevelList.level10();
            }
        });
    }

    private void add(Function0<NumberLevel> function0) {
        this.levels.add(function0);
    }

    private NumberLevel level1() {
        RandomColors3 randomColors3 = new RandomColors3();
        return new NumberLevel(List.list(1, 1, 2, 2, 3, 3), NumberLevelList.shuffle(List.list(NumberTarget.target(1, 2, randomColors3.next(), pie.sequential()), NumberTarget.target(1, 3, randomColors3.next(), pie.sequential()), NumberTarget.target(2, 3, randomColors3.next(), pie.sequential()))));
    }

    private NumberLevel level2() {
        Object object;
        F f = (F)new Distribution<F<MixedFraction, FilledPattern>>(){
            {
                this.put(pie.sequential(), 40.0);
                this.put(horizontalBar.sequential(), 30.0);
                this.put(verticalBar.sequential(), 30.0);
            }
        }.draw();
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < 3; ++i) {
            object = this.chooseFraction(NumberLevelList.rangeInclusive(1, 4), NumberLevelList.rangeInclusive(2, 5), new F<Fraction, Boolean>(){

                @Override
                public Boolean f(Fraction fraction) {
                    return fraction.toDouble() <= 1.000001 && !arrayList.contains(fraction);
                }
            });
            arrayList.add(object);
        }
        List list = List.iterableList(arrayList);
        object = new ArrayList<Color>(NumberLevelList.shuffledColors().toCollection());
        return new NumberLevel(NumberLevelList.shuffle(list.map(new F<Fraction, NumberTarget>((ArrayList)object, f){
            final /* synthetic */ ArrayList val$colors;
            final /* synthetic */ F val$representation;
            {
                this.val$colors = arrayList;
                this.val$representation = f;
            }

            @Override
            public NumberTarget f(Fraction fraction) {
                return NumberTarget.target(fraction, (Color)this.val$colors.remove(0), (F<MixedFraction, FilledPattern>)this.val$representation);
            }
        })));
    }

    private NumberLevel level3() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5));
        Collections.shuffle(arrayList);
        RandomColors3 randomColors3 = new RandomColors3();
        List<Integer> list = List.list(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 9, 9, 9);
        List<Integer> list2 = List.list(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 6, 6, 9, 9, 9);
        boolean bl = arrayList.get(0) == 5 || arrayList.get(1) == 5 || arrayList.get(2) == 5;
        List<Integer> list3 = bl ? list : list2;
        return new NumberLevel(list3, NumberLevelList.shuffle(List.list(NumberTarget.target(arrayList.get(0), 6, randomColors3.next(), flower.sequential()), NumberTarget.target(arrayList.get(1), 6, randomColors3.next(), flower.sequential()), NumberTarget.target(arrayList.get(2), 6, randomColors3.next(), flower.sequential()))));
    }

    private NumberLevel level4() {
        RandomColors3 randomColors3 = new RandomColors3();
        return new NumberLevel(List.list(NumberTarget.target(Sampling.chooseOne(NumberLevelList.rangeInclusive(1, 1)), 1, randomColors3.next(), pyramid1.sequential()), NumberTarget.target(Sampling.chooseOne(NumberLevelList.rangeInclusive(1, 4)), 4, randomColors3.next(), pyramid4.sequential()), NumberTarget.target(Sampling.chooseOne(NumberLevelList.rangeInclusive(1, 9)), 9, randomColors3.next(), pyramid9.sequential())));
    }

    private NumberLevel level5() {
        List<RepresentationType> list = RepresentationType.all;
        RandomColors4 randomColors4 = new RandomColors4();
        return new NumberLevel(List.list(NumberLevelList.targetLessThanOrEqualTo1(randomColors4, Sampling.chooseOne(list), true), NumberLevelList.targetLessThanOrEqualTo1(randomColors4, Sampling.chooseOne(list), true), NumberLevelList.targetLessThanOrEqualTo1(randomColors4, Sampling.chooseOne(list), true)));
    }

    private NumberLevel level6() {
        for (int i = 0; i < 1000; ++i) {
            NumberLevel numberLevel = this.level6Impl();
            if (numberLevel.numbers.group(Equal.intEqual).length() <= 2) continue;
            return numberLevel;
        }
        return this.level6Impl();
    }

    private NumberLevel level6Impl() {
        List<RepresentationType> list = RepresentationType.all;
        RandomColors4 randomColors4 = new RandomColors4();
        return NumberLevel.numberLevelReduced(List.list(NumberLevelList.targetLessThanOrEqualTo1(randomColors4, Sampling.chooseOne(list), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo1(randomColors4, Sampling.chooseOne(list), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo1(randomColors4, Sampling.chooseOne(list), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo1(randomColors4, Sampling.chooseOne(list), random.nextBoolean())));
    }

    private NumberLevel level7() {
        List<List> list = List.list(List.list(Fraction.fraction(1, 2), Fraction.fraction(2, 4), Fraction.fraction(3, 6)), List.list(Fraction.fraction(1, 3), Fraction.fraction(2, 6), Fraction.fraction(3, 9)), List.list(Fraction.fraction(2, 3), Fraction.fraction(4, 6), Fraction.fraction(6, 9)), List.list(Fraction.fraction(1, 4), Fraction.fraction(2, 8)), List.list(Fraction.fraction(3, 4), Fraction.fraction(6, 8)));
        P2<List, List> p2 = Sampling.chooseTwo(list);
        P2 p22 = Sampling.chooseTwo(p2._1());
        P2 p23 = Sampling.chooseTwo(p2._2());
        RandomColors3 randomColors3 = new RandomColors3();
        Color color = randomColors3.next();
        Color color2 = randomColors3.next();
        P2<PatternMaker, PatternMaker> p24 = Sampling.chooseTwo(universalTypes);
        Fraction fraction = this.smallerNumerator((Fraction)p22._1(), (Fraction)p22._2());
        Fraction fraction2 = this.smallerNumerator((Fraction)p23._1(), (Fraction)p23._2());
        List<Fraction> list2 = List.list((Fraction)p22._1(), (Fraction)p22._2(), (Fraction)p23._1(), (Fraction)p23._2());
        List<NumberTarget> list3 = List.list(NumberTarget.target(fraction, color, p24._1().sequential()), NumberTarget.target(fraction, color, p24._1().sequential()), NumberTarget.target(fraction2, color2, p24._2().sequential()), NumberTarget.target(fraction2, color2, p24._2().sequential()));
        List<Integer> list4 = list2.map(Fraction._numerator).append(list2.map(Fraction._denominator));
        return new NumberLevel(list4, list3);
    }

    private NumberLevel level8() {
        List<List> list = List.list(List.list(Fraction.fraction(2, 3), Fraction.fraction(3, 2), Fraction.fraction(2, 2), Fraction.fraction(3, 3)), List.list(Fraction.fraction(2, 4), Fraction.fraction(4, 2), Fraction.fraction(2, 2), Fraction.fraction(4, 4)), List.list(Fraction.fraction(3, 4), Fraction.fraction(4, 3), Fraction.fraction(3, 3), Fraction.fraction(4, 4)), List.list(Fraction.fraction(3, 5), Fraction.fraction(5, 3), Fraction.fraction(3, 3), Fraction.fraction(5, 5)), List.list(Fraction.fraction(3, 6), Fraction.fraction(6, 3), Fraction.fraction(3, 3), Fraction.fraction(6, 6)));
        List list2 = NumberLevelList.shuffle(Sampling.chooseOne(list));
        RandomColors4 randomColors4 = new RandomColors4();
        List<NumberTarget> list3 = List.list(NumberTarget.target((Fraction)list2.index(0), randomColors4.next(), Sampling.chooseOne(universalTypes).sequential()), NumberTarget.target((Fraction)list2.index(1), randomColors4.next(), Sampling.chooseOne(universalTypes).sequential()), NumberTarget.target((Fraction)list2.index(2), randomColors4.next(), Sampling.chooseOne(universalTypes).sequential()), NumberTarget.target((Fraction)list2.index(3), randomColors4.next(), Sampling.chooseOne(universalTypes).sequential()));
        return new NumberLevel(list3);
    }

    private NumberLevel level9() {
        List<RepresentationType> list = Sampling.choose(4, RepresentationType.all);
        RandomColors4 randomColors4 = new RandomColors4();
        return new NumberLevel(List.list(NumberLevelList.targetLessThanOrEqualTo2(randomColors4, list.index(0), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo2(randomColors4, list.index(1), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo2(randomColors4, list.index(2), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo2(randomColors4, list.index(3), random.nextBoolean())));
    }

    private static NumberLevel level10() {
        List<RepresentationType> list = Sampling.choose(4, RepresentationType.all);
        RandomColors4 randomColors4 = new RandomColors4();
        List<NumberTarget> list2 = List.list(NumberLevelList.targetLessThanOrEqualTo1(randomColors4, list.index(0), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo1(randomColors4, list.index(1), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo2(randomColors4, list.index(2), random.nextBoolean()), NumberLevelList.targetLessThanOrEqualTo2(randomColors4, list.index(3), random.nextBoolean()));
        List<Fraction> list3 = list2.map(new F<NumberTarget, Fraction>(){

            @Override
            public Fraction f(NumberTarget numberTarget) {
                return numberTarget.mixedFraction.toFraction();
            }
        });
        List<Fraction> list4 = list3.zipWith(NumberLevelList.shuffle(List.list(1, 1, 2, 3)), Fraction._times);
        return new NumberLevel(list4.map(Fraction._denominator).append(list4.map(Fraction._numerator)), list2);
    }

    private Fraction smallerNumerator(Fraction fraction, Fraction fraction2) {
        return fraction2.numerator < fraction.numerator ? fraction2 : fraction;
    }

    private static NumberTarget targetLessThanOrEqualTo1(IRandomColors iRandomColors, RepresentationType representationType, boolean bl) {
        int n = Sampling.chooseOne(representationType.denominators);
        int n2 = Sampling.chooseOne(NumberLevelList.rangeInclusive(1, n));
        Fraction fraction = new Fraction(n2, n);
        PatternMaker patternMaker = representationType.toPattern(fraction);
        return NumberTarget.target(fraction, iRandomColors.next(), bl ? patternMaker.sequential() : patternMaker.random());
    }

    private static NumberTarget targetLessThanOrEqualTo2(RandomColors4 randomColors4, RepresentationType representationType, boolean bl) {
        int n = Sampling.chooseOne(representationType.denominators);
        int n2 = Sampling.chooseOne(NumberLevelList.rangeInclusive(1, n * 2).filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return n < 10;
            }
        }));
        Fraction fraction = new Fraction(n2, n);
        PatternMaker patternMaker = representationType.toPattern(fraction);
        return NumberTarget.target(fraction, randomColors4.next(), bl ? patternMaker.sequential() : patternMaker.random());
    }

    private static List<Color> shuffledColors() {
        return NumberLevelList.shuffle(List.list(Colors.LIGHT_RED, Colors.LIGHT_GREEN, Colors.LIGHT_BLUE, Color.orange));
    }

    public static <T> List<T> shuffle(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list.toCollection());
        Collections.shuffle(arrayList);
        return List.iterableList(arrayList);
    }

    public static List<Integer> rangeInclusive(int n, int n2) {
        return List.range(n, n2 + 1);
    }

    private Fraction chooseFraction(List<Integer> list, List<Integer> list2, F<Fraction, Boolean> f) {
        for (int i = 0; i < 1000; ++i) {
            Fraction fraction = Fraction.fraction(Sampling.chooseOne(list), Sampling.chooseOne(list2));
            if (!f.f(fraction).booleanValue()) continue;
            return fraction;
        }
        throw new RuntimeException("Couldn't find a match");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PatternMaker
    extends F<MixedFraction, Pattern> {
        public final String name;
        public final List<Integer> acceptedDenominators;

        PatternMaker(String string, int ... nArray) {
            this.name = string;
            List<Integer> list = List.nil();
            for (int n : nArray) {
                list = list.snoc(n);
            }
            this.acceptedDenominators = list;
        }

        public F<MixedFraction, FilledPattern> sequential() {
            return new Sequential(this);
        }

        public F<MixedFraction, FilledPattern> random() {
            return new RandomFill(this);
        }

        public String getName() {
            return this.name;
        }

        public List<Integer> getAcceptedDenominators() {
            return this.acceptedDenominators;
        }

        public String toString() {
            return "NumberLevelList.PatternMaker(name=" + this.getName() + ", acceptedDenominators=" + this.getAcceptedDenominators() + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PatternMaker)) {
                return false;
            }
            PatternMaker patternMaker = (PatternMaker)object;
            if (!patternMaker.canEqual(this)) {
                return false;
            }
            if (this.getName() == null ? patternMaker.getName() != null : !this.getName().equals(patternMaker.getName())) {
                return false;
            }
            return !(this.getAcceptedDenominators() == null ? patternMaker.getAcceptedDenominators() != null : !this.getAcceptedDenominators().equals(patternMaker.getAcceptedDenominators()));
        }

        public boolean canEqual(Object object) {
            return object instanceof PatternMaker;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + (this.getName() == null ? 0 : this.getName().hashCode());
            n = n * 31 + (this.getAcceptedDenominators() == null ? 0 : this.getAcceptedDenominators().hashCode());
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RandomFill
    extends F<MixedFraction, FilledPattern> {
        public final PatternMaker patternMaker;

        @Override
        public FilledPattern f(MixedFraction mixedFraction) {
            return FilledPattern.randomFill((Pattern)this.patternMaker.f(mixedFraction), mixedFraction.numerator, random.nextLong());
        }

        @ConstructorProperties(value={"patternMaker"})
        public RandomFill(PatternMaker patternMaker) {
            this.patternMaker = patternMaker;
        }

        public PatternMaker getPatternMaker() {
            return this.patternMaker;
        }

        public String toString() {
            return "NumberLevelList.RandomFill(patternMaker=" + this.getPatternMaker() + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RandomFill)) {
                return false;
            }
            RandomFill randomFill = (RandomFill)object;
            if (!randomFill.canEqual(this)) {
                return false;
            }
            return !(this.getPatternMaker() == null ? randomFill.getPatternMaker() != null : !this.getPatternMaker().equals(randomFill.getPatternMaker()));
        }

        public boolean canEqual(Object object) {
            return object instanceof RandomFill;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + (this.getPatternMaker() == null ? 0 : this.getPatternMaker().hashCode());
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sequential
    extends F<MixedFraction, FilledPattern> {
        public final PatternMaker patternMaker;

        @Override
        public FilledPattern f(MixedFraction mixedFraction) {
            return FilledPattern.sequentialFill((Pattern)this.patternMaker.f(mixedFraction), mixedFraction.numerator);
        }

        @ConstructorProperties(value={"patternMaker"})
        public Sequential(PatternMaker patternMaker) {
            this.patternMaker = patternMaker;
        }

        public PatternMaker getPatternMaker() {
            return this.patternMaker;
        }

        public String toString() {
            return "NumberLevelList.Sequential(patternMaker=" + this.getPatternMaker() + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Sequential)) {
                return false;
            }
            Sequential sequential = (Sequential)object;
            if (!sequential.canEqual(this)) {
                return false;
            }
            return !(this.getPatternMaker() == null ? sequential.getPatternMaker() != null : !this.getPatternMaker().equals(sequential.getPatternMaker()));
        }

        public boolean canEqual(Object object) {
            return object instanceof Sequential;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + (this.getPatternMaker() == null ? 0 : this.getPatternMaker().hashCode());
            return n;
        }
    }
}

