/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model.numbers;

import edu.colorado.phet.fractions.buildafraction.model.Level;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberTarget;
import edu.colorado.phet.fractions.buildafraction.model.numbers.RandomColors3;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.fractionmatcher.view.FilledPattern;
import edu.colorado.phet.fractions.fractionmatcher.view.PatternType;
import fj.Equal;
import fj.F;
import fj.Ord;
import fj.data.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberLevel
extends Level {
    public final List<Integer> numbers;
    public final List<NumberTarget> targets;

    public NumberLevel(List<Integer> list, List<NumberTarget> list2) {
        super(list2.map(NumberTarget._mixedFraction));
        this.numbers = list.sort(Ord.intOrd);
        this.targets = list2;
    }

    public NumberLevel(List<NumberTarget> list) {
        this(list.map(NumberTarget._mixedFraction).map(MixedFraction._numerator).append(list.map(NumberTarget._mixedFraction).map(MixedFraction._denominator).append(list.map(NumberTarget._mixedFraction).map(MixedFraction._whole).filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return n > 0;
            }
        }))), list);
    }

    public static List<Integer> straightforwardNumbers(List<MixedFraction> list) {
        return list.map(MixedFraction._numerator).append(list.map(MixedFraction._denominator).append(list.map(MixedFraction._whole).filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return n > 0;
            }
        })));
    }

    public NumberLevel(List<MixedFraction> list, RandomColors3 randomColors3, F<MixedFraction, FilledPattern> f) {
        this(List.list(NumberTarget.target(list.index(0), randomColors3.next(), f), NumberTarget.target(list.index(1), randomColors3.next(), f), NumberTarget.target(list.index(2), randomColors3.next(), f)));
    }

    public static NumberLevel numberLevelReduced(List<NumberTarget> list) {
        List<Fraction> list2 = list.map(MixedFraction._fractionPart).map(Fraction._reduce);
        List<Integer> list3 = list2.map(Fraction._numerator).append(list2.map(Fraction._denominator));
        return new NumberLevel(list3, list);
    }

    public boolean hasValuesGreaterThanOne() {
        return this.targets.exists(new F<NumberTarget, Boolean>(){

            @Override
            public Boolean f(NumberTarget numberTarget) {
                return numberTarget.mixedFraction.toFraction().greaterThanOne();
            }
        });
    }

    public boolean hasMixedNumbers() {
        return this.targets.exists(new F<NumberTarget, Boolean>(){

            @Override
            public Boolean f(NumberTarget numberTarget) {
                return numberTarget.mixedFraction.whole > 0;
            }
        });
    }

    public boolean hasDifferentShapeTypes() {
        return this.getPatternTypes().group(Equal.anyEqual()).length() > 1;
    }

    public List<PatternType> getPatternTypes() {
        return this.targets.map(new F<NumberTarget, PatternType>(){

            @Override
            public PatternType f(NumberTarget numberTarget) {
                return numberTarget.getRepresentation().f((MixedFraction)numberTarget.mixedFraction).type;
            }
        });
    }
}

