/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model.numbers;

import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.model.NumberLevelFactory;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevel;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevelList;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberTarget;
import edu.colorado.phet.fractions.buildafraction.model.numbers.RandomColors3;
import edu.colorado.phet.fractions.buildafraction.model.numbers.RandomColors4;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.util.Sampling;
import edu.colorado.phet.fractions.fractionmatcher.view.FilledPattern;
import fj.Equal;
import fj.F;
import fj.Ord;
import fj.P2;
import fj.Unit;
import fj.data.List;
import java.awt.Color;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedNumbersNumberLevelList
implements NumberLevelFactory {
    public static final Random random = new Random();
    private final ArrayList<Function0<NumberLevel>> levels = new ArrayList();
    private final List<ShapeTypeEnum> shapeTypes = List.list(ShapeTypeEnum.BAR, ShapeTypeEnum.PIE, ShapeTypeEnum.CUBES);
    private final List<ShapeTypeWithDenominators> level9_10_sets = List.list(new ShapeTypeWithDenominators(List.list(1, 2, 3, 6), List.list(ShapeTypeEnum.BAR, ShapeTypeEnum.PIE)), new ShapeTypeWithDenominators(List.list(1, 2, 4, 8), List.list(ShapeTypeEnum.BAR, ShapeTypeEnum.PIE)), new ShapeTypeWithDenominators(List.list(1, 3, 9), List.list(ShapeTypeEnum.CUBES)));
    private static final List<NumberLevelList.PatternMaker> typesForLevels9_10 = List.list(NumberLevelList.pie, NumberLevelList.horizontalBar);

    public MixedNumbersNumberLevelList() {
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.level1();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.level2();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.level3();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.level4();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.withDifferentRepresentations(new F<Unit, NumberLevel>(){

                    @Override
                    public NumberLevel f(Unit unit) {
                        return MixedNumbersNumberLevelList.this.level5();
                    }
                });
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.withDifferentRepresentations(new F<Unit, NumberLevel>(){

                    @Override
                    public NumberLevel f(Unit unit) {
                        return MixedNumbersNumberLevelList.this.level6();
                    }
                });
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.withDifferentRepresentations(new F<Unit, NumberLevel>(){

                    @Override
                    public NumberLevel f(Unit unit) {
                        return MixedNumbersNumberLevelList.this.level7();
                    }
                });
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.withDifferentRepresentations(new F<Unit, NumberLevel>(){

                    @Override
                    public NumberLevel f(Unit unit) {
                        return MixedNumbersNumberLevelList.this.level8();
                    }
                });
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.level9();
            }
        });
        this.add(new Function0<NumberLevel>(){

            @Override
            public NumberLevel apply() {
                return MixedNumbersNumberLevelList.this.level10();
            }
        });
    }

    private void add(Function0<NumberLevel> function0) {
        this.levels.add(function0);
    }

    @Override
    public NumberLevel createLevel(int n) {
        return this.levels.get(n).apply();
    }

    private NumberLevel withDifferentRepresentations(F<Unit, NumberLevel> f) {
        for (int i = 0; i < 10; ++i) {
            NumberLevel numberLevel = f.f(Unit.unit());
            if (!numberLevel.hasDifferentShapeTypes()) continue;
            return numberLevel;
        }
        return f.f(Unit.unit());
    }

    private NumberLevel level1() {
        RandomColors3 randomColors3 = new RandomColors3();
        return new NumberLevel(NumberLevelList.shuffle(List.list(NumberTarget.target(1, 1, 2, randomColors3.next(), NumberLevelList.pie.sequential()), NumberTarget.target(2, 1, 2, randomColors3.next(), NumberLevelList.pie.sequential()), NumberTarget.target(3, 1, 4, randomColors3.next(), NumberLevelList.pie.sequential()))));
    }

    private NumberLevel level2() {
        RandomColors3 randomColors3 = new RandomColors3();
        F<MixedFraction, FilledPattern> f = random.nextBoolean() ? NumberLevelList.pie.sequential() : NumberLevelList.horizontalBar.sequential();
        List<Integer> list = List.list(1, 2, 3);
        List<Fraction> list2 = List.list(Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(2, 3), Fraction.fraction(1, 4), Fraction.fraction(3, 4));
        List<MixedFraction> list3 = MixedNumbersNumberLevelList.getMixedFractions(list, list2);
        List<MixedFraction> list4 = Sampling.choose(3, list3);
        return new NumberLevel(list4, randomColors3, f);
    }

    public static List<MixedFraction> getMixedFractions(List<Integer> list, List<Fraction> list2) {
        ArrayList<MixedFraction> arrayList = new ArrayList<MixedFraction>();
        for (Integer n : list) {
            for (Fraction fraction : list2) {
                arrayList.add(MixedFraction.mixedFraction(n, fraction));
            }
        }
        return List.iterableList(arrayList);
    }

    private NumberLevel level3() {
        List<MixedFraction> list = MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), List.list(Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(2, 3), Fraction.fraction(1, 6), Fraction.fraction(5, 6)));
        RandomColors3 randomColors3 = new RandomColors3();
        List<MixedFraction> list2 = Sampling.choose(3, list);
        return new NumberLevel(List.list(NumberTarget.target(list2.index(0), randomColors3.next(), this.scaleFlowerToSixths()), NumberTarget.target(list2.index(1), randomColors3.next(), this.scaleFlowerToSixths()), NumberTarget.target(list2.index(2), randomColors3.next(), this.scaleFlowerToSixths())));
    }

    private NumberLevel level4() {
        List<MixedFraction> list = MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), List.list(Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(2, 3), Fraction.fraction(1, 4), Fraction.fraction(3, 4), Fraction.fraction(1, 9), Fraction.fraction(2, 9), Fraction.fraction(4, 9), Fraction.fraction(5, 9), Fraction.fraction(7, 9), Fraction.fraction(8, 9)));
        return new NumberLevel(Sampling.choose(3, list), new RandomColors3(), new F<MixedFraction, FilledPattern>(){

            @Override
            public FilledPattern f(MixedFraction mixedFraction) {
                int n = mixedFraction.getFractionPart().denominator;
                return n == 2 ? NumberLevelList.pyramid4.sequential().f(mixedFraction.scaleNumeratorAndDenominator(2)) : (n == 3 ? NumberLevelList.pyramid9.sequential().f(mixedFraction.scaleNumeratorAndDenominator(3)) : (n == 4 ? NumberLevelList.pyramid4.sequential().f(mixedFraction) : (n == 9 ? NumberLevelList.pyramid9.sequential().f(mixedFraction) : null)));
            }
        });
    }

    NumberLevel level5() {
        List<Integer> list = List.list(1, 2, 3);
        List<MixedFraction> list2 = MixedNumbersNumberLevelList.getMixedFractions(list, this.fullListOfFractions());
        List<MixedFraction> list3 = Sampling.choose(2, list2);
        RandomColors3 randomColors3 = new RandomColors3();
        MixedFraction mixedFraction = list3.index(0);
        MixedFraction mixedFraction2 = list3.index(1);
        MixedFraction mixedFraction3 = Sampling.chooseOne(MixedNumbersNumberLevelList.getMixedFractions(list, this.expandable()));
        final long l = random.nextLong();
        return new NumberLevel(List.list(NumberTarget.target(mixedFraction, randomColors3.next(), this.chooseMatchingPattern(mixedFraction.denominator).sequential()), NumberTarget.target(mixedFraction2, randomColors3.next(), this.chooseMatchingPattern(mixedFraction2.denominator).sequential()), NumberTarget.target(mixedFraction3, randomColors3.next(), new F<MixedFraction, FilledPattern>(){

            @Override
            public FilledPattern f(MixedFraction mixedFraction) {
                int n = mixedFraction.getFractionPart().denominator;
                List list = MixedNumbersNumberLevelList.this.getScaleFactors(n);
                Integer n2 = (Integer)Sampling.chooseOneWithSeed(l, list);
                return ((NumberLevelList.PatternMaker)Sampling.chooseOneWithSeed(l, MixedNumbersNumberLevelList.this.matching(n * n2))).sequential().f(mixedFraction.scaleNumeratorAndDenominator(n2));
            }
        })));
    }

    private List<Integer> getScaleFactors(int n) {
        List<Integer> list;
        List<Integer> list2 = n == 2 ? List.list(2, 3, 4) : (n == 3 ? List.list(2, 3) : (list = n == 4 ? List.list(2) : null));
        assert (list != null);
        return list;
    }

    private NumberLevelList.PatternMaker chooseMatchingPattern(int n) {
        return Sampling.chooseOne(this.matching(n));
    }

    private List<NumberLevelList.PatternMaker> matching(final int n) {
        return NumberLevelList.allTypes.filter(new F<NumberLevelList.PatternMaker, Boolean>(){

            @Override
            public Boolean f(NumberLevelList.PatternMaker patternMaker) {
                return patternMaker.acceptedDenominators.exists(MixedNumbersNumberLevelList.this.equalsInt(n));
            }
        });
    }

    private F<Integer, Boolean> equalsInt(final int n) {
        return new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n2) {
                return n2 == n;
            }
        };
    }

    public static List<Fraction> parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        ArrayList<Fraction> arrayList = new ArrayList<Fraction>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
            arrayList.add(Fraction.fraction(Integer.parseInt(stringTokenizer2.nextToken()), Integer.parseInt(stringTokenizer2.nextToken())));
        }
        return List.iterableList(arrayList);
    }

    NumberLevel level6() {
        List<Fraction> list = this.expandable();
        List<Integer> list2 = List.list(1, 2, 3);
        List<MixedFraction> list3 = MixedNumbersNumberLevelList.getMixedFractions(list2, this.fullListOfFractions());
        List<MixedFraction> list4 = Sampling.choose(2, list3);
        RandomColors4 randomColors4 = new RandomColors4();
        MixedFraction mixedFraction = list4.index(0);
        MixedFraction mixedFraction2 = list4.index(1);
        P2<MixedFraction, MixedFraction> p2 = Sampling.chooseTwo(MixedNumbersNumberLevelList.getMixedFractions(list2, list));
        MixedFraction mixedFraction3 = p2._1();
        MixedFraction mixedFraction4 = p2._2();
        long l = random.nextLong();
        return new NumberLevel(List.list(NumberTarget.shuffledTarget(mixedFraction, randomColors4.next(), this.chooseMatchingPattern(mixedFraction.denominator).random()), NumberTarget.shuffledTarget(mixedFraction2, randomColors4.next(), this.chooseMatchingPattern(mixedFraction2.denominator).random()), NumberTarget.shuffledTarget(mixedFraction3, randomColors4.next(), this.scaledRepresentation(l, true, true)), NumberTarget.shuffledTarget(mixedFraction4, randomColors4.next(), this.scaledRepresentation(l, true, true))));
    }

    private List<Fraction> expandable() {
        return MixedNumbersNumberLevelList.parse("1/2, 1/3, 2/3, 1/4, 3/4");
    }

    private List<Fraction> fullListOfFractions() {
        return MixedNumbersNumberLevelList.parse("1/2, 1/3, 2/3, 1/4, 3/4, 1/5, 2/5, 3/5, 4/5, 1/6, 5/6, 1/7, 2/7, 3/7, 4/7, 5/7, 6/7, 1/8, 3/8, 5/8, 7/8, 1/9, 2/9, 4/9, 5/9, 7/9, 8/9");
    }

    private F<MixedFraction, FilledPattern> scaleFlowerToSixths() {
        return new F<MixedFraction, FilledPattern>(){

            @Override
            public FilledPattern f(MixedFraction mixedFraction) {
                int n = mixedFraction.getFractionPart().denominator;
                Integer n2 = 6 / n;
                return NumberLevelList.flower.sequential().f(mixedFraction.scaleNumeratorAndDenominator(n2));
            }
        };
    }

    private F<MixedFraction, FilledPattern> scaledRepresentation(long l, boolean bl, boolean bl2) {
        return new ScaledRepresentation(l, bl, bl2);
    }

    NumberLevel level7() {
        List<MixedFraction> list = MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), this.expandable());
        P2<MixedFraction, MixedFraction> p2 = Sampling.chooseTwo(list);
        MixedFraction mixedFraction = p2._1();
        MixedFraction mixedFraction2 = p2._2();
        long l = random.nextLong();
        RandomColors4 randomColors4 = new RandomColors4();
        List<Boolean> list2 = NumberLevelList.shuffle(List.list(true, false));
        List<Boolean> list3 = NumberLevelList.shuffle(List.list(true, false));
        return new NumberLevel(List.list(NumberTarget.target(mixedFraction, randomColors4.next(), this.scaledRepresentation(l, false, list2.index(0))), NumberTarget.target(mixedFraction, randomColors4.next(), this.scaledRepresentation(l, false, list2.index(1))), NumberTarget.target(mixedFraction2, randomColors4.next(), this.scaledRepresentation(l, false, list3.index(0))), NumberTarget.target(mixedFraction2, randomColors4.next(), this.scaledRepresentation(l, false, list3.index(1)))));
    }

    NumberLevel level8() {
        List<Fraction> list = this.expandable();
        List<Integer> list2 = List.list(1, 2, 3);
        RandomColors4 randomColors4 = new RandomColors4();
        List<MixedFraction> list3 = Sampling.choose(4, MixedNumbersNumberLevelList.getMixedFractions(list2, list));
        long l = random.nextLong();
        return new NumberLevel(List.list(NumberTarget.shuffledTarget(list3.index(0), randomColors4.next(), this.scaledRepresentation(l, true, true)), NumberTarget.shuffledTarget(list3.index(1), randomColors4.next(), this.scaledRepresentation(l, true, true)), NumberTarget.shuffledTarget(list3.index(2), randomColors4.next(), this.scaledRepresentation(l, true, true)), NumberTarget.shuffledTarget(list3.index(3), randomColors4.next(), this.scaledRepresentation(l, true, true))));
    }

    NumberLevel level9ORIG() {
        return this.levelWithSomeScattering(List.list(true, true, false, false));
    }

    public static NumberLevelList.PatternMaker toPatternMaker(ShapeTypeEnum shapeTypeEnum, Integer n) {
        if (shapeTypeEnum == ShapeTypeEnum.BAR) {
            return NumberLevelList.horizontalBar;
        }
        if (shapeTypeEnum == ShapeTypeEnum.PIE) {
            return NumberLevelList.pie;
        }
        if (shapeTypeEnum == ShapeTypeEnum.CUBES) {
            NumberLevelList.PatternMaker patternMaker;
            NumberLevelList.PatternMaker patternMaker2 = n == 1 ? NumberLevelList.grid1Big : (n == 3 ? (random.nextBoolean() ? NumberLevelList.horizontallySlicedCube : NumberLevelList.verticallySlicedCube) : (patternMaker = n == 9 ? NumberLevelList.grid9 : null));
            if (patternMaker == null) {
                throw new RuntimeException("no cube found for denominator " + n);
            }
            return patternMaker;
        }
        throw new RuntimeException("type not found");
    }

    private static MixedFraction patternToMixedFraction(List<FilledPattern> list) {
        Fraction fraction = new Fraction(0, 1);
        for (FilledPattern filledPattern : list) {
            fraction = fraction.plus(filledPattern.toFraction());
        }
        return fraction.toMixedFraction();
    }

    NumberLevel level9() {
        NumberLevel numberLevel = this.level9ORIG();
        RandomColors4 randomColors4 = new RandomColors4();
        NumberTarget numberTarget = new NumberTarget(numberLevel.targets.index((int)0).mixedFraction, randomColors4.next(), numberLevel.targets.index((int)0).filledPattern, numberLevel.targets.index((int)0).representation);
        NumberTarget numberTarget2 = new NumberTarget(numberLevel.targets.index((int)1).mixedFraction, randomColors4.next(), numberLevel.targets.index((int)1).filledPattern, numberLevel.targets.index((int)1).representation);
        List<ShapeTypeEnum> list = Sampling.choose(2, this.shapeTypes);
        List<Sample> list2 = list.map(new F<ShapeTypeEnum, Sample>(){

            @Override
            public Sample f(ShapeTypeEnum shapeTypeEnum) {
                return MixedNumbersNumberLevelList.this.shapeTypeEnumToSample(shapeTypeEnum);
            }
        });
        NumberTarget numberTarget3 = this.sampleToTarget(randomColors4, list2.index(0));
        NumberTarget numberTarget4 = this.sampleToTarget(randomColors4, list2.index(1));
        return new NumberLevel(NumberLevelList.shuffle(List.list(numberTarget, numberTarget2, numberTarget3, numberTarget4)));
    }

    private Sample shapeTypeEnumToSample(ShapeTypeEnum shapeTypeEnum) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (ShapeTypeWithDenominators shapeTypeWithDenominators : this.level9_10_sets) {
            if (!shapeTypeWithDenominators.matchingTypes.elementIndex(Equal.anyEqual(), shapeTypeEnum).isSome()) continue;
            arrayList.add(new Sample(shapeTypeWithDenominators.denominators, shapeTypeEnum));
        }
        return (Sample)Sampling.chooseOne(List.iterableList(arrayList));
    }

    private NumberTarget sampleToTarget(RandomColors4 randomColors4, Sample sample) {
        ShapeTypeEnum shapeTypeEnum = sample.type;
        List<FilledPattern> list = sample.toShapeList();
        NumberLevelList.PatternMaker patternMaker = shapeTypeEnum == ShapeTypeEnum.PIE ? NumberLevelList.pie : (shapeTypeEnum == ShapeTypeEnum.BAR ? NumberLevelList.horizontalBar : (shapeTypeEnum == ShapeTypeEnum.CUBES ? NumberLevelList.grid1 : null));
        return new NumberTarget(MixedNumbersNumberLevelList.patternToMixedFraction(list), randomColors4.next(), list, patternMaker.random());
    }

    NumberLevel level10() {
        RandomColors4 randomColors4 = new RandomColors4();
        List<ShapeTypeEnum> list = this.shapeTypes.snoc(Sampling.chooseOne(this.shapeTypes));
        List<Sample> list2 = list.map(new F<ShapeTypeEnum, Sample>(){

            @Override
            public Sample f(ShapeTypeEnum shapeTypeEnum) {
                return MixedNumbersNumberLevelList.this.shapeTypeEnumToSample(shapeTypeEnum);
            }
        });
        NumberTarget numberTarget = this.sampleToTarget(randomColors4, list2.index(0));
        NumberTarget numberTarget2 = this.sampleToTarget(randomColors4, list2.index(1));
        NumberTarget numberTarget3 = this.sampleToTarget(randomColors4, list2.index(2));
        NumberTarget numberTarget4 = this.sampleToTarget(randomColors4, list2.index(3));
        return new NumberLevel(NumberLevelList.shuffle(List.list(numberTarget, numberTarget2, numberTarget3, numberTarget4)));
    }

    NumberLevel levelWithSomeScattering(List<Boolean> list) {
        final List<Integer> list2 = List.list(1, 2, 3);
        List<Integer> list3 = NumberLevelList.rangeInclusive(2, 8);
        List<Integer> list4 = Sampling.choose(4, list3);
        List<MixedFraction> list5 = list4.map(new F<Integer, MixedFraction>(){

            @Override
            public MixedFraction f(Integer n) {
                MixedFraction mixedFraction = new MixedFraction((Integer)Sampling.chooseOne(list2), Sampling.chooseOne(NumberLevelList.rangeInclusive(1, n - 1)), n);
                return mixedFraction.withReducedFractionPart();
            }
        });
        final RandomColors4 randomColors4 = new RandomColors4();
        final List<Boolean> list6 = NumberLevelList.shuffle(list);
        final IntegerProperty integerProperty = new IntegerProperty(0);
        return new NumberLevel(list5.map(new F<MixedFraction, NumberTarget>(){

            @Override
            public NumberTarget f(MixedFraction mixedFraction) {
                NumberTarget numberTarget = MixedNumbersNumberLevelList.this.difficultTarget(mixedFraction, randomColors4.next(), (Boolean)list6.index((Integer)integerProperty.get()));
                integerProperty.increment();
                return numberTarget;
            }
        }));
    }

    private NumberTarget difficultTarget(MixedFraction mixedFraction, Color color, Boolean bl) {
        return bl != false ? NumberTarget.scatteredTarget(mixedFraction, color, Sampling.chooseOne(typesForLevels9_10).random()) : NumberTarget.target(mixedFraction, color, Sampling.chooseOne(typesForLevels9_10).random());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Sample {
        public final List<Integer> denominators;
        public final ShapeTypeEnum type;

        public List<FilledPattern> toShapeList() {
            for (int i = 0; i < 1000; ++i) {
                List<FilledPattern> list = this.toShapes(this.type);
                MixedFraction mixedFraction = MixedNumbersNumberLevelList.patternToMixedFraction(list);
                List<Integer> list2 = NumberLevel.straightforwardNumbers(List.single(mixedFraction));
                if (list.length() <= 2 || mixedFraction.toFraction().numerator <= mixedFraction.toFraction().denominator || list2.maximum(Ord.intOrd) >= 10 || list2.filter(new F<Integer, Boolean>(){

                    @Override
                    public Boolean f(Integer n) {
                        return n == 0;
                    }
                }).length() != 0) continue;
                return list;
            }
            System.out.println("Bailing OUT");
            return this.toShapes(this.type);
        }

        private List<FilledPattern> toShapes(ShapeTypeEnum shapeTypeEnum) {
            ArrayList<FilledPattern> arrayList = new ArrayList<FilledPattern>();
            for (Integer n : this.denominators) {
                int n2;
                int n3 = n2 = n == 1 ? 1 : random.nextInt(n);
                if (n == 6 && List.iterableList(arrayList).exists(new F<FilledPattern, Boolean>(){

                    @Override
                    public Boolean f(FilledPattern filledPattern) {
                        return filledPattern.getDenominator() == 1;
                    }
                }) && List.iterableList(arrayList).exists(new F<FilledPattern, Boolean>(){

                    @Override
                    public Boolean f(FilledPattern filledPattern) {
                        return filledPattern.getDenominator() == 2;
                    }
                }) && List.iterableList(arrayList).exists(new F<FilledPattern, Boolean>(){

                    @Override
                    public Boolean f(FilledPattern filledPattern) {
                        return filledPattern.getDenominator() == 3;
                    }
                })) {
                    n2 = random.nextInt(n - 1) + 1;
                }
                NumberLevelList.PatternMaker patternMaker = MixedNumbersNumberLevelList.toPatternMaker(shapeTypeEnum, n);
                if (n2 <= 0) continue;
                arrayList.add(patternMaker.random().f(new MixedFraction(0, n2, n)));
            }
            return NumberLevelList.shuffle(List.iterableList(arrayList));
        }

        @ConstructorProperties(value={"denominators", "type"})
        public Sample(List<Integer> list, ShapeTypeEnum shapeTypeEnum) {
            this.denominators = list;
            this.type = shapeTypeEnum;
        }

        public List<Integer> getDenominators() {
            return this.denominators;
        }

        public ShapeTypeEnum getType() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Sample)) {
                return false;
            }
            Sample sample = (Sample)object;
            if (!sample.canEqual(this)) {
                return false;
            }
            if (this.getDenominators() == null ? sample.getDenominators() != null : !this.getDenominators().equals(sample.getDenominators())) {
                return false;
            }
            return !(this.getType() == null ? sample.getType() != null : !this.getType().equals((Object)sample.getType()));
        }

        public boolean canEqual(Object object) {
            return object instanceof Sample;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + (this.getDenominators() == null ? 0 : this.getDenominators().hashCode());
            n = n * 31 + (this.getType() == null ? 0 : this.getType().hashCode());
            return n;
        }

        public String toString() {
            return "MixedNumbersNumberLevelList.Sample(denominators=" + this.getDenominators() + ", type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScaledRepresentation
    extends F<MixedFraction, FilledPattern> {
        private final long seed;
        private final boolean random;
        private final boolean reallyScaleIt;

        public ScaledRepresentation(long l, boolean bl, boolean bl2) {
            this.seed = l;
            this.random = bl;
            this.reallyScaleIt = bl2;
        }

        @Override
        public FilledPattern f(MixedFraction mixedFraction) {
            int n = mixedFraction.getFractionPart().denominator;
            List<Integer> list = this.reallyScaleIt ? MixedNumbersNumberLevelList.this.getScaleFactors(n) : List.list(1);
            Integer n2 = Sampling.chooseOneWithSeed(this.seed, list);
            int n3 = n * n2;
            NumberLevelList.PatternMaker patternMaker = (NumberLevelList.PatternMaker)Sampling.chooseOneWithSeed(this.seed, MixedNumbersNumberLevelList.this.matching(n3));
            return (this.random ? patternMaker.random() : patternMaker.sequential()).f(mixedFraction.scaleNumeratorAndDenominator(n2));
        }

        public boolean equals(Object object) {
            if (object instanceof ScaledRepresentation) {
                ScaledRepresentation scaledRepresentation = (ScaledRepresentation)object;
                MixedFraction mixedFraction = MixedFraction.mixedFraction(1, Fraction.fraction(2, 3));
                FilledPattern filledPattern = this.f(mixedFraction);
                FilledPattern filledPattern2 = scaledRepresentation.f(mixedFraction);
                return filledPattern.type.equals((Object)filledPattern2.type);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ShapeTypeEnum
    extends Enum<ShapeTypeEnum> {
        public static final /* enum */ ShapeTypeEnum BAR = new ShapeTypeEnum();
        public static final /* enum */ ShapeTypeEnum PIE = new ShapeTypeEnum();
        public static final /* enum */ ShapeTypeEnum CUBES = new ShapeTypeEnum();
        private static final /* synthetic */ ShapeTypeEnum[] $VALUES;

        public static ShapeTypeEnum[] values() {
            return (ShapeTypeEnum[])$VALUES.clone();
        }

        static {
            $VALUES = new ShapeTypeEnum[]{BAR, PIE, CUBES};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShapeTypeWithDenominators {
        public final List<Integer> denominators;
        public final List<ShapeTypeEnum> matchingTypes;

        @ConstructorProperties(value={"denominators", "matchingTypes"})
        public ShapeTypeWithDenominators(List<Integer> list, List<ShapeTypeEnum> list2) {
            this.denominators = list;
            this.matchingTypes = list2;
        }

        public List<Integer> getDenominators() {
            return this.denominators;
        }

        public List<ShapeTypeEnum> getMatchingTypes() {
            return this.matchingTypes;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ShapeTypeWithDenominators)) {
                return false;
            }
            ShapeTypeWithDenominators shapeTypeWithDenominators = (ShapeTypeWithDenominators)object;
            if (!shapeTypeWithDenominators.canEqual(this)) {
                return false;
            }
            if (this.getDenominators() == null ? shapeTypeWithDenominators.getDenominators() != null : !this.getDenominators().equals(shapeTypeWithDenominators.getDenominators())) {
                return false;
            }
            return !(this.getMatchingTypes() == null ? shapeTypeWithDenominators.getMatchingTypes() != null : !this.getMatchingTypes().equals(shapeTypeWithDenominators.getMatchingTypes()));
        }

        public boolean canEqual(Object object) {
            return object instanceof ShapeTypeWithDenominators;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + (this.getDenominators() == null ? 0 : this.getDenominators().hashCode());
            n = n * 31 + (this.getMatchingTypes() == null ? 0 : this.getMatchingTypes().hashCode());
            return n;
        }

        public String toString() {
            return "MixedNumbersNumberLevelList.ShapeTypeWithDenominators(denominators=" + this.getDenominators() + ", matchingTypes=" + this.getMatchingTypes() + ")";
        }
    }
}

