/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model;

import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberTarget;
import edu.colorado.phet.fractions.common.math.Fraction;
import fj.F;
import java.beans.ConstructorProperties;

public class MixedFraction {
    public final int whole;
    public final int numerator;
    public final int denominator;
    public static final F<MixedFraction, Double> _toDouble = new F<MixedFraction, Double>(){

        @Override
        public Double f(MixedFraction mixedFraction) {
            return mixedFraction.toDouble();
        }
    };
    public static final F<Fraction, MixedFraction> _toMixedFraction = new F<Fraction, MixedFraction>(){

        @Override
        public MixedFraction f(Fraction fraction) {
            return new MixedFraction(0, fraction.numerator, fraction.denominator);
        }
    };
    public static final F<MixedFraction, Boolean> _greaterThanOne = new F<MixedFraction, Boolean>(){

        @Override
        public Boolean f(MixedFraction mixedFraction) {
            return mixedFraction.toFraction().greaterThanOne();
        }
    };
    public static final F<MixedFraction, Integer> _numerator = new F<MixedFraction, Integer>(){

        @Override
        public Integer f(MixedFraction mixedFraction) {
            return mixedFraction.numerator;
        }
    };
    public static final F<MixedFraction, Integer> _denominator = new F<MixedFraction, Integer>(){

        @Override
        public Integer f(MixedFraction mixedFraction) {
            return mixedFraction.denominator;
        }
    };
    public static final F<MixedFraction, Integer> _whole = new F<MixedFraction, Integer>(){

        @Override
        public Integer f(MixedFraction mixedFraction) {
            return mixedFraction.whole;
        }
    };
    public static final F<NumberTarget, Fraction> _fractionPart = new F<NumberTarget, Fraction>(){

        @Override
        public Fraction f(NumberTarget numberTarget) {
            return numberTarget.mixedFraction.getFractionPart();
        }
    };
    public static final F<MixedFraction, Fraction> _toFraction = new F<MixedFraction, Fraction>(){

        @Override
        public Fraction f(MixedFraction mixedFraction) {
            return mixedFraction.toFraction();
        }
    };

    public static MixedFraction mixedFraction(Integer n, Fraction fraction) {
        return new MixedFraction(n, fraction.numerator, fraction.denominator);
    }

    public Fraction getFractionPart() {
        return new Fraction(this.numerator, this.denominator);
    }

    public Fraction toFraction() {
        Fraction fraction = this.getFractionPart();
        return new Fraction(fraction.numerator + this.whole * fraction.denominator, fraction.denominator);
    }

    public double toDouble() {
        return (double)this.whole + this.getFractionPart().toDouble();
    }

    public boolean approxEquals(Fraction fraction) {
        return this.toFraction().approxEquals(fraction);
    }

    public MixedFraction scaleNumeratorAndDenominator(int n) {
        return new MixedFraction(this.whole, this.numerator * n, this.denominator * n);
    }

    public MixedFraction withReducedFractionPart() {
        Fraction fraction = this.getFractionPart().reduce();
        return new MixedFraction(this.whole, fraction.numerator, fraction.denominator);
    }

    public String toString() {
        return this.whole + " " + this.numerator + "/" + this.denominator;
    }

    @ConstructorProperties(value={"whole", "numerator", "denominator"})
    public MixedFraction(int n, int n2, int n3) {
        this.whole = n;
        this.numerator = n2;
        this.denominator = n3;
    }

    public int getWhole() {
        return this.whole;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MixedFraction)) {
            return false;
        }
        MixedFraction mixedFraction = (MixedFraction)object;
        if (!mixedFraction.canEqual(this)) {
            return false;
        }
        if (this.getWhole() != mixedFraction.getWhole()) {
            return false;
        }
        if (this.getNumerator() != mixedFraction.getNumerator()) {
            return false;
        }
        return this.getDenominator() == mixedFraction.getDenominator();
    }

    public boolean canEqual(Object object) {
        return object instanceof MixedFraction;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.getWhole();
        n = n * 31 + this.getNumerator();
        n = n * 31 + this.getDenominator();
        return n;
    }
}

