/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.radiobuttonstrip;

import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.radiobuttonstrip.ToggleButtonNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButtonStripControlPanelNode<T>
extends ControlPanelNode {
    public RadioButtonStripControlPanelNode(SettableProperty<T> settableProperty, List<Element<T>> list, int n) {
        this(settableProperty, list, n, new Color(230, 230, 230), new BasicStroke(2.0f), new Color(102, 102, 102), 9);
    }

    public RadioButtonStripControlPanelNode(SettableProperty<T> settableProperty, List<Element<T>> list, int n, Color color, BasicStroke basicStroke, Color color2, int n2) {
        super(new RadioButtonStripNode<T>(settableProperty, list, n), color, basicStroke, color2, n2);
    }

    public RadioButtonStripControlPanelNode(SettableProperty<T> settableProperty, List<Element<T>> list, int n, Color color, BasicStroke basicStroke, Color color2, int n2, double d, double d2) {
        super(new RadioButtonStripNode<T>(settableProperty, list, n, d, d2), color, basicStroke, color2, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Element<T> {
        public final PNode node;
        public final T value;
        public final IUserComponent component;

        public Element(PNode pNode, T t, IUserComponent iUserComponent) {
            this.node = pNode;
            this.value = t;
            this.component = iUserComponent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RadioButtonStripNode<T>
    extends PNode {
        public RadioButtonStripNode(SettableProperty<T> settableProperty, List<Element<T>> list, int n) {
            this(settableProperty, list, n, 4.0, 6.0);
        }

        public RadioButtonStripNode(final SettableProperty<T> settableProperty, final List<Element<T>> list, int n, final double d, final double d2) {
            double d3;
            double d4 = 0.0;
            double d5 = 0.0;
            for (Element<T> element : list) {
                PNode pNode = element.node;
                if (pNode.getFullBounds().getWidth() > d4) {
                    d4 = pNode.getFullBounds().getWidth();
                }
                if (!(pNode.getFullBounds().getHeight() > d5)) continue;
                d5 = pNode.getFullBounds().getHeight();
            }
            final double d6 = d3 = Math.max(d4, d5) + (double)n;
            HBox hBox = new HBox(10.0, new PNode[0]){
                {
                    super(d7, pNodeArray);
                    for (final Element element : list) {
                        PhetPPath phetPPath = new PhetPPath(new RoundRectangle2D.Double(-2.0, -2.0, d6 + 4.0, d3 + 4.0, 20.0, 20.0), null){
                            {
                                super(shape, paint);
                                ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode(element.node){
                                    {
                                        Point2D.Double double_ = new Point2D.Double(d6 / 2.0 - this.getFullWidth() / 2.0, d3 / 2.0 - this.getFullHeight() / 2.0);
                                        this.setOffset(double_);
                                    }
                                };
                                this.addChild(zeroOffsetNode);
                            }
                        };
                        this.addChild(new ToggleButtonNode(phetPPath, settableProperty.valueEquals(element.value), new VoidFunction0(){

                            public void apply() {
                                SimSharingManager.sendUserMessage(element.component, UserComponentTypes.button, UserActions.pressed);
                                settableProperty.set(element.value);
                            }
                        }, ToggleButtonNode.DEFAULT_BACKGROUND_COLOR, true, d, d2));
                    }
                }
            };
            this.addChild(hBox);
        }
    }
}

