/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.controlpanel;

import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.controlpanel.PaddedNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.pswing.PSwing;
import fj.F;
import fj.P2;
import fj.data.List;
import java.awt.geom.Line2D;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsOnOffPanel
extends PNode {
    public static final PhetFont FONT = new PhetFont(20, true);
    public static final F<Feature, List<PNode>> nodes = new F<Feature, List<PNode>>(){

        @Override
        public List<PNode> f(Feature feature) {
            return List.list(feature.on, feature.off);
        }
    };

    public SettingsOnOffPanel(List<Feature> list) {
        final List<PNode> list2 = list.bind(nodes);
        List<Feature> list3 = list.map(new F<Feature, Feature>(){

            @Override
            public Feature f(Feature feature) {
                return new Feature(new PaddedNode(PhetPNode.getMaxSize(list2), feature.off), new PaddedNode(PhetPNode.getMaxSize(list2), feature.on), feature.onProperty, feature.component);
            }
        });
        VBox vBox = new VBox(4.0, new PNode[0]);
        for (P2<Feature, Integer> p2 : list3.zipIndex()) {
            final Feature feature = p2._1();
            PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

                public void mouseReleased(PInputEvent pInputEvent) {
                    feature.onProperty.toggle();
                }
            };
            feature.on.addInputEventListener(pBasicInputEventHandler);
            feature.on.addInputEventListener(new CursorHandler());
            feature.off.addInputEventListener(pBasicInputEventHandler);
            feature.off.addInputEventListener(new CursorHandler());
            vBox.addChild(SettingsOnOffPanel.createRowNode(feature));
            feature.on.setTransparency((Boolean)feature.onProperty.get() != false ? 1.0f : 0.0f);
            feature.off.setTransparency((Boolean)feature.onProperty.get() != false ? 0.0f : 1.0f);
            if (p2._2() >= list3.length() - 1) continue;
            vBox.addChild(new PhetPPath(new Line2D.Double(0.0, 0.0, vBox.getFullWidth(), 0.0)));
        }
        this.addChild(new ZeroOffsetNode((PNode)vBox));
    }

    private static HBox createRowNode(final Feature feature) {
        PSwing pSwing = new PSwing(new PropertyRadioButton<Boolean>(UserComponentChain.chain(feature.component, "off"), PhetCommonResources.getString("Games.radioButton.off"), (SettableProperty)feature.onProperty, Boolean.valueOf(false)){
            {
                this.setFont(FONT);
                this.setOpaque(false);
            }
        });
        PSwing pSwing2 = new PSwing(new PropertyRadioButton<Boolean>(UserComponentChain.chain(feature.component, "on"), PhetCommonResources.getString("Games.radioButton.on"), (SettableProperty)feature.onProperty, Boolean.valueOf(true)){
            {
                this.setFont(FONT);
                this.setOpaque(false);
            }
        });
        return new HBox(4.0, new PNode(){
            {
                this.addChild(feature.on);
                this.addChild(feature.off);
                feature.onProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        if (bl.booleanValue()) {
                            feature.on.animateToTransparency(1.0f, 300L);
                            feature.off.animateToTransparency(0.0f, 300L);
                        } else {
                            feature.on.animateToTransparency(0.0f, 300L);
                            feature.off.animateToTransparency(1.0f, 300L);
                        }
                    }
                });
            }
        }, pSwing, pSwing2);
    }

    public static final class Feature {
        public final PNode off;
        public final PNode on;
        public final BooleanProperty onProperty;
        public final IUserComponent component;

        @ConstructorProperties(value={"off", "on", "onProperty", "component"})
        public Feature(PNode pNode, PNode pNode2, BooleanProperty booleanProperty, IUserComponent iUserComponent) {
            this.off = pNode;
            this.on = pNode2;
            this.onProperty = booleanProperty;
            this.component = iUserComponent;
        }

        public PNode getOff() {
            return this.off;
        }

        public PNode getOn() {
            return this.on;
        }

        public BooleanProperty getOnProperty() {
            return this.onProperty;
        }

        public IUserComponent getComponent() {
            return this.component;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Feature)) {
                return false;
            }
            Feature feature = (Feature)object;
            if (this.getOff() == null ? feature.getOff() != null : !this.getOff().equals(feature.getOff())) {
                return false;
            }
            if (this.getOn() == null ? feature.getOn() != null : !this.getOn().equals(feature.getOn())) {
                return false;
            }
            if (this.getOnProperty() == null ? feature.getOnProperty() != null : !this.getOnProperty().equals(feature.getOnProperty())) {
                return false;
            }
            return !(this.getComponent() == null ? feature.getComponent() != null : !this.getComponent().equals(feature.getComponent()));
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + (this.getOff() == null ? 0 : this.getOff().hashCode());
            n = n * 31 + (this.getOn() == null ? 0 : this.getOn().hashCode());
            n = n * 31 + (this.getOnProperty() == null ? 0 : this.getOnProperty().hashCode());
            n = n * 31 + (this.getComponent() == null ? 0 : this.getComponent().hashCode());
            return n;
        }

        public String toString() {
            return "SettingsOnOffPanel.Feature(off=" + this.getOff() + ", on=" + this.getOn() + ", onProperty=" + this.getOnProperty() + ", component=" + this.getComponent() + ")";
        }
    }
}

