/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.SessionCounter;
import edu.colorado.phet.common.phetcommon.application.SoftwareAgreement;
import edu.colorado.phet.common.phetcommon.application.SoftwareAgreementDialog;
import edu.colorado.phet.common.phetcommon.preferences.PhetPreferences;
import edu.colorado.phet.common.phetcommon.preferences.StatisticsDetailsDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.statistics.SessionMessage;
import edu.colorado.phet.common.phetcommon.view.PhetExit;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SoftwareAgreementManager {
    public static void validate(Frame frame, SessionMessage sessionMessage) {
        boolean bl = PhetPreferences.getInstance().isAlwaysShowSoftwareAgreement();
        int n = PhetPreferences.getInstance().getSoftwareAgreementVersion();
        int n2 = SoftwareAgreement.getInstance().getVersion();
        if (bl || n < n2) {
            SoftwareAgreementManager.negotiate(frame, sessionMessage);
        }
    }

    private static void negotiate(Frame frame, SessionMessage sessionMessage) {
        AcceptanceDialog acceptanceDialog = new AcceptanceDialog(frame, sessionMessage);
        acceptanceDialog.setVisible(true);
    }

    private static class AcceptanceDialog
    extends PaintImmediateDialog {
        private static final String TITLE = PhetCommonResources.getString("Common.softwareAgreement.title");
        private static final String ACCEPT_BUTTON = PhetCommonResources.getString("Common.softwareAgreement.accept");
        private static final String DECLINE_BUTTON = PhetCommonResources.getString("Common.softwareAgreement.decline");
        private JButton acceptButton;

        public AcceptanceDialog(Frame frame, SessionMessage sessionMessage) {
            super(frame);
            this.setTitle(TITLE);
            this.setModal(true);
            this.setResizable(false);
            JComponent jComponent = this.createMessagePanel(sessionMessage);
            JComponent jComponent2 = this.createButtonPanel();
            JPanel jPanel = new JPanel();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            jPanel.setLayout(easyGridBagLayout);
            int n = 0;
            int n2 = 0;
            easyGridBagLayout.addComponent(jComponent, n++, n2);
            easyGridBagLayout.addFilledComponent(new JSeparator(), n++, n2, 2);
            easyGridBagLayout.addFilledComponent(jComponent2, n++, n2, 2);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    AcceptanceDialog.this.decline();
                }
            });
            this.setContentPane(jPanel);
            this.pack();
            SwingUtils.centerWindowOnScreen(this);
            this.getRootPane().setDefaultButton(this.acceptButton);
            this.acceptButton.requestFocusInWindow();
        }

        private JComponent createMessagePanel(SessionMessage sessionMessage) {
            MessagePane messagePane = new MessagePane(this, sessionMessage);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.add(messagePane);
            return jPanel;
        }

        private JComponent createButtonPanel() {
            this.acceptButton = new JButton(ACCEPT_BUTTON);
            this.acceptButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AcceptanceDialog.this.accept();
                }
            });
            JButton jButton = new JButton(DECLINE_BUTTON);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AcceptanceDialog.this.decline();
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(this.acceptButton);
            jPanel.add(jButton);
            return jPanel;
        }

        private void accept() {
            int n = SoftwareAgreement.getInstance().getVersion();
            PhetPreferences.getInstance().setSoftwareAgreementVersion(n);
            this.dispose();
        }

        private void decline() {
            SessionCounter.getInstance().decrementCounts();
            PhetExit.exit();
        }
    }

    private static class MessagePane
    extends HTMLUtils.HTMLEditorPane {
        private static final String MESSAGE_PATTERN = PhetCommonResources.getString("Common.softwareAgreement.message");

        public MessagePane(final JDialog jDialog, final SessionMessage sessionMessage) {
            super("");
            Object[] objectArray = new Object[]{"showStatisticsDetails", "showSoftwareAgreements"};
            String string = MessageFormat.format(MESSAGE_PATTERN, objectArray);
            this.setText(HTMLUtils.createStyledHTMLFromFragment(string));
            this.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (hyperlinkEvent.getDescription().equals("showStatisticsDetails")) {
                            MessagePane.showStatisticsDetails(jDialog, sessionMessage);
                        } else if (hyperlinkEvent.getDescription().equals("showSoftwareAgreements")) {
                            MessagePane.showSoftwareAgreement(jDialog);
                        } else {
                            System.err.println("SoftwareAgreementManager.MessagePane.hyperlinkUpdate: unsupported hyperlink, description=" + hyperlinkEvent.getDescription());
                        }
                    }
                }
            });
            this.setBackground(new JPanel().getBackground());
        }

        private static void showStatisticsDetails(JDialog jDialog, SessionMessage sessionMessage) {
            new StatisticsDetailsDialog((Dialog)jDialog, sessionMessage).setVisible(true);
        }

        private static void showSoftwareAgreement(JDialog jDialog) {
            new SoftwareAgreementDialog(jDialog).setVisible(true);
        }
    }
}

